/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry.codecs;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.geometry.Geometry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.iterable.Extractor;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
public abstract class GeometryCodecIntegrationTest<T extends Geometry>
extends CCMDseTestsSupport {
    private final String cqlTypeName;
    private final Class<T> selfType;
    private final T baseSample;
    private final List<T> sampleData;

    public GeometryCodecIntegrationTest(String cqlTypeName, List<T> sampleData) {
        Preconditions.checkArgument((sampleData.size() >= 3 ? 1 : 0) != 0, (Object)("Must be at least 3 samples, was given " + sampleData.size()));
        this.cqlTypeName = cqlTypeName;
        this.baseSample = (Geometry)sampleData.get(0);
        this.selfType = this.baseSample.getClass();
        this.sampleData = sampleData;
    }

    @DataProvider
    public Object[][] sampleProvider() {
        int count = this.sampleData.size();
        Iterator<T> iterator = this.sampleData.iterator();
        Object[][] data = new Object[count + 1][1];
        for (int i = 0; i < count && iterator.hasNext(); ++i) {
            data[i][0] = iterator.next();
        }
        data[this.sampleData.size()][0] = null;
        return data;
    }

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TYPE udt1 (g '%s')", this.cqlTypeName), String.format("CREATE TABLE tbl (k uuid PRIMARY KEY, g '%s', l list<'%s'>, s set<'%s'>, m0 map<'%s',int>, m1 map<int,'%s'>, t tuple<'%s','%s','%s'>, u frozen<udt1>)", this.cqlTypeName, this.cqlTypeName, this.cqlTypeName, this.cqlTypeName, this.cqlTypeName, this.cqlTypeName, this.cqlTypeName, this.cqlTypeName), String.format("CREATE TABLE tblpk (k '%s' primary key, v int)", this.cqlTypeName), String.format("CREATE TABLE tblclustering (k0 int, k1 '%s', v int, primary key (k0, k1))", this.cqlTypeName));
    }

    protected TypeCodec<T> codec() {
        return this.cluster().getConfiguration().getCodecRegistry().codecFor(this.sampleData.get(0));
    }

    protected <V> void validate(UUID key, String columnName, V expected, TypeToken<V> type) {
        Row row = this.session().execute(String.format("SELECT k,%s FROM tbl where k=?", columnName), new Object[]{key}).one();
        Assertions.assertThat((Comparable)row.getUUID("k")).isEqualTo((Object)key);
        Assertions.assertThat((Object)row.get(columnName, type)).isEqualTo(expected);
        Assertions.assertThat((Object)row.get(1, type)).isEqualTo(expected);
    }

    protected void validate(UUID key, T expected) {
        this.validate(key, "g", expected, TypeToken.of(this.selfType));
    }

    @Test(groups={"short"}, dataProvider="sampleProvider")
    public void should_insert_using_format(T expected) throws Exception {
        String val = null;
        if (expected != null) {
            TypeCodec codec = this.cluster().getConfiguration().getCodecRegistry().codecFor(expected);
            val = codec.format(expected);
        }
        UUID key = UUIDs.random();
        this.session().execute(String.format("INSERT INTO tbl (k, g) VALUES (%s, %s)", key, val));
        this.validate(key, expected);
    }

    @Test(groups={"short"}, dataProvider="sampleProvider")
    public void should_insert_using_simple_statement_with_parameters(T expected) throws Exception {
        UUID key = UUIDs.random();
        this.session().execute("INSERT INTO tbl (k, g) VALUES (?, ?)", new Object[]{key, expected});
        this.validate(key, expected);
    }

    @Test(groups={"short"}, dataProvider="sampleProvider")
    public void should_insert_using_prepared_statement_with_parameters(T expected) throws Exception {
        UUID key = UUIDs.random();
        PreparedStatement prepared = this.session().prepare("INSERT INTO tbl (k, g) values (?, ?)");
        this.session().execute((Statement)prepared.bind(new Object[]{key, expected}));
        this.validate(key, expected);
    }

    @Test(groups={"short"})
    public void should_insert_as_list() throws Exception {
        UUID key = UUIDs.random();
        PreparedStatement prepared = this.session().prepare("INSERT INTO tbl (k, l) values (?, ?)");
        BoundStatement bs = prepared.bind();
        bs.setUUID(0, key);
        bs.setList(1, this.sampleData);
        this.session().execute((Statement)bs);
        this.validate(key, "l", this.sampleData, TypeTokens.listOf(this.selfType));
    }

    @Test(groups={"short"})
    public void should_insert_as_set() throws Exception {
        UUID key = UUIDs.random();
        HashSet asSet = Sets.newHashSet(this.sampleData);
        PreparedStatement prepared = this.session().prepare("INSERT INTO tbl (k, s) values (?, ?)");
        this.session().execute((Statement)prepared.bind(new Object[]{key, asSet}));
        this.validate(key, "s", asSet, TypeTokens.setOf(this.selfType));
    }

    @Test(groups={"short"})
    public void should_insert_as_map_keys() throws Exception {
        UUID key = UUIDs.random();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int count = 0;
        for (Geometry val : this.sampleData) {
            builder = builder.put((Object)val, (Object)count++);
        }
        ImmutableMap asMapKeys = builder.build();
        PreparedStatement prepared = this.session().prepare("INSERT INTO tbl (k, m0) values (?, ?)");
        this.session().execute((Statement)prepared.bind(new Object[]{key, asMapKeys}));
        this.validate(key, "m0", asMapKeys, TypeTokens.mapOf(this.selfType, Integer.class));
    }

    @Test(groups={"short"})
    public void should_insert_as_map_values() throws Exception {
        UUID key = UUIDs.random();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int count = 0;
        for (Geometry val : this.sampleData) {
            builder = builder.put((Object)count++, (Object)val);
        }
        ImmutableMap asMapValues = builder.build();
        PreparedStatement prepared = this.session().prepare("INSERT INTO tbl (k, m1) values (?, ?)");
        this.session().execute((Statement)prepared.bind(new Object[]{key, asMapValues}));
        this.validate(key, "m1", asMapValues, TypeTokens.mapOf(Integer.class, this.selfType));
    }

    @Test(groups={"short"})
    public void should_insert_as_tuple() throws Exception {
        UUID key = UUIDs.random();
        TupleType tupleType = TupleType.of((ProtocolVersion)this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion(), (CodecRegistry)this.cluster().getConfiguration().getCodecRegistry(), (DataType[])new DataType[]{this.codec().getCqlType(), this.codec().getCqlType(), this.codec().getCqlType()});
        TupleValue tuple = tupleType.newValue(new Object[]{this.sampleData.get(0), this.sampleData.get(1), this.sampleData.get(2)});
        PreparedStatement prepared = this.session().prepare("INSERT INTO tbl (k, t) values (?, ?)");
        this.session().execute((Statement)prepared.bind(new Object[]{key, tuple}));
        Row row = this.session().execute("SELECT k,t FROM tbl where k=?", new Object[]{key}).one();
        Assertions.assertThat((Comparable)row.getUUID("k")).isEqualTo((Object)key);
        Assertions.assertThat((Object)row.getTupleValue("t")).isEqualTo((Object)tuple);
        Assertions.assertThat((Object)row.getTupleValue(1)).isEqualTo((Object)tuple);
    }

    @Test(groups={"short"})
    public void should_insert_as_field_in_udt() throws Exception {
        UUID key = UUIDs.random();
        UserType udtType = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("udt1");
        Assertions.assertThat((Iterable)udtType).isNotNull();
        UDTValue value = udtType.newValue();
        value.set("g", this.sampleData.get(0), this.selfType);
        PreparedStatement prepared = this.session().prepare("INSERT INTO tbl (k, u) values (?, ?)");
        this.session().execute((Statement)prepared.bind(new Object[]{key, value}));
        Row row = this.session().execute("SELECT k,u FROM tbl where k=?", new Object[]{key}).one();
        Assertions.assertThat((Comparable)row.getUUID("k")).isEqualTo((Object)key);
        Assertions.assertThat((Object)row.getUDTValue("u")).isEqualTo((Object)value);
        Assertions.assertThat((Object)row.getUDTValue(1)).isEqualTo((Object)value);
    }

    @Test(groups={"short"})
    public void should_accept_as_partition_key() throws Exception {
        this.session().execute("INSERT INTO tblpk (k, v) VALUES (?,?)", new Object[]{this.baseSample, 1});
        ResultSet results = this.session().execute("SELECT k,v FROM tblpk");
        Row row = results.one();
        Geometry key = (Geometry)row.get("k", this.selfType);
        Assertions.assertThat((Object)key).isEqualTo(this.baseSample);
    }

    @Test(groups={"short"})
    public void should_accept_as_clustering_key() throws Exception {
        PreparedStatement insert = this.session().prepare("INSERT INTO tblclustering (k0, k1, v) values (?,?,?)");
        BatchStatement batchStatement = new BatchStatement();
        int count = 0;
        for (Geometry value : this.sampleData) {
            batchStatement.add((Statement)insert.bind(new Object[]{0, value, count++}));
        }
        this.session().execute((Statement)batchStatement);
        ResultSet result = this.session().execute("SELECT * from tblclustering where k0=?", new Object[]{0});
        List rows = result.all();
        ((ListAssert)Assertions.assertThat((List)rows).extracting(new Extractor<Row, T>(){

            public T extract(Row row) {
                return (Geometry)row.get("k1", GeometryCodecIntegrationTest.this.selfType);
            }
        }).containsOnlyElementsOf(this.sampleData)).hasSameSizeAs(this.sampleData);
    }
}

