/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry.codecs;

import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Utils;
import com.datastax.driver.dse.geometry.codecs.GeometryCodecTest;
import com.datastax.driver.dse.geometry.codecs.LineStringCodec;
import org.testng.annotations.DataProvider;

public class LineStringCodecTest
extends GeometryCodecTest<LineString, LineStringCodec> {
    private LineString lineString = new LineString(Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), new Point[]{Utils.p(40.0, 40.0)});

    public LineStringCodecTest() {
        super(LineStringCodec.INSTANCE);
    }

    @Override
    @DataProvider
    public Object[][] serde() {
        return new Object[][]{{null, null}, {this.lineString, this.lineString}};
    }

    @Override
    @DataProvider
    public Object[][] format() {
        return new Object[][]{{null, "NULL"}, {this.lineString, "'LINESTRING (30 10, 10 30, 40 40)'"}};
    }

    @Override
    @DataProvider
    public Object[][] parse() {
        return new Object[][]{{null, null}, {"", null}, {" ", null}, {"NULL", null}, {" NULL ", null}, {"'LINESTRING (30 10, 10 30, 40 40)'", this.lineString}, {" ' LineString (30 10, 10 30, 40 40 ) ' ", this.lineString}};
    }
}

