/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry.codecs;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.geometry.Utils;
import com.datastax.driver.dse.geometry.codecs.GeometryCodecIntegrationTest;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

@DseVersion(value="5.0.0")
public class PolygonCodecIntegrationTest
extends GeometryCodecIntegrationTest<Polygon> {
    static Polygon squareInMinDomain = new Polygon(Utils.p(Double.MIN_VALUE, Double.MIN_VALUE), Utils.p(Double.MIN_VALUE, 1.0), Utils.p(1.0, 1.0), new Point[]{Utils.p(1.0, Double.MIN_VALUE)});
    static Polygon triangle = new Polygon(Utils.p(-5.0, 10.0), Utils.p(5.0, 5.0), Utils.p(10.0, -5.0), new Point[0]);
    static Polygon complexPolygon = Polygon.builder().addRing(Utils.p(0.0, 0.0), Utils.p(0.0, 3.0), Utils.p(5.0, 3.0), new Point[]{Utils.p(5.0, 0.0)}).addRing(Utils.p(1.0, 1.0), Utils.p(1.0, 2.0), Utils.p(2.0, 2.0), new Point[]{Utils.p(2.0, 1.0)}).addRing(Utils.p(3.0, 1.0), Utils.p(3.0, 2.0), Utils.p(4.0, 2.0), new Point[]{Utils.p(4.0, 1.0)}).build();

    public PolygonCodecIntegrationTest() {
        super("PolygonType", Lists.newArrayList((Object[])new Polygon[]{squareInMinDomain, complexPolygon, triangle}));
    }

    @Test(groups={"short"})
    public void should_insert_and_retrieve_empty_polygon() {
        Polygon empty = Polygon.builder().build();
        UUID key = UUIDs.random();
        this.session().execute("INSERT INTO tbl (k, g) VALUES (?, ?)", new Object[]{key, empty});
        Row row = this.session().execute("SELECT g from tbl where k=?", new Object[]{key}).one();
        Assertions.assertThat((List)((Polygon)row.get("g", Polygon.class)).getInteriorRings()).isEmpty();
        Assertions.assertThat((List)((Polygon)row.get("g", Polygon.class)).getExteriorRing()).isEmpty();
    }
}

