/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.DseCluster;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CCMConfig(createKeyspace={false}, dse={true}, ccmProvider="configureCCM")
@DseVersion(value="5.0.0")
public class CCMGraphTestsSupport
extends CCMDseTestsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CCMGraphTestsSupport.class);
    private final String graphName = TestUtils.generateIdentifier("graph_");

    @Override
    public DseCluster.Builder createClusterBuilder() {
        return super.createClusterBuilder().withSocketOptions(new SocketOptions().setReadTimeoutMillis(60000));
    }

    @Override
    public void onTestContextInitialized() {
        this.createAndSetGraphConfig(1);
    }

    public void createAndSetGraphConfig(int rf) {
        String replicationConfig = "{'class': 'SimpleStrategy', 'replication_factor' : " + rf + "}";
        this.session().executeGraph("system.graph(name).option('graph.replication_config').set(replicationConfig).option('graph.system_replication_config').set(replicationConfig).ifNotExists().create()", (Map)ImmutableMap.of((Object)"name", (Object)this.graphName, (Object)"replicationConfig", (Object)replicationConfig));
        this.cluster().getConfiguration().getGraphOptions().setGraphName(this.graphName);
    }

    public void executeGraph(String ... statements) {
        this.executeGraph(Arrays.asList(statements));
    }

    public void executeGraph(Collection<String> statements) {
        assert (this.session() != null);
        for (String stmt : statements) {
            try {
                if (this.cluster().getMetadata().getAllHosts().size() > 1) {
                    Uninterruptibles.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
                }
                this.session().executeGraph(stmt);
            }
            catch (Exception e) {
                this.errorOut();
                LOGGER.error("Could not execute graph statement: " + stmt, (Throwable)e);
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public CCMBridge.Builder configureCCM() {
        return CCMBridge.builder().withWorkload(1, "graph").withDSEConfiguration("graph.gremlin_server.port", "__RANDOM_PORT__");
    }

    public String graphName() {
        return this.graphName;
    }
}

