/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.IgnoreJDK6Requirement;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.graph.DefaultEdge;
import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.EdgeAssert;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.Property;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.testng.annotations.Test;

@IgnoreJDK6Requirement
public class DefaultEdgeDeserializerTest {
    @Test(groups={"unit"})
    public void should_deserialize_as_edge_graphson_1_0() throws Exception {
        Edge edge = (Edge)GraphJsonUtils.readStringAsTree((String)Resources.toString((URL)this.getClass().getResource("/graphson-1.0/edge1.json"), (Charset)Charsets.UTF_8)).as(Edge.class);
        this.assertEdge(edge);
    }

    @Test(groups={"unit"})
    public void should_deserialize_as_edge_graphson_2_0() throws Exception {
        Edge edge = (Edge)GraphJsonUtils.readStringAsTreeGraphson20((String)Resources.toString((URL)this.getClass().getResource("/graphson-2.0/edge1.json"), (Charset)Charsets.UTF_8)).as(Edge.class);
        this.assertEdge(edge);
    }

    private void assertEdge(Edge edge) throws IOException {
        ((EdgeAssert)((Object)((EdgeAssert)((Object)((EdgeAssert)GraphAssertions.assertThat(edge).isInstanceOf(DefaultEdge.class)).hasLabel("battled"))).hasInVLabel("monster").hasOutVLabel("demigod").hasProperty("time"))).hasProperty("place", Point.fromWellKnownText((String)"POINT (39 22)"), Point.class);
        GraphAssertions.assertThat((Map)edge.getId().asMap()).containsKeys((Object[])new String[]{"out_vertex", "local_id", "in_vertex"});
        Map inVertex = (Map)edge.getId().asMap().get("in_vertex");
        GraphAssertions.assertThat((Map)inVertex).containsEntry((Object)"member_id", (Object)0).containsEntry((Object)"community_id", (Object)587008).containsEntry((Object)"~label", (Object)"monster");
        Map outVertex = (Map)edge.getId().asMap().get("out_vertex");
        GraphAssertions.assertThat((Map)outVertex).containsEntry((Object)"member_id", (Object)0).containsEntry((Object)"community_id", (Object)587008).containsEntry((Object)"~label", (Object)"demigod");
        GraphAssertions.assertThat((Map)edge.getInV().asMap()).containsEntry((Object)"member_id", (Object)0).containsEntry((Object)"community_id", (Object)587008).containsEntry((Object)"~label", (Object)"monster");
        GraphAssertions.assertThat((Map)edge.getOutV().asMap()).containsEntry((Object)"member_id", (Object)0).containsEntry((Object)"community_id", (Object)587008).containsEntry((Object)"~label", (Object)"demigod");
        Property place = edge.getProperty("place");
        GraphAssertions.assertThat((Object)place.getValue().as(Point.class)).isEqualTo((Object)Point.fromWellKnownText((String)"POINT (39 22)"));
    }
}

