/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.IgnoreJDK6Requirement;
import com.datastax.driver.dse.graph.DefaultVertex;
import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexAssert;
import com.datastax.driver.dse.graph.VertexProperty;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.testng.annotations.Test;

@IgnoreJDK6Requirement
public class DefaultVertexDeserializerTest {
    @Test(groups={"unit"})
    public void should_deserialize_as_vertex_graphson_1_0() throws Exception {
        Vertex vertex = (Vertex)GraphJsonUtils.readStringAsTree((String)Resources.toString((URL)this.getClass().getResource("/graphson-1.0/vertex1.json"), (Charset)Charsets.UTF_8)).as(Vertex.class);
        this.assertVertex(vertex);
    }

    @Test(groups={"unit"})
    public void should_deserialize_as_vertex_graphson_2_0() throws Exception {
        Vertex vertex = (Vertex)GraphJsonUtils.readStringAsTreeGraphson20((String)Resources.toString((URL)this.getClass().getResource("/graphson-2.0/vertex1.json"), (Charset)Charsets.UTF_8)).as(Vertex.class);
        this.assertVertex(vertex);
    }

    private void assertVertex(Vertex vertex) throws Exception {
        ((VertexAssert)((Object)((VertexAssert)GraphAssertions.assertThat(vertex).isInstanceOf(DefaultVertex.class)).hasLabel("god"))).hasProperty("name", "neptune").hasProperty("nicknames", "Neppy").hasProperty("nicknames", "Flipper").hasProperty("age", 4500);
        GraphAssertions.assertThat((Map)vertex.getId().asMap()).containsEntry((Object)"member_id", (Object)0).containsEntry((Object)"community_id", (Object)950424).containsEntry((Object)"~label", (Object)"god");
        Iterator nicknames = vertex.getProperties("nicknames");
        VertexProperty neppy = (VertexProperty)nicknames.next();
        GraphAssertions.assertThat(neppy).hasKey("nicknames").hasParent((Element)vertex).hasValue("Neppy").hasProperty("time");
        VertexProperty flipper = (VertexProperty)nicknames.next();
        GraphAssertions.assertThat(flipper).hasKey("nicknames").hasParent((Element)vertex).hasValue("Flipper").hasProperty("time");
    }
}

