/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.geometry.Utils;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexAssert;
import com.google.common.base.Charsets;
import com.google.common.net.InetAddresses;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class GraphDataTypeIntegrationTest
extends CCMGraphTestsSupport {
    Logger logger = LoggerFactory.getLogger(GraphDataTypeIntegrationTest.class);
    AtomicInteger schemaCounter = new AtomicInteger(0);
    private static final Pattern withBoundsPattern = Pattern.compile("^(.*\\(\\))\\.with.*Bounds.*$");

    boolean filterType(String type) {
        return false;
    }

    @DataProvider
    public static Object[][] dataTypeSamples() {
        return new Object[][]{{"Boolean()", true}, {"Boolean()", false}, {"Smallint()", (short)Short.MAX_VALUE}, {"Smallint()", (short)Short.MIN_VALUE}, {"Smallint()", (short)0}, {"Smallint()", (short)42}, {"Int()", Integer.MAX_VALUE}, {"Int()", Integer.MIN_VALUE}, {"Int()", 0}, {"Int()", 42}, {"Bigint()", Long.MAX_VALUE}, {"Bigint()", Long.MIN_VALUE}, {"Bigint()", 0L}, {"Double()", Double.MAX_VALUE}, {"Double()", Double.MIN_VALUE}, {"Double()", 0.0}, {"Double()", Math.PI}, {"Float()", Float.valueOf(Float.MAX_VALUE)}, {"Float()", Float.valueOf(Float.MIN_VALUE)}, {"Float()", Float.valueOf(0.0f)}, {"Text()", ""}, {"Text()", "75"}, {"Text()", "Lorem Ipsum"}, {"Inet()", InetAddresses.forString((String)"127.0.0.1")}, {"Inet()", InetAddresses.forString((String)"0:0:0:0:0:0:0:1")}, {"Inet()", InetAddresses.forString((String)"2001:db8:85a3:0:0:8a2e:370:7334")}, {"Uuid()", UUID.randomUUID()}, {"Uuid()", UUIDs.timeBased()}, {"Timestamp()", new Date(123L)}, {"Timestamp()", new Date(1488313909L)}, {"Blob()", "Hello World!".getBytes(Charsets.UTF_8)}, {"Decimal()", new BigDecimal("8675309.9998")}, {"Varint()", new BigInteger("8675309")}, {"Point().withBounds(-2, -2, 2, 2)", Utils.p(0.0, 1.0)}, {"Point().withBounds(-40, -40, 40, 40)", Utils.p(-5.0, 20.0)}, {"Linestring().withGeoBounds()", new LineString(Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), new Point[]{Utils.p(40.0, 40.0)})}, {"Polygon().withGeoBounds()", Polygon.builder().addRing(Utils.p(35.0, 10.0), Utils.p(45.0, 45.0), Utils.p(15.0, 40.0), new Point[]{Utils.p(10.0, 20.0), Utils.p(35.0, 10.0)}).addRing(Utils.p(20.0, 30.0), Utils.p(35.0, 35.0), Utils.p(30.0, 20.0), new Point[]{Utils.p(20.0, 30.0)}).build()}};
    }

    @DataProvider
    public static Object[][] dataTypeSamples51() {
        return new Object[][]{{"Date()", LocalDate.fromYearMonthDay((int)2016, (int)5, (int)12)}, {"Date()", "1999-07-29"}, {"Time()", "18:30:41.554"}, {"Time()", "18:30:41.554010034"}};
    }

    @Test(groups={"short"}, dataProvider="dataTypeSamples")
    public void should_create_and_retrieve_vertex_property(String type, Object input) {
        Matcher matcher;
        if (this.filterType(type)) {
            throw new SkipException("Type " + type + " marked as filtered for this test.");
        }
        int id = this.schemaCounter.incrementAndGet();
        VersionNumber dseVersion = CCMBridge.getGlobalDSEVersion();
        if (dseVersion != null && dseVersion.getMajor() == 5 && dseVersion.getMinor() == 0 && (matcher = withBoundsPattern.matcher(type)).matches()) {
            type = matcher.group(1);
            this.logger.warn("Replacing type definition '{}' with '{}' for DSE 5.0", (Object)matcher.group(), (Object)type);
        }
        String vertexLabel = "vertex" + id;
        String propertyName = "prop" + id;
        SimpleGraphStatement addVertexLabelAndProperty = new SimpleGraphStatement("schema.propertyKey(property)." + type + ".create()\nschema.vertexLabel(vertexLabel).properties(property).create()\nschema.vertexLabel(vertexLabel).index(property + 'Index').secondary().by(property).add()").set("vertexLabel", (Object)vertexLabel).set("property", (Object)propertyName);
        this.session().executeGraph((GraphStatement)addVertexLabelAndProperty);
        SimpleGraphStatement addV = new SimpleGraphStatement("g.addV(vertexLabel).property(propertyName, val)").set("vertexLabel", (Object)vertexLabel).set("propertyName", (Object)propertyName).set("val", input);
        GraphResultSet resultSet = this.session().executeGraph((GraphStatement)addV);
        this.validateVertexResult(resultSet, vertexLabel, propertyName, input);
        SimpleGraphStatement getV = new SimpleGraphStatement("g.V().hasLabel(vertexLabel).has(propertyName, val).next()").set("vertexLabel", (Object)vertexLabel).set("propertyName", (Object)propertyName).set("val", input);
        resultSet = this.session().executeGraph((GraphStatement)getV);
        this.validateVertexResult(resultSet, vertexLabel, propertyName, input);
    }

    @Test(groups={"short"}, dataProvider="dataTypeSamples51")
    @DseVersion(value="5.1.0")
    public void should_create_and_retrieve_vertex_property_51(String type, Object input) {
        this.should_create_and_retrieve_vertex_property(type, input);
    }

    private void validateVertexResult(GraphResultSet resultSet, String vertexLabel, String propertyName, Object expectedResult) {
        List results = resultSet.all();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Vertex v = ((GraphNode)results.get(0)).asVertex();
        VertexAssert a = (VertexAssert)((Object)GraphAssertions.assertThat(v).hasLabel(vertexLabel));
        if (expectedResult instanceof String) {
            a.hasProperty(propertyName, (String)expectedResult);
        } else if (expectedResult instanceof Integer) {
            a.hasProperty(propertyName, (Integer)expectedResult);
        } else if (expectedResult instanceof Boolean) {
            a.hasProperty(propertyName, (Boolean)expectedResult);
        } else if (expectedResult instanceof Long) {
            a.hasProperty(propertyName, (Long)expectedResult);
        } else if (expectedResult instanceof Double) {
            a.hasProperty(propertyName, (Double)expectedResult);
        }
        a.hasProperty(propertyName, expectedResult, (Class)expectedResult.getClass());
    }
}

