/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.Property;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import org.assertj.core.api.iterable.Extractor;

public class GraphExtractors {
    public static Extractor<GraphNode, Vertex> asVertex() {
        return new Extractor<GraphNode, Vertex>(){

            public Vertex extract(GraphNode input) {
                return input.asVertex();
            }
        };
    }

    public static Extractor<GraphNode, Edge> asEdge() {
        return new Extractor<GraphNode, Edge>(){

            public Edge extract(GraphNode input) {
                return input.asEdge();
            }
        };
    }

    public static Extractor<GraphNode, Property> asProperty() {
        return new Extractor<GraphNode, Property>(){

            public Property extract(GraphNode input) {
                return input.asProperty();
            }
        };
    }

    public static Extractor<GraphNode, VertexProperty> asVertexProperty() {
        return new Extractor<GraphNode, VertexProperty>(){

            public VertexProperty extract(GraphNode input) {
                return input.asVertexProperty();
            }
        };
    }

    public static Extractor<GraphNode, Path> asPath() {
        return new Extractor<GraphNode, Path>(){

            public Path extract(GraphNode input) {
                return input.asPath();
            }
        };
    }

    public static <T> Extractor<Property, T> propertyValueAs(final Class<T> clazz) {
        return new Extractor<Property, T>(){

            public T extract(Property input) {
                return input.getValue().as(clazz);
            }
        };
    }

    public static <T> Extractor<Vertex, T> propertyValueAs(final String propertyName, final Class<T> clazz) {
        return new Extractor<Vertex, T>(){

            public T extract(Vertex input) {
                return input.getProperty(propertyName).getValue().as(clazz);
            }
        };
    }

    public static <T> Extractor<VertexProperty, T> vertexPropertyValueAs(final Class<T> clazz) {
        return new Extractor<VertexProperty, T>(){

            public T extract(VertexProperty input) {
                return input.getValue().as(clazz);
            }
        };
    }

    public static <T> Extractor<Vertex, T> vertexPropertyValueAs(final String propertyName, final Class<T> clazz) {
        return new Extractor<Vertex, T>(){

            public T extract(Vertex input) {
                return input.getProperty(propertyName).getValue().as(clazz);
            }
        };
    }

    public static <T> Extractor<GraphNode, T> fieldAs(final String fieldName, final Class<T> clazz) {
        return new Extractor<GraphNode, T>(){

            public T extract(GraphNode input) {
                return input.get(fieldName).as(clazz);
            }
        };
    }

    public static <T> Extractor<GraphNode, T> elementAs(final int index, final Class<T> clazz) {
        return new Extractor<GraphNode, T>(){

            public T extract(GraphNode input) {
                return input.get(index).as(clazz);
            }
        };
    }
}

