/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.testng.annotations.DataProvider;

public class GraphFixtures {
    public static final String makeStrict = "schema.config().option('graph.schema_mode').set('production')";
    public static final String allowScans = "schema.config().option('graph.allow_scan').set('true')";
    public static final Collection<String> modern = Lists.newArrayList((Object[])new String[]{"schema.config().option('graph.schema_mode').set('production')\nschema.config().option('graph.allow_scan').set('true')\nschema.propertyKey('name').Text().ifNotExists().create();\nschema.propertyKey('age').Int().ifNotExists().create();\nschema.propertyKey('lang').Text().ifNotExists().create();\nschema.propertyKey('weight').Float().ifNotExists().create();\nschema.vertexLabel('person').properties('name', 'age').ifNotExists().create();\nschema.vertexLabel('software').properties('name', 'lang').ifNotExists().create();\nschema.edgeLabel('created').properties('weight').connection('person', 'software').ifNotExists().create();\nschema.edgeLabel('knows').properties('weight').connection('person', 'person').ifNotExists().create();", "Vertex marko = graph.addVertex(label, 'person', 'name', 'marko', 'age', 29);\nVertex vadas = graph.addVertex(label, 'person', 'name', 'vadas', 'age', 27);\nVertex lop = graph.addVertex(label, 'software', 'name', 'lop', 'lang', 'java');\nVertex josh = graph.addVertex(label, 'person', 'name', 'josh', 'age', 32);\nVertex ripple = graph.addVertex(label, 'software', 'name', 'ripple', 'lang', 'java');\nVertex peter = graph.addVertex(label, 'person', 'name', 'peter', 'age', 35);\nmarko.addEdge('knows', vadas, 'weight', 0.5f);\nmarko.addEdge('knows', josh, 'weight', 1.0f);\nmarko.addEdge('created', lop, 'weight', 0.4f);\njosh.addEdge('created', ripple, 'weight', 1.0f);\njosh.addEdge('created', lop, 'weight', 0.4f);\npeter.addEdge('created', lop, 'weight', 0.2f);"});
    public static Collection<String> metaProps = Lists.newArrayList((Object[])new String[]{"schema.config().option('graph.schema_mode').set('production')", "schema.config().option('graph.allow_scan').set('true')", "schema.propertyKey('sub_prop').Text().create()\nschema.propertyKey('sub_prop2').Text().create()\nschema.propertyKey('meta_prop').Text().properties('sub_prop', 'sub_prop2').create()\nschema.vertexLabel('meta_v').properties('meta_prop').create()"});
    public static Collection<String> multiProps = Lists.newArrayList((Object[])new String[]{"schema.config().option('graph.schema_mode').set('production')", "schema.config().option('graph.allow_scan').set('true')", "schema.propertyKey('multi_prop').Text().multiple().create()\nschema.vertexLabel('multi_v').properties('multi_prop').create()\n"});

    private static String geoType(String baseName, VersionNumber dseVersion) {
        Preconditions.checkNotNull((Object)dseVersion);
        return dseVersion.getMajor() == 5 && dseVersion.getMinor() == 0 ? baseName : baseName + ".withGeoBounds()";
    }

    private static String geoTypeWithBounds(String baseName, VersionNumber dseVersion, double lowerLimitX, double lowerLimitY, double higherLimitX, double higherLimitY) {
        Preconditions.checkNotNull((Object)dseVersion);
        return dseVersion.getMajor() == 5 && dseVersion.getMinor() == 0 ? baseName : baseName + String.format(".withBounds(%f, %f, %f, %f)", lowerLimitX, lowerLimitY, higherLimitX, higherLimitY);
    }

    public static Collection<String> gods(VersionNumber dseVersion) {
        return Lists.newArrayList((Object[])new String[]{makeStrict, allowScans, "schema.propertyKey('name').Text().ifNotExists().create();\nschema.propertyKey('age').Int().ifNotExists().create();\nschema.propertyKey('time').Timestamp().ifNotExists().create();\nschema.propertyKey('reason').Text().ifNotExists().create();\nschema.propertyKey('nicknames').Text().multiple().properties('time').ifNotExists().create();\nschema.propertyKey('place')." + GraphFixtures.geoType("Point()", dseVersion) + ".ifNotExists().create();", "schema.vertexLabel('titan').properties('name', 'age').ifNotExists().create();\nschema.vertexLabel('location').properties('name').ifNotExists().create();\nschema.vertexLabel('god').properties('name', 'age', 'nicknames').ifNotExists().create();\nschema.vertexLabel('demigod').properties('name', 'age').ifNotExists().create();\nschema.vertexLabel('human').properties('name', 'age').ifNotExists().create();\nschema.vertexLabel('monster').properties('name').ifNotExists().create();", "schema.edgeLabel('father').connection('god','god').connection('god','titan').connection('demigod','god').ifNotExists().create();\nschema.edgeLabel('mother').connection('demigod','human').ifNotExists().create();\nschema.edgeLabel('battled').properties('time', 'place').connection('god','god').connection('demigod','monster').ifNotExists().create();\nschema.edgeLabel('lives').properties('reason').connection('god','location').connection('monster','location').ifNotExists().create();\nschema.edgeLabel('pet').connection('god','monster').ifNotExists().create();\nschema.edgeLabel('brother').connection('god','god').ifNotExists().create();\n", "schema.vertexLabel('god').index('godsByName').secondary().by('name').add();\nschema.vertexLabel('god').index('godsByAge').secondary().by('age').add();\nschema.vertexLabel('demigod').index('battlesByTime').outE('battled').by('time').add();\nschema.vertexLabel('titan').index('titansByName').secondary().by('name').add();", "Vertex saturn = graph.addVertex(T.label, 'titan', 'name', 'saturn', 'age', 10000);\nVertex sky = graph.addVertex(T.label, 'location', 'name', 'sky');\nVertex sea = graph.addVertex(T.label, 'location', 'name', 'sea');\nVertex jupiter = graph.addVertex(T.label, 'god', 'name', 'jupiter', 'age', 5000);\nVertex neptune = graph.addVertex(T.label, 'god', 'name', 'neptune', 'age', 4500);\nVertex hercules = graph.addVertex(T.label, 'demigod', 'name', 'hercules', 'age', 30);\nVertex alcmene = graph.addVertex(T.label, 'human', 'name', 'alcmene', 'age', 45);\nVertex pluto = graph.addVertex(T.label, 'god', 'name', 'pluto', 'age', 4000);\nVertex nemean = graph.addVertex(T.label, 'monster', 'name', 'nemean');\nVertex hydra = graph.addVertex(T.label, 'monster', 'name', 'hydra');\nVertex cerberus = graph.addVertex(T.label, 'monster', 'name', 'cerberus');\nVertex tartarus = graph.addVertex(T.label, 'location', 'name', 'tartarus');\njupiter.addEdge('father', saturn);\njupiter.addEdge('lives', sky, 'reason', 'loves fresh breezes');\njupiter.addEdge('brother', neptune);\njupiter.addEdge('brother', pluto);\nneptune.addEdge('lives', sea).property('reason', 'loves waves');\nneptune.addEdge('brother', jupiter);\nneptune.addEdge('brother', pluto);\nneptune.addEdge('battled', neptune).property('time', Instant.ofEpochMilli(5));\nneptune.property('nicknames','Neppy','time', Instant.ofEpochMilli(22));\nneptune.property('nicknames','Flipper','time', Instant.ofEpochMilli(25));\nhercules.addEdge('father', jupiter);\nhercules.addEdge('mother', alcmene);\nhercules.addEdge('battled', nemean, 'time', Instant.ofEpochMilli(1), 'place', 'POINT(38.1 23.7)');\nhercules.addEdge('battled', hydra, 'time', Instant.ofEpochMilli(2), 'place', 'POINT(37.7 23.9)');\nhercules.addEdge('battled', cerberus, 'time', Instant.ofEpochMilli(12), 'place', 'POINT(39 22)');\npluto.addEdge('brother', jupiter);\npluto.addEdge('brother', neptune);\npluto.addEdge('lives', tartarus, 'reason', 'no fear of death');\npluto.addEdge('pet', cerberus);\ncerberus.addEdge('lives', tartarus);"});
    }

    public static Collection<String> addressBook(VersionNumber dseVersion) {
        return Lists.newArrayList((Object[])new String[]{makeStrict, allowScans, "schema.propertyKey('full_name').Text().create()\nschema.propertyKey('coordinates')." + GraphFixtures.geoType("Point()", dseVersion) + ".create()\nschema.propertyKey('linestringProp')." + GraphFixtures.geoType("Linestring()", dseVersion) + ".create()\nschema.propertyKey('polygonProp')." + GraphFixtures.geoType("Polygon()", dseVersion) + ".create()\nschema.propertyKey('city').Text().create()\nschema.propertyKey('state').Text().create()\nschema.propertyKey('description').Text().create()\nschema.propertyKey('alias').Text().create()\nschema.vertexLabel('user').properties('full_name', 'coordinates', 'city', 'state', 'description', 'alias').create()\nschema.vertexLabel('user').index('search').search().by('full_name').asString().by('coordinates').by('description').asText().by('alias').asString().add()\nschema.vertexLabel('user').index('searchLinestring').secondary().by('linestringProp').add()\nschema.vertexLabel('user').index('searchPolygon').secondary().by('polygonProp').add()\n", "g.addV('user').property('full_name', 'Paul Thomas Joe').property('city', 'Rochester').property('state', 'MN').property('coordinates', Geo.point(-92.46295, 44.0234)).property('description', 'Lives by the hospital').property('alias', 'mario')", "g.addV('user').property('full_name', 'George Bill Steve').property('city', 'Minneapolis').property('state', 'MN').property('coordinates', Geo.point(-93.266667, 44.9778)).property('description', 'A cold dude').property('alias', 'wario').property('linestringProp', 'LINESTRING (30 10, 10 30, 40 40)')", "g.addV('user').property('full_name', 'James Paul Joe').property('city', 'Chicago').property('state', 'IL').property('coordinates', Geo.point(-87.684722, 41.836944)).property('description', 'Likes to hang out').property('alias', 'bowser').property('polygonProp', 'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))')", "g.addV('user').property('full_name', 'Jill Alice').property('city', 'Atlanta').property('state', 'GA').property('coordinates', Geo.point(-84.39, 33.755)).property('description', 'Enjoys a very nice cold coca cola').property('alias', 'peach')"});
    }

    @DataProvider
    public static Object[][] indexTypes() {
        return new Object[][]{{"search"}, {"materialized"}, {"secondary"}};
    }

    public static Collection<String> textIndices() {
        Object[][] providerIndexTypes = GraphFixtures.indexTypes();
        String[] indexTypes = new String[providerIndexTypes.length];
        for (int i = 0; i < providerIndexTypes.length; ++i) {
            indexTypes[i] = (String)providerIndexTypes[i][0];
        }
        StringBuilder schema = new StringBuilder("");
        StringBuilder propertyKeys = new StringBuilder("");
        StringBuilder vertexLabel = new StringBuilder("schema.vertexLabel('user').properties(");
        StringBuilder indices = new StringBuilder("");
        StringBuilder vertex0 = new StringBuilder("g.addV('user')");
        StringBuilder vertex1 = new StringBuilder("g.addV('user')");
        StringBuilder vertex2 = new StringBuilder("g.addV('user')");
        StringBuilder vertex3 = new StringBuilder("g.addV('user')");
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (String indexType : indexTypes) {
            propertyKeys.append(String.format("schema.propertyKey('full_name_%s').Text().create()\nschema.propertyKey('description_%s').Text().create()\nschema.propertyKey('alias_%s').Text().create()\n", indexType, indexType, indexType));
            propertyNames.add("'full_name_" + indexType + "'");
            propertyNames.add("'description_" + indexType + "'");
            propertyNames.add("'alias_" + indexType + "'");
            if (indexType.equals("search")) {
                indices.append("schema.vertexLabel('user').index('search').search().by('full_name_search').asString().by('description_search').asText().by('alias_search').asString().add()\n");
            } else {
                indices.append(String.format("schema.vertexLabel('user').index('by_full_name_%s').%s().by('full_name_%s').add()\n", indexType, indexType, indexType));
                indices.append(String.format("schema.vertexLabel('user').index('by_description_%s').%s().by('description_%s').add()\n", indexType, indexType, indexType));
                indices.append(String.format("schema.vertexLabel('user').index('by_alias_name_%s').%s().by('alias_%s').add()\n", indexType, indexType, indexType));
            }
            vertex0.append(String.format(".property('full_name_%s', 'Paul Thomas Joe').property('description_%s', 'Lives by the hospital').property('alias_%s', 'mario')", indexType, indexType, indexType));
            vertex1.append(String.format(".property('full_name_%s', 'George Bill Steve').property('description_%s', 'A cold dude').property('alias_%s', 'wario')", indexType, indexType, indexType));
            vertex2.append(String.format(".property('full_name_%s', 'James Paul Joe').property('description_%s', 'Likes to hang out').property('alias_%s', 'bowser')", indexType, indexType, indexType));
            vertex3.append(String.format(".property('full_name_%s', 'Jill Alice').property('description_%s', 'Enjoys a very nice cold coca cola').property('alias_%s', 'peach')", indexType, indexType, indexType));
        }
        vertexLabel.append(Joiner.on((String)", ").join(propertyNames));
        vertexLabel.append(").create()\n");
        schema.append((CharSequence)propertyKeys).append((CharSequence)vertexLabel).append((CharSequence)indices);
        return Lists.newArrayList((Object[])new String[]{makeStrict, allowScans, schema.toString(), vertex0.toString(), vertex1.toString(), vertex2.toString(), vertex3.toString()});
    }

    public static Collection<String> geoIndices(VersionNumber dseVersion) {
        Object[][] providerIndexTypes = GraphFixtures.indexTypes();
        String[] indexTypes = new String[providerIndexTypes.length];
        for (int i = 0; i < providerIndexTypes.length; ++i) {
            indexTypes[i] = (String)providerIndexTypes[i][0];
        }
        StringBuilder schema = new StringBuilder("schema.propertyKey('full_name').Text().create()\n");
        StringBuilder propertyKeys = new StringBuilder("");
        StringBuilder vertexLabel = new StringBuilder("schema.vertexLabel('user').properties(");
        StringBuilder indices = new StringBuilder("");
        StringBuilder vertex0 = new StringBuilder("g.addV('user').property('full_name', 'Paul Thomas Joe')");
        StringBuilder vertex1 = new StringBuilder("g.addV('user').property('full_name', 'George Bill Steve')");
        String vertex2 = "g.addV('user').property('full_name', 'James Paul Joe')";
        StringBuilder vertex3 = new StringBuilder("g.addV('user').property('full_name', 'Jill Alice')");
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("'full_name'");
        for (String indexType : indexTypes) {
            propertyKeys.append(String.format("schema.propertyKey('pointPropWithBounds_%s').%s.create()\n", indexType, GraphFixtures.geoTypeWithBounds("Point()", dseVersion, 0.0, 0.0, 100.0, 100.0)));
            propertyKeys.append(String.format("schema.propertyKey('pointPropWithGeoBounds_%s').%s.create()\n", indexType, GraphFixtures.geoType("Point()", dseVersion)));
            propertyNames.add("'pointPropWithBounds_" + indexType + "'");
            propertyNames.add("'pointPropWithGeoBounds_" + indexType + "'");
            if (indexType.equals("search")) {
                indices.append(String.format("schema.vertexLabel('user').index('search').search().by('pointPropWithBounds_%s').withError(0.00001, 0.0).by('pointPropWithGeoBounds_%s').withError(0.00001, 0.0).add()\n", indexType, indexType));
            } else {
                indices.append(String.format("schema.vertexLabel('user').index('by_pointPropWithBounds_%s').%s().by('pointPropWithBounds_%s').add()\n", indexType, indexType, indexType));
                indices.append(String.format("schema.vertexLabel('user').index('by_pointPropWithGeoBounds_%s').%s().by('pointPropWithGeoBounds_%s').add()\n", indexType, indexType, indexType));
            }
            vertex0.append(String.format(".property('pointPropWithBounds_%s', 'POINT(40.0001 40)').property('pointPropWithGeoBounds_%s', 'POINT(40.0001 40)')", indexType, indexType));
            vertex1.append(String.format(".property('pointPropWithBounds_%s', 'POINT(40 40)').property('pointPropWithGeoBounds_%s', 'POINT(40 40)')", indexType, indexType));
            vertex3.append(String.format(".property('pointPropWithBounds_%s', 'POINT(30 30)').property('pointPropWithGeoBounds_%s', 'POINT(30 30)')", indexType, indexType));
        }
        vertexLabel.append(Joiner.on((String)", ").join(propertyNames));
        vertexLabel.append(").create()\n");
        schema.append((CharSequence)propertyKeys).append((CharSequence)vertexLabel).append((CharSequence)indices);
        return Lists.newArrayList((Object[])new String[]{makeStrict, allowScans, schema.toString(), vertex0.toString(), vertex1.toString(), vertex2, vertex3.toString()});
    }
}

