/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.geometry.Distance;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.geometry.Utils;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.google.common.net.InetAddresses;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class GraphJsonUtilsTest {
    UUID uuid = UUID.randomUUID();
    InetAddress inet4 = InetAddresses.forString((String)"127.0.0.1");
    InetAddress inet6 = InetAddresses.forString((String)"2001:db8:85a3:0:0:8a2e:370:7334");
    Point point = new Point(-1.0, 2.0);
    LineString lineString = new LineString(new Point(-1.0, 2.0), new Point(-2.0, 3.0), new Point[0]);
    Polygon polygon = Polygon.builder().addRing(Utils.p(35.0, 10.0), Utils.p(45.0, 45.0), Utils.p(15.0, 40.0), new Point[]{Utils.p(10.0, 20.0), Utils.p(35.0, 10.0)}).addRing(Utils.p(20.0, 30.0), Utils.p(35.0, 35.0), Utils.p(30.0, 20.0), new Point[]{Utils.p(20.0, 30.0)}).build();
    Distance distance = new Distance(this.point, 32.0);
    Date date = new Date(1458143616L);
    byte[] helloWorld = new byte[]{72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100, 33};
    ByteBuffer helloWorldBuf = ByteBuffer.wrap(this.helloWorld);

    @Test(groups={"unit"})
    public void should_serialize_supported_types_graphson_1_0() throws Exception {
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)true)).isEqualTo((Object)"true");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)-123)).isEqualTo((Object)"-123");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)-1234)).isEqualTo((Object)"-1234");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)-1234)).isEqualTo((Object)"-1234");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)-1234L)).isEqualTo((Object)"-1234");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)new BigInteger("-1234"))).isEqualTo((Object)"-1234");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)-1234.56)).isEqualTo((Object)"-1234.56");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)Float.valueOf(-1234.56f))).isEqualTo((Object)"-1234.56");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)new BigDecimal("-1234.56"))).isEqualTo((Object)"-1234.56");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)"foo")).isEqualTo((Object)"\"foo\"");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.date)).isEqualTo((Object)"1458143616");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.uuid)).isEqualTo((Object)("\"" + this.uuid.toString() + "\""));
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.inet4)).isEqualTo((Object)"\"127.0.0.1\"");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.inet6)).isEqualTo((Object)"\"2001:db8:85a3:0:0:8a2e:370:7334\"");
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.point)).isEqualTo((Object)("\"" + this.point.asWellKnownText() + "\""));
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.lineString)).isEqualTo((Object)("\"" + this.lineString.asWellKnownText() + "\""));
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.polygon)).isEqualTo((Object)("\"" + this.polygon.asWellKnownText() + "\""));
    }

    @Test(groups={"unit"})
    public void should_deserialize_supported_types_graphson_1_0() throws Exception {
        Assertions.assertThat((boolean)GraphJsonUtils.readStringAsTree((String)"true").asBoolean()).isEqualTo(true);
        Assertions.assertThat((Byte)((Byte)GraphJsonUtils.readStringAsTree((String)"-123").as(Byte.class))).isEqualTo((byte)-123);
        Assertions.assertThat((Short)((Short)GraphJsonUtils.readStringAsTree((String)"-1234").as(Short.class))).isEqualTo((short)-1234);
        Assertions.assertThat((int)GraphJsonUtils.readStringAsTree((String)"-1234").asInt()).isEqualTo(-1234);
        Assertions.assertThat((long)GraphJsonUtils.readStringAsTree((String)"-1234").asLong()).isEqualTo(-1234L);
        Assertions.assertThat((double)GraphJsonUtils.readStringAsTree((String)"-1234.56").asDouble()).isEqualTo(-1234.56);
        Assertions.assertThat((Float)((Float)GraphJsonUtils.readStringAsTree((String)"-1234.56").as(Float.class))).isEqualTo(-1234.56f);
        Assertions.assertThat((String)GraphJsonUtils.readStringAsTree((String)"\"foo\"").asString()).isEqualTo((Object)"foo");
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTree((String)"-1234").as(BigInteger.class))).isEqualTo((Object)new BigInteger("-1234"));
        Assertions.assertThat((BigDecimal)((BigDecimal)GraphJsonUtils.readStringAsTree((String)"-1234.56").as(BigDecimal.class))).isEqualTo((Object)new BigDecimal("-1234.56"));
        Assertions.assertThat((Date)((Date)GraphJsonUtils.readStringAsTree((String)"1458143616").as(Date.class))).isEqualTo((Object)this.date);
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTree((String)("\"" + this.uuid.toString() + "\"")).as(UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)"\"127.0.0.1\"").as(InetAddress.class)).isEqualTo((Object)this.inet4);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)"\"2001:db8:85a3:0:0:8a2e:370:7334\"").as(InetAddress.class)).isEqualTo((Object)this.inet6);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)"\"127.0.0.1\"").as(Inet4Address.class)).isEqualTo((Object)this.inet4);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)"\"2001:db8:85a3:0:0:8a2e:370:7334\"").as(Inet6Address.class)).isEqualTo((Object)this.inet6);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)("\"" + this.point.asWellKnownText() + "\"")).as(Geometry.class)).isEqualTo((Object)this.point);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)("\"" + this.lineString.asWellKnownText() + "\"")).as(Geometry.class)).isEqualTo((Object)this.lineString);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)("\"" + this.polygon.asWellKnownText() + "\"")).as(Geometry.class)).isEqualTo((Object)this.polygon);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)("\"" + this.point.asWellKnownText() + "\"")).as(Point.class)).isEqualTo((Object)this.point);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)("\"" + this.lineString.asWellKnownText() + "\"")).as(LineString.class)).isEqualTo((Object)this.lineString);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTree((String)("\"" + this.polygon.asWellKnownText() + "\"")).as(Polygon.class)).isEqualTo((Object)this.polygon);
    }

    @Test(groups={"unit"})
    public void should_deserialize_supported_types_graphson_2_0() throws Exception {
        Assertions.assertThat((boolean)GraphJsonUtils.readStringAsTreeGraphson20((String)"true").asBoolean()).isEqualTo(true);
        Assertions.assertThat((String)GraphJsonUtils.readStringAsTreeGraphson20((String)"\"foo\"").asString()).isEqualTo((Object)"foo");
        Assertions.assertThat((int)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"g:Int32\", \"@value\": -1234}").asInt()).isEqualTo(-1234);
        Assertions.assertThat((long)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"g:Int64\", \"@value\": -1234}").asLong()).isEqualTo(-1234L);
        Assertions.assertThat((double)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"g:Double\", \"@value\": -1234.56}").asDouble()).isEqualTo(-1234.56);
        Assertions.assertThat((Float)((Float)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"g:Float\", \"@value\": -1234.56}").as(Float.class))).isEqualTo(-1234.56f);
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"g:UUID\", \"@value\": \"" + this.uuid.toString() + "\"}")).as(UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Class)((Class)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"g:Class\", \"@value\": \"java.util.UUID\"}").as(Class.class))).isEqualTo(UUID.class);
        Assertions.assertThat((Date)((Date)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"g:Date\", \"@value\": 1458143616}").as(Date.class))).isEqualTo((Object)this.date);
        Assertions.assertThat((Character)((Character)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:Char\", \"@value\": 72}").as(Character.class))).isEqualTo('H');
        Assertions.assertThat((Byte)((Byte)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:Byte\", \"@value\": -123}").as(Byte.class))).isEqualTo((byte)-123);
        Assertions.assertThat((Short)((Short)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:Int16\", \"@value\": -1234}").as(Short.class))).isEqualTo((short)-1234);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:InetAddress\", \"@value\": \"127.0.0.1\"}").as(InetAddress.class)).isEqualTo((Object)this.inet4);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:InetAddress\", \"@value\": \"2001:db8:85a3:0:0:8a2e:370:7334\"}").as(InetAddress.class)).isEqualTo((Object)this.inet6);
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:BigInteger\", \"@value\": -1234}").as(BigInteger.class))).isEqualTo((Object)new BigInteger("-1234"));
        Assertions.assertThat((BigDecimal)((BigDecimal)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:BigDecimal\", \"@value\": -1234.56}").as(BigDecimal.class))).isEqualTo((Object)new BigDecimal("-1234.56"));
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"gx:ByteBuffer\",\"@value\":\"SGVsbG8gV29ybGQh\"}").as(ByteBuffer.class))).isEqualTo((Object)this.helloWorldBuf);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:Point\", \"@value\": \"" + this.point.asWellKnownText() + "\"}")).as(Geometry.class)).isEqualTo((Object)this.point);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:LineString\", \"@value\": \"" + this.lineString.asWellKnownText() + "\"}")).as(Geometry.class)).isEqualTo((Object)this.lineString);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:Polygon\", \"@value\": \"" + this.polygon.asWellKnownText() + "\"}")).as(Geometry.class)).isEqualTo((Object)this.polygon);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:Distance\", \"@value\": \"" + this.distance.asWellKnownText() + "\"}")).as(Geometry.class)).isEqualTo((Object)this.distance);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:Point\", \"@value\": \"" + this.point.asWellKnownText() + "\"}")).as(Point.class)).isEqualTo((Object)this.point);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:LineString\", \"@value\": \"" + this.lineString.asWellKnownText() + "\"}")).as(LineString.class)).isEqualTo((Object)this.lineString);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:Polygon\", \"@value\": \"" + this.polygon.asWellKnownText() + "\"}")).as(Polygon.class)).isEqualTo((Object)this.polygon);
        Assertions.assertThat((Object)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\": \"dse:Distance\", \"@value\": \"" + this.distance.asWellKnownText() + "\"}")).as(Distance.class)).isEqualTo((Object)this.distance);
        Assertions.assertThat((byte[])((byte[])GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\": \"dse:Blob\", \"@value\": \"SGVsbG8gV29ybGQh\"}").as(byte[].class))).isEqualTo((Object)this.helloWorld);
    }
}

