/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.graph.CCMGraphTestsOLAPSupport;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
public class GraphOLAPQueryTest
extends CCMGraphTestsOLAPSupport {
    private Collection<Host> executeOLAPQuery(int times, String graphSource) {
        SimpleGraphStatement statement = new SimpleGraphStatement("g.V().count()");
        if (graphSource != null) {
            statement = statement.setGraphSource(graphSource);
        }
        ArrayList triedHosts = Lists.newArrayListWithCapacity((int)times);
        for (int i = 0; i < times; ++i) {
            GraphResultSet result = this.session().executeGraph((GraphStatement)statement);
            List results = result.all();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            GraphNode r = (GraphNode)results.get(0);
            Assertions.assertThat((int)r.asInt()).isEqualTo(6);
            ExecutionInfo executionInfo = result.getExecutionInfo();
            Assertions.assertThat((int)executionInfo.getTriedHosts().size()).isGreaterThanOrEqualTo(1);
            triedHosts.add(executionInfo.getTriedHosts().get(0));
        }
        return triedHosts;
    }

    @Test(groups={"long"})
    public void should_target_analytics_node_with_analytics_source() {
        Host analyticsHost = this.findSparkMaster();
        Assertions.assertThat(this.executeOLAPQuery(10, "a")).containsOnly((Object[])new Host[]{analyticsHost});
    }

    @Test(groups={"long"})
    public void should_not_target_analytics_node_with_default_source() {
        Assertions.assertThat(this.executeOLAPQuery(10, "default")).containsAll((Iterable)this.cluster().getMetadata().getAllHosts());
    }

    @Test(groups={"long"})
    public void should_not_target_analytics_node_by_default() {
        Assertions.assertThat(this.executeOLAPQuery(10, null)).containsAll((Iterable)this.cluster().getMetadata().getAllHosts());
    }
}

