/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
public class GraphTimeoutsTests
extends CCMGraphTestsSupport {
    @Override
    public void onTestContextInitialized() {
        super.onTestContextInitialized();
        this.executeGraph(GraphFixtures.modern);
    }

    @Test(groups={"short"})
    public void should_wait_indefinitely_by_default() {
        long desiredTimeout = 1000L;
        this.session().executeGraph(new SimpleGraphStatement("graph.schema().config().option(\"graph.traversal_sources.drivertest1.evaluation_timeout\").set('" + desiredTimeout + " ms')").setGraphSource("drivertest1"));
        try {
            this.session().executeGraph(new SimpleGraphStatement("java.util.concurrent.TimeUnit.MILLISECONDS.sleep(35000L);1+1").setGraphSource("drivertest1"));
            Assertions.fail((String)"The request should have timed out");
        }
        catch (InvalidQueryException e) {
            Assertions.assertThat((String)e.toString()).contains(new CharSequence[]{"Script evaluation exceeded", "threshold of " + desiredTimeout + " ms"});
        }
    }

    @Test(groups={"short"})
    public void should_not_take_into_account_request_timeout_if_more_than_server_timeout() {
        long desiredTimeout = 1000L;
        int clientTimeout = 32000;
        this.session().executeGraph(new SimpleGraphStatement("graph.schema().config().option(\"graph.traversal_sources.drivertest2.evaluation_timeout\").set('" + desiredTimeout + " ms')").setGraphSource("drivertest2"));
        try {
            this.session().executeGraph(new SimpleGraphStatement("java.util.concurrent.TimeUnit.MILLISECONDS.sleep(35000L);1+1").setGraphSource("drivertest2").setReadTimeoutMillis(clientTimeout));
            Assertions.fail((String)"The request should have timed out");
        }
        catch (InvalidQueryException e) {
            Assertions.assertThat((String)e.toString()).contains(new CharSequence[]{"Script evaluation exceeded", "threshold of " + desiredTimeout + " ms"});
        }
    }

    @Test(groups={"short"})
    public void should_take_into_account_request_timeout_if_less_than_server_timeout() {
        long serverTimeout = 10000L;
        int desiredTimeout = 1000;
        this.session().executeGraph(new SimpleGraphStatement("graph.schema().config().option(\"graph.traversal_sources.drivertest3.evaluation_timeout\").set('" + serverTimeout + " ms')").setGraphSource("drivertest3"));
        try {
            this.session().executeGraph(new SimpleGraphStatement("java.util.concurrent.TimeUnit.MILLISECONDS.sleep(35000L);1+1").setGraphSource("drivertest3").setReadTimeoutMillis(desiredTimeout));
            Assertions.fail((String)"The request should have timed out");
        }
        catch (Exception e) {
            if (e instanceof InvalidQueryException) {
                Assertions.assertThat((String)e.toString()).contains(new CharSequence[]{"Script evaluation exceeded", "threshold of " + desiredTimeout + " ms"});
            }
            Assertions.assertThat((Throwable)e).isInstanceOf(OperationTimedOutException.class);
        }
    }
}

