/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.IgnoreJDK6Requirement;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@IgnoreJDK6Requirement
public class Jdk8Jsr310GraphJsonUtilsTest {
    Instant instant = Instant.parse("2016-05-12T16:12:23.999Z");
    Duration duration = Duration.parse("P2DT3H4M");

    @Test(groups={"unit"})
    public void should_serialize_supported_types_graphson_1_0() throws Exception {
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.instant)).isEqualTo((Object)("\"" + this.instant + "\""));
        Assertions.assertThat((String)GraphJsonUtils.writeValueAsString((Object)this.duration)).isEqualTo((Object)("\"" + this.duration + "\""));
    }

    @Test(groups={"unit"})
    public void should_deserialize_supported_types_graphson_1_0() throws Exception {
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTree((String)("\"" + this.instant + "\"")).as(Instant.class))).isEqualTo((Object)this.instant);
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTree((String)("\"" + this.duration + "\"")).as(Duration.class))).isEqualTo((Object)this.duration);
    }

    @Test(groups={"unit"})
    public void should_deserialize_supported_types_graphson_2_0() throws Exception {
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\":\"gx:Instant\",\"@value\":\"" + this.instant + "\"}")).as(Instant.class))).isEqualTo((Object)this.instant);
        Assertions.assertThat((Comparable)((Comparable)GraphJsonUtils.readStringAsTreeGraphson20((String)("{\"@type\":\"gx:Duration\",\"@value\":\"" + this.duration + "\"}")).as(Duration.class))).isEqualTo((Object)this.duration);
    }
}

