/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionTest;
import com.datastax.driver.core.SimpleStatement;
import java.util.Locale;
import org.assertj.core.api.Assertions;

public class CompressionTest
extends CCMTestsSupport {
    private static String TABLE = "test";

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compressionTest(ProtocolOptions.Compression compression) {
        this.cluster().getConfiguration().getProtocolOptions().setCompression(compression);
        try {
            Session compressedSession = this.cluster().connect(this.keyspace);
            String key = "execute_compressed_test_" + compression;
            ResultSet rs = compressedSession.execute(String.format(Locale.US, "INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", TABLE, key, "foo", 42, Float.valueOf(24.03f)));
            Assertions.assertThat((boolean)rs.isExhausted()).isTrue();
            String SELECT_ALL = String.format("SELECT * FROM %s WHERE k = '%s'", TABLE, key);
            SessionTest.checkExecuteResultSet(compressedSession.execute(SELECT_ALL), key);
            SessionTest.checkExecuteResultSet(compressedSession.execute(new SimpleStatement(SELECT_ALL).setConsistencyLevel(ConsistencyLevel.ONE)), key);
            SessionTest.checkExecuteResultSet(compressedSession.executeAsync(SELECT_ALL).getUninterruptibly(), key);
            SessionTest.checkExecuteResultSet(compressedSession.executeAsync(new SimpleStatement(SELECT_ALL).setConsistencyLevel(ConsistencyLevel.ONE)).getUninterruptibly(), key);
        }
        finally {
            this.cluster().getConfiguration().getProtocolOptions().setCompression(ProtocolOptions.Compression.NONE);
        }
    }
}

