/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PercentileTracker;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class CustomPercentileTrackerTest {
    @Test(groups={"unit"})
    public void should_return_negative_value_when_key_cant_be_computed() {
        int i;
        Cluster cluster0 = (Cluster)Mockito.mock(Cluster.class);
        final Host host0 = (Host)Mockito.mock(Host.class);
        Host host1 = (Host)Mockito.mock(Host.class);
        PercentileTracker tracker = new PercentileTracker(1000L, 3, 100, 50L){

            protected Object computeKey(Host host, Statement statement, Exception exception) {
                if (host == host0) {
                    return host;
                }
                return null;
            }
        };
        tracker.onRegister(cluster0);
        ArrayList statements = Lists.newArrayList((Object[])new Statement[]{(Statement)Mockito.mock(Statement.class), (Statement)Mockito.mock(Statement.class)});
        ArrayList exceptions = Lists.newArrayList((Object[])new Exception[]{new Exception(), null, new ReadTimeoutException(ConsistencyLevel.ANY, 1, 1, true), null, null});
        for (i = 0; i < 100; ++i) {
            tracker.update(host0, (Statement)statements.get(i % statements.size()), (Exception)exceptions.get(i % exceptions.size()), TimeUnit.NANOSECONDS.convert((i + 1) * 2, TimeUnit.MILLISECONDS));
            tracker.update(host1, (Statement)statements.get(i % statements.size()), (Exception)exceptions.get(i % exceptions.size()), TimeUnit.NANOSECONDS.convert(i + 1, TimeUnit.MILLISECONDS));
        }
        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        for (i = 1; i <= 99; ++i) {
            Assertions.assertThat((long)tracker.getLatencyAtPercentile(host0, null, null, (double)i)).isEqualTo((long)(i * 2));
            Assertions.assertThat((long)tracker.getLatencyAtPercentile(host1, null, null, (double)i)).isEqualTo(-1L);
        }
    }
}

