/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.CassandraVersion;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class CustomTypeTest
extends CCMTestsSupport {
    public static final DataType CUSTOM_DYNAMIC_COMPOSITE = DataType.custom((String)"org.apache.cassandra.db.marshal.DynamicCompositeType(s=>org.apache.cassandra.db.marshal.UTF8Type,i=>org.apache.cassandra.db.marshal.Int32Type)");
    public static final DataType CUSTOM_COMPOSITE = DataType.custom((String)"org.apache.cassandra.db.marshal.CompositeType(org.apache.cassandra.db.marshal.UTF8Type,org.apache.cassandra.db.marshal.Int32Type)");

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test (    k int,    c1 'DynamicCompositeType(s => UTF8Type, i => Int32Type)',    c2 'ReversedType(CompositeType(UTF8Type, Int32Type))',    c3 'Int32Type',    PRIMARY KEY (k, c1, c2)) WITH COMPACT STORAGE", "CREATE TABLE test_collection(    k int PRIMARY KEY,    c1 list<'DynamicCompositeType(s => UTF8Type, i => Int32Type)'>,    c2 map<'DynamicCompositeType(s => UTF8Type, i => Int32Type)', 'DynamicCompositeType(s => UTF8Type, i => Int32Type)'>)");
    }

    @Test(groups={"short"})
    public void should_serialize_and_deserialize_custom_types() {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("test");
        Assertions.assertThat(table.getColumn("c1")).isClusteringColumn().hasType(CUSTOM_DYNAMIC_COMPOSITE);
        Assertions.assertThat(table.getColumn("c2")).isClusteringColumn().hasType(CUSTOM_COMPOSITE).hasClusteringOrder(ClusteringOrder.DESC);
        Assertions.assertThat(table.getColumn("c3")).hasType(DataType.cint());
        this.session().execute("INSERT INTO test(k, c1, c2, c3) VALUES (0, 's@foo:i@32', 'foo:32', 1)");
        this.session().execute("INSERT INTO test(k, c1, c2, c3) VALUES (0, 'i@42', ':42', 2)");
        this.session().execute("INSERT INTO test(k, c1, c2, c3) VALUES (0, 'i@12:i@3', 'foo', 3)");
        ResultSet rs = this.session().execute("SELECT * FROM test");
        Row r = rs.one();
        Assertions.assertThat(r.getColumnDefinitions().getType("c1")).isEqualTo(CUSTOM_DYNAMIC_COMPOSITE);
        Assertions.assertThat(r.getColumnDefinitions().getType("c2")).isEqualTo(CUSTOM_COMPOSITE);
        Assertions.assertThat(r.getColumnDefinitions().getType("c3")).isEqualTo(DataType.cint());
        Assertions.assertThat((int)r.getInt("k")).isEqualTo(0);
        Assertions.assertThat((Comparable)r.getBytesUnsafe("c1")).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType(12, 3));
        Assertions.assertThat((Comparable)r.getBytesUnsafe("c2")).isEqualTo((Object)TestUtils.serializeForCompositeType("foo"));
        Assertions.assertThat((int)r.getInt("c3")).isEqualTo(3);
        r = rs.one();
        Assertions.assertThat((int)r.getInt("k")).isEqualTo(0);
        Assertions.assertThat((Comparable)r.getBytesUnsafe("c1")).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType(42));
        Assertions.assertThat((Comparable)r.getBytesUnsafe("c2")).isEqualTo((Object)TestUtils.serializeForCompositeType("", 42));
        Assertions.assertThat((int)r.getInt("c3")).isEqualTo(2);
        r = rs.one();
        Assertions.assertThat((int)r.getInt("k")).isEqualTo(0);
        Assertions.assertThat((Comparable)r.getBytesUnsafe("c1")).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType("foo", 32));
        Assertions.assertThat((Comparable)r.getBytesUnsafe("c2")).isEqualTo((Object)TestUtils.serializeForCompositeType("foo", 32));
        Assertions.assertThat((int)r.getInt("c3")).isEqualTo(1);
    }

    @Test(groups={"short"})
    public void should_serialize_and_deserialize_collections_of_custom_types() {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("test_collection");
        Assertions.assertThat(table.getColumn("c1")).hasType((DataType)DataType.list((DataType)CUSTOM_DYNAMIC_COMPOSITE));
        Assertions.assertThat(table.getColumn("c2")).hasType((DataType)DataType.map((DataType)CUSTOM_DYNAMIC_COMPOSITE, (DataType)CUSTOM_DYNAMIC_COMPOSITE));
        this.session().execute("INSERT INTO test_collection(k, c1, c2) VALUES (0, [ 's@foo:i@32' ], { 's@foo:i@32': 's@bar:i@42' })");
        Row r = this.session().execute("SELECT * FROM test_collection").one();
        Assertions.assertThat(r.getColumnDefinitions().getType("c1")).isEqualTo(DataType.list((DataType)CUSTOM_DYNAMIC_COMPOSITE));
        List c1 = r.getList("c1", ByteBuffer.class);
        Assertions.assertThat((Comparable)((Comparable)c1.get(0))).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType("foo", 32));
        Assertions.assertThat(r.getColumnDefinitions().getType("c2")).isEqualTo(DataType.map((DataType)CUSTOM_DYNAMIC_COMPOSITE, (DataType)CUSTOM_DYNAMIC_COMPOSITE));
        Map c2 = r.getMap("c2", ByteBuffer.class, ByteBuffer.class);
        Map.Entry entry = c2.entrySet().iterator().next();
        Assertions.assertThat((Comparable)((Comparable)entry.getKey())).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType("foo", 32));
        Assertions.assertThat((Comparable)((Comparable)entry.getValue())).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType("bar", 42));
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_handle_udt_with_custom_type() {
        this.session().execute("CREATE TYPE custom_udt (regular int, c1 'DynamicCompositeType(s => UTF8Type, i => Int32Type)', c2 'LongType')");
        this.session().execute("CREATE TABLE custom_udt_tbl (k int primary key, v frozen<custom_udt>)");
        UserType custom_udt = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("custom_udt");
        Assertions.assertThat(custom_udt.getFieldType("regular")).isEqualTo(DataType.cint());
        Assertions.assertThat(custom_udt.getFieldType("c1")).isEqualTo(CUSTOM_DYNAMIC_COMPOSITE);
        Assertions.assertThat(custom_udt.getFieldType("c2")).isEqualTo(DataType.bigint());
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("custom_udt_tbl");
        Assertions.assertThat(table.getColumn("v")).hasType((DataType)custom_udt);
        this.session().execute("INSERT INTO custom_udt_tbl (k, v) VALUES (0, {regular: 5, c1: 's@hello:i@93', c2: 400})");
        Row row = this.session().execute("select * from custom_udt_tbl").one();
        Assertions.assertThat(row.getColumnDefinitions().getType("k")).isEqualTo(DataType.cint());
        Assertions.assertThat(row.getColumnDefinitions().getType("v")).isEqualTo(custom_udt);
        UDTValue value = row.getUDTValue("v");
        Assertions.assertThat((int)value.getInt("regular")).isEqualTo(5);
        Assertions.assertThat((Comparable)value.getBytes("c1")).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType("hello", 93));
        Assertions.assertThat((long)value.getLong("c2")).isEqualTo(400L);
    }
}

