/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DirectedGraph;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class DirectedGraphTest {
    private Comparator<String> alphaComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };

    @Test(groups={"unit"})
    public void should_sort_empty_graph() {
        DirectedGraph g = new DirectedGraph(this.alphaComparator, (Object[])new String[0]);
        Assertions.assertThat((List)g.topologicalSort()).isEmpty();
    }

    @Test(groups={"unit"})
    public void should_sort_graph_with_one_node() {
        DirectedGraph g = new DirectedGraph(this.alphaComparator, (Object[])new String[]{"A"});
        Assertions.assertThat((List)g.topologicalSort()).containsExactly((Object[])new String[]{"A"});
    }

    @Test(groups={"unit"})
    public void should_sort_complex_graph() {
        DirectedGraph g = new DirectedGraph(this.alphaComparator, (Object[])new String[]{"A", "B", "C", "D", "E", "F", "G", "H"});
        g.addEdge((Object)"H", (Object)"F");
        g.addEdge((Object)"G", (Object)"E");
        g.addEdge((Object)"H", (Object)"D");
        g.addEdge((Object)"F", (Object)"D");
        g.addEdge((Object)"G", (Object)"D");
        g.addEdge((Object)"D", (Object)"C");
        g.addEdge((Object)"E", (Object)"C");
        g.addEdge((Object)"D", (Object)"B");
        g.addEdge((Object)"B", (Object)"A");
        List sorted = g.topologicalSort();
        Assertions.assertThat((List)sorted).containsExactly((Object[])new String[]{"G", "H", "E", "F", "D", "B", "C", "A"});
    }

    @Test(groups={"unit"})
    public void should_sort_complex_custom_comparator() {
        Comparator<Integer> highFirst = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2 - o1;
            }
        };
        DirectedGraph g = new DirectedGraph((Comparator)highFirst, (Object[])new Integer[]{0, 1, 2, 9, 10, 5, 6, 7});
        g.addEdge((Object)7, (Object)5);
        g.addEdge((Object)6, (Object)10);
        g.addEdge((Object)7, (Object)9);
        g.addEdge((Object)5, (Object)9);
        g.addEdge((Object)6, (Object)9);
        g.addEdge((Object)9, (Object)2);
        g.addEdge((Object)10, (Object)2);
        g.addEdge((Object)9, (Object)1);
        g.addEdge((Object)1, (Object)0);
        List sorted = g.topologicalSort();
        Assertions.assertThat((List)sorted).containsExactly((Object[])new Integer[]{7, 6, 5, 10, 9, 2, 1, 0});
    }

    @Test(groups={"unit"}, expectedExceptions={DriverInternalError.class})
    public void should_fail_to_sort_if_graph_has_a_cycle() {
        DirectedGraph g = new DirectedGraph(this.alphaComparator, (Object[])new String[]{"A", "B", "C"});
        g.addEdge((Object)"A", (Object)"B");
        g.addEdge((Object)"B", (Object)"C");
        g.addEdge((Object)"C", (Object)"B");
        g.topologicalSort();
    }

    @Test(groups={"unit"}, expectedExceptions={DriverInternalError.class})
    public void should_fail_to_sort_if_graph_is_a_cycle() {
        DirectedGraph g = new DirectedGraph(this.alphaComparator, (Object[])new String[]{"A", "B", "C"});
        g.addEdge((Object)"A", (Object)"B");
        g.addEdge((Object)"B", (Object)"C");
        g.addEdge((Object)"C", (Object)"A");
        g.topologicalSort();
    }
}

