/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Duration;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.UUID;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@CassandraVersion(value="3.10")
public class DurationIntegrationTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test_duration (pk uuid PRIMARY KEY, c1 duration)");
    }

    @DataProvider
    Object[][] durations() {
        return new Object[][]{{"1y2mo"}, {"-1y2mo"}, {"1Y2MO"}, {"2w"}, {"2d10h"}, {"2d"}, {"30h"}, {"30h20m"}, {"20m"}, {"56s"}, {"567ms"}, {"1950us"}, {"1950\u00b5s"}, {"1950000ns"}, {"1950000NS"}, {"-1950000ns"}, {"1y3mo2h10m"}, {"P1Y2D"}, {"P1Y2M"}, {"P2W"}, {"P1YT2H"}, {"-P1Y2M"}, {"P2D"}, {"PT30H"}, {"PT30H20M"}, {"PT20M"}, {"PT56S"}, {"P1Y3MT2H10M"}, {"P0001-00-02T00:00:00"}, {"P0001-02-00T00:00:00"}, {"P0001-00-00T02:00:00"}, {"-P0001-02-00T00:00:00"}, {"P0000-00-02T00:00:00"}, {"P0000-00-00T30:00:00"}, {"P0000-00-00T30:20:00"}, {"P0000-00-00T00:20:00"}, {"P0000-00-00T00:00:56"}, {"P0001-03-00T02:10:00"}};
    }

    @Test(groups={"short"}, dataProvider="durations")
    public void should_serialize_and_deserialize_durations(String durationStr) {
        UUID id = UUID.randomUUID();
        Duration expected = Duration.from((String)durationStr);
        this.session().execute("INSERT INTO test_duration (pk, c1) VALUES (?, ?)", new Object[]{id, expected});
        Row row = this.session().execute("SELECT c1 from test_duration WHERE pk = ?", new Object[]{id}).one();
        Duration actual = (Duration)row.get("c1", Duration.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test(groups={"short"})
    public void should_parse_column_metadata() {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("test_duration");
        Assertions.assertThat(table.getColumn("c1")).hasType(DataType.duration());
        Assertions.assertThat((String)table.asCQLQuery()).contains(new CharSequence[]{"c1 duration"});
    }
}

