/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.SortingLoadBalancingPolicy;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
public class EventDebouncerIntegrationTest
extends CCMTestsSupport {
    @CCMConfig(numberOfNodes={3}, createCluster={false}, dirtiesContext={true})
    @Test(groups={"long"})
    public void should_wait_until_load_balancing_policy_is_fully_initialized() throws InterruptedException {
        TestLoadBalancingPolicy policy = new TestLoadBalancingPolicy();
        final Cluster cluster = this.register(this.createClusterBuilderNoDebouncing().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).build());
        new Thread(){

            @Override
            public void run() {
                cluster.init();
            }
        }.start();
        policy.stop();
        this.ccm().stop(3);
        this.ccm().waitForDown(3);
        policy.proceed();
        Assertions.assertThat((boolean)policy.onDownCalledBeforeInit).isFalse();
        Assertions.assertThat((boolean)policy.onDownCalled()).isTrue();
        Assertions.assertThat((Iterable)policy.hosts).doesNotContain((Object[])new Host[]{TestUtils.findHost(cluster, 3)});
    }

    @CCMConfig(numberOfNodes={1})
    @Test(groups={"short"})
    public void should_change_debouncer_settings_dynamically() throws InterruptedException {
        int i;
        ControlConnection controlConnection;
        this.cluster().manager.controlConnection = controlConnection = (ControlConnection)Mockito.spy((Object)this.cluster().manager.controlConnection);
        for (i = 0; i < 10; ++i) {
            this.cluster().manager.submitNodeListRefresh();
            Thread.sleep(100L);
        }
        ((ControlConnection)Mockito.verify((Object)controlConnection, (VerificationMode)Mockito.timeout((long)10000L))).refreshNodeListAndTokenMap();
        Mockito.reset((Object[])new ControlConnection[]{controlConnection});
        this.cluster().getConfiguration().getQueryOptions().setRefreshNodeListIntervalMillis(0);
        for (i = 0; i < 10; ++i) {
            this.cluster().manager.submitNodeListRefresh();
            Thread.sleep(100L);
        }
        ((ControlConnection)Mockito.verify((Object)controlConnection, (VerificationMode)Mockito.timeout((long)10000L).times(10))).refreshNodeListAndTokenMap();
    }

    private class TestLoadBalancingPolicy
    extends SortingLoadBalancingPolicy {
        CyclicBarrier stop = new CyclicBarrier(2);
        CyclicBarrier proceed = new CyclicBarrier(2);
        CountDownLatch onDownCalled = new CountDownLatch(1);
        volatile boolean init = false;
        volatile boolean onDownCalledBeforeInit = false;

        private TestLoadBalancingPolicy() {
        }

        @Override
        public void init(Cluster cluster, Collection<Host> hosts) {
            try {
                this.stop.await(1L, TimeUnit.MINUTES);
                this.proceed.await(1L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage());
            }
            super.init(cluster, hosts);
            this.init = true;
        }

        @Override
        public void onDown(Host host) {
            if (!this.init) {
                this.onDownCalledBeforeInit = true;
            }
            super.onDown(host);
            if (host.getAddress().toString().contains(TestUtils.ipOfNode(3))) {
                this.onDownCalled.countDown();
            }
        }

        void stop() throws InterruptedException {
            try {
                this.stop.await(1L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage());
            }
        }

        void proceed() throws InterruptedException {
            try {
                this.proceed.await(1L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage());
            }
        }

        boolean onDownCalled() throws InterruptedException {
            return this.onDownCalled.await(1L, TimeUnit.MINUTES);
        }
    }
}

