/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.LocalDate;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class LocalDateTest {
    @Test(groups={"unit"})
    public void should_build_from_days_since_epoch() {
        Assertions.assertThat(LocalDate.fromDaysSinceEpoch((int)0)).hasMillisSinceEpoch(0L).hasDaysSinceEpoch(0).hasYearMonthDay(1970, 1, 1).hasToString("1970-01-01");
        Assertions.assertThat(LocalDate.fromDaysSinceEpoch((int)10)).hasMillisSinceEpoch(TimeUnit.DAYS.toMillis(10L)).hasDaysSinceEpoch(10).hasYearMonthDay(1970, 1, 11).hasToString("1970-01-11");
        Assertions.assertThat(LocalDate.fromDaysSinceEpoch((int)-10)).hasMillisSinceEpoch(TimeUnit.DAYS.toMillis(-10L)).hasDaysSinceEpoch(-10).hasYearMonthDay(1969, 12, 22).hasToString("1969-12-22");
        Assertions.assertThat(LocalDate.fromDaysSinceEpoch((int)Integer.MAX_VALUE)).hasMillisSinceEpoch(TimeUnit.DAYS.toMillis(Integer.MAX_VALUE)).hasDaysSinceEpoch(Integer.MAX_VALUE).hasYearMonthDay(5881580, 7, 11).hasToString("5881580-07-11");
        Assertions.assertThat(LocalDate.fromDaysSinceEpoch((int)Integer.MIN_VALUE)).hasMillisSinceEpoch(TimeUnit.DAYS.toMillis(Integer.MIN_VALUE)).hasDaysSinceEpoch(Integer.MIN_VALUE).hasYearMonthDay(-5877641, 6, 23).hasToString("-5877641-06-23");
    }

    @Test(groups={"unit"})
    public void should_build_from_millis_since_epoch() {
        Assertions.assertThat(LocalDate.fromMillisSinceEpoch((long)0L)).hasMillisSinceEpoch(0L).hasDaysSinceEpoch(0).hasYearMonthDay(1970, 1, 1).hasToString("1970-01-01");
        Assertions.assertThat(LocalDate.fromMillisSinceEpoch((long)3600L)).hasMillisSinceEpoch(0L).hasDaysSinceEpoch(0).hasYearMonthDay(1970, 1, 1).hasToString("1970-01-01");
        Assertions.assertThat(LocalDate.fromMillisSinceEpoch((long)-3600L)).hasMillisSinceEpoch(0L).hasDaysSinceEpoch(0).hasYearMonthDay(1970, 1, 1).hasToString("1970-01-01");
        try {
            LocalDate.fromMillisSinceEpoch((long)TimeUnit.DAYS.toMillis(-2147483649L));
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            LocalDate.fromMillisSinceEpoch((long)TimeUnit.DAYS.toMillis(0x80000000L));
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(groups={"unit"})
    public void should_build_from_year_month_day() {
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1)).hasMillisSinceEpoch(0L).hasDaysSinceEpoch(0).hasYearMonthDay(1970, 1, 1).hasToString("1970-01-01");
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1, (int)1, (int)1)).hasDaysSinceEpoch(-719162).hasYearMonthDay(1, 1, 1).hasToString("1-01-01");
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)0, (int)1, (int)1)).hasDaysSinceEpoch(-719528).hasYearMonthDay(0, 1, 1).hasToString("0-01-01");
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)-1, (int)1, (int)1)).hasDaysSinceEpoch(-719893).hasYearMonthDay(-1, 1, 1).hasToString("-1-01-01");
        try {
            LocalDate.fromYearMonthDay((int)1970, (int)0, (int)1);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            LocalDate.fromYearMonthDay((int)1970, (int)13, (int)1);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            LocalDate.fromYearMonthDay((int)1970, (int)1, (int)0);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            LocalDate.fromYearMonthDay((int)1970, (int)1, (int)32);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            LocalDate.fromYearMonthDay((int)6000000, (int)1, (int)1);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            LocalDate.fromYearMonthDay((int)-6000000, (int)1, (int)1);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(groups={"unit"})
    public void should_add_and_subtract_years() {
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(1, 1)).hasYearMonthDay(1971, 1, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(1, -1)).hasYearMonthDay(1969, 1, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(1, -1970)).hasYearMonthDay(0, 1, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(1, -1971)).hasYearMonthDay(-1, 1, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)0, (int)5, (int)12).add(1, 1)).hasYearMonthDay(1, 5, 12);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)-1, (int)5, (int)12).add(1, 1)).hasYearMonthDay(0, 5, 12);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)-1, (int)5, (int)12).add(1, 2)).hasYearMonthDay(1, 5, 12);
    }

    @Test(groups={"unit"})
    public void should_add_and_subtract_months() {
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(2, 2)).hasYearMonthDay(1970, 3, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(2, 24)).hasYearMonthDay(1972, 1, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(2, -5)).hasYearMonthDay(1969, 8, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1, (int)1, (int)1).add(2, -1)).hasYearMonthDay(0, 12, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)0, (int)1, (int)1).add(2, -1)).hasYearMonthDay(-1, 12, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)-1, (int)12, (int)1).add(2, 1)).hasYearMonthDay(0, 1, 1);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)0, (int)12, (int)1).add(2, 1)).hasYearMonthDay(1, 1, 1);
    }

    @Test(groups={"unit"})
    public void should_add_and_subtract_days() {
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)1, (int)1).add(5, 12)).hasYearMonthDay(1970, 1, 13);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1970, (int)3, (int)28).add(5, -40)).hasYearMonthDay(1970, 2, 16);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)1, (int)1, (int)1).add(5, -2)).hasYearMonthDay(0, 12, 30);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)0, (int)1, (int)1).add(5, -2)).hasYearMonthDay(-1, 12, 30);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)-1, (int)12, (int)31).add(5, 4)).hasYearMonthDay(0, 1, 4);
        Assertions.assertThat(LocalDate.fromYearMonthDay((int)0, (int)12, (int)25).add(5, 14)).hasYearMonthDay(1, 1, 8);
    }
}

