/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByNameData;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@CCMConfig(clusterProvider="createClusterBuilderNoDebouncing")
public class PreparedStatementTest
extends CCMTestsSupport {
    private static final String ALL_NATIVE_TABLE = "all_native";
    private static final String ALL_LIST_TABLE = "all_list";
    private static final String ALL_SET_TABLE = "all_set";
    private static final String ALL_MAP_TABLE = "all_map";
    private static final String SIMPLE_TABLE = "test";
    private static final String SIMPLE_TABLE2 = "test2";
    private ProtocolVersion protocolVersion;
    private Collection<DataType> primitiveTypes;

    private boolean exclude(DataType t) {
        return t.getName() == DataType.Name.COUNTER || t.getName() == DataType.Name.DURATION;
    }

    @Override
    public void onTestContextInitialized() {
        this.protocolVersion = this.ccm().getProtocolVersion();
        this.primitiveTypes = TestUtils.allPrimitiveTypes(this.protocolVersion);
        this.execute(this.createTestFixtures());
    }

    @AfterMethod(groups={"short"})
    public void tearDown() throws Exception {
        this.execute(String.format("TRUNCATE %s", ALL_NATIVE_TABLE), String.format("TRUNCATE %s", ALL_LIST_TABLE), String.format("TRUNCATE %s", ALL_SET_TABLE), String.format("TRUNCATE %s", ALL_MAP_TABLE), String.format("TRUNCATE %s", SIMPLE_TABLE), String.format("TRUNCATE %s", SIMPLE_TABLE2));
    }

    private List<String> createTestFixtures() {
        ArrayList<String> defs = new ArrayList<String>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_NATIVE_TABLE).append(" (k text PRIMARY KEY");
        for (DataType type : this.primitiveTypes) {
            if (this.exclude(type)) continue;
            sb.append(", c_").append(type).append(' ').append(type);
        }
        sb.append(')');
        defs.add(sb.toString());
        sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_LIST_TABLE).append(" (k text PRIMARY KEY");
        for (DataType type : this.primitiveTypes) {
            if (this.exclude(type)) continue;
            sb.append(", c_list_").append(type).append(" list<").append(type).append('>');
        }
        sb.append(')');
        defs.add(sb.toString());
        sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_SET_TABLE).append(" (k text PRIMARY KEY");
        for (DataType type : this.primitiveTypes) {
            if (this.exclude(type)) continue;
            sb.append(", c_set_").append(type).append(" set<").append(type).append('>');
        }
        sb.append(')');
        defs.add(sb.toString());
        sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_MAP_TABLE).append(" (k text PRIMARY KEY");
        for (DataType keyType : this.primitiveTypes) {
            if (this.exclude(keyType)) continue;
            for (DataType valueType : this.primitiveTypes) {
                if (this.exclude(valueType)) continue;
                sb.append(", c_map_").append(keyType).append('_').append(valueType).append(" map<").append(keyType).append(',').append(valueType).append('>');
            }
        }
        sb.append(')');
        defs.add(sb.toString());
        defs.add(String.format("CREATE TABLE %s (k text PRIMARY KEY, i int)", SIMPLE_TABLE));
        defs.add(String.format("CREATE TABLE %s (k text PRIMARY KEY, v text)", SIMPLE_TABLE2));
        return defs;
    }

    @Test(groups={"short"})
    public void preparedNativeTest() {
        for (DataType type : this.primitiveTypes) {
            if (this.exclude(type)) continue;
            String name = "c_" + type;
            PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_native', ?)", ALL_NATIVE_TABLE, name));
            BoundStatement bs = ps.bind();
            TestUtils.setValue(bs, name, type, TestUtils.getFixedValue(type));
            this.session().execute((Statement)bs);
            Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_native'", name, ALL_NATIVE_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, type, this.cluster().getConfiguration().getCodecRegistry()), (Object)TestUtils.getFixedValue(type), (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void preparedNativeTest2() {
        for (DataType type : this.primitiveTypes) {
            if (this.exclude(type)) continue;
            String name = "c_" + type;
            PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_native', ?)", ALL_NATIVE_TABLE, name));
            BoundStatement bs = ps.bind();
            TestUtils.setValue(bs, name, type, TestUtils.getFixedValue2(type));
            this.session().execute((Statement)bs);
            Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_native'", name, ALL_NATIVE_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, type, this.cluster().getConfiguration().getCodecRegistry()), (Object)TestUtils.getFixedValue2(type), (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareListTest() {
        for (DataType rawType : this.primitiveTypes) {
            if (this.exclude(rawType)) continue;
            String name = "c_list_" + rawType;
            DataType.CollectionType type = DataType.list((DataType)rawType);
            List value = (List)TestUtils.getFixedValue((DataType)type);
            PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_list', ?)", ALL_LIST_TABLE, name));
            BoundStatement bs = ps.bind();
            TestUtils.setValue(bs, name, (DataType)type, (Object)value);
            this.session().execute((Statement)bs);
            Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_list'", name, ALL_LIST_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, (DataType)type, this.cluster().getConfiguration().getCodecRegistry()), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareListTest2() {
        for (DataType rawType : this.primitiveTypes) {
            if (this.exclude(rawType)) continue;
            String name = "c_list_" + rawType;
            DataType.CollectionType type = DataType.list((DataType)rawType);
            List value = (List)TestUtils.getFixedValue2((DataType)type);
            PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_list', ?)", ALL_LIST_TABLE, name));
            BoundStatement bs = ps.bind();
            TestUtils.setValue(bs, name, (DataType)type, (Object)value);
            this.session().execute((Statement)bs);
            Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_list'", name, ALL_LIST_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, (DataType)type, this.cluster().getConfiguration().getCodecRegistry()), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareSetTest() {
        for (DataType rawType : this.primitiveTypes) {
            if (this.exclude(rawType)) continue;
            String name = "c_set_" + rawType;
            DataType.CollectionType type = DataType.set((DataType)rawType);
            Set value = (Set)TestUtils.getFixedValue((DataType)type);
            PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_set', ?)", ALL_SET_TABLE, name));
            BoundStatement bs = ps.bind();
            TestUtils.setValue(bs, name, (DataType)type, (Object)value);
            this.session().execute((Statement)bs);
            Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_set'", name, ALL_SET_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, (DataType)type, this.cluster().getConfiguration().getCodecRegistry()), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareSetTest2() {
        for (DataType rawType : this.primitiveTypes) {
            if (this.exclude(rawType)) continue;
            String name = "c_set_" + rawType;
            DataType.CollectionType type = DataType.set((DataType)rawType);
            Set value = (Set)TestUtils.getFixedValue2((DataType)type);
            PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_set', ?)", ALL_SET_TABLE, name));
            BoundStatement bs = ps.bind();
            TestUtils.setValue(bs, name, (DataType)type, (Object)value);
            this.session().execute((Statement)bs);
            Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_set'", name, ALL_SET_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, (DataType)type, this.cluster().getConfiguration().getCodecRegistry()), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareMapTest() {
        for (DataType rawKeyType : this.primitiveTypes) {
            if (this.exclude(rawKeyType)) continue;
            for (DataType rawValueType : this.primitiveTypes) {
                if (this.exclude(rawValueType)) continue;
                String name = "c_map_" + rawKeyType + '_' + rawValueType;
                DataType.CollectionType type = DataType.map((DataType)rawKeyType, (DataType)rawValueType);
                Map value = (Map)TestUtils.getFixedValue((DataType)type);
                PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_map', ?)", ALL_MAP_TABLE, name));
                BoundStatement bs = ps.bind();
                TestUtils.setValue(bs, name, (DataType)type, (Object)value);
                this.session().execute((Statement)bs);
                Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_map'", name, ALL_MAP_TABLE)).one();
                Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, (DataType)type, this.cluster().getConfiguration().getCodecRegistry()), (Object)value, (String)("For type " + type));
            }
        }
    }

    @Test(groups={"short"})
    public void prepareMapTest2() {
        for (DataType rawKeyType : this.primitiveTypes) {
            if (this.exclude(rawKeyType)) continue;
            for (DataType rawValueType : this.primitiveTypes) {
                if (this.exclude(rawValueType)) continue;
                String name = "c_map_" + rawKeyType + '_' + rawValueType;
                DataType.CollectionType type = DataType.map((DataType)rawKeyType, (DataType)rawValueType);
                Map value = (Map)TestUtils.getFixedValue2((DataType)type);
                PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_map', ?)", ALL_MAP_TABLE, name));
                BoundStatement bs = ps.bind();
                TestUtils.setValue(bs, name, (DataType)type, (Object)value);
                this.session().execute((Statement)bs);
                Row row = this.session().execute(String.format("SELECT %s FROM %s WHERE k='prepared_map'", name, ALL_MAP_TABLE)).one();
                Assert.assertEquals((Object)TestUtils.getValue((GettableByNameData)row, name, (DataType)type, this.cluster().getConfiguration().getCodecRegistry()), (Object)value, (String)("For type " + type));
            }
        }
    }

    @Test(groups={"short"})
    public void prepareWithNullValuesTest() throws Exception {
        PreparedStatement ps = this.session().prepare("INSERT INTO test2(k, v) VALUES (?, ?)");
        this.session().execute((Statement)ps.bind(new Object[]{"prepWithNull1", null}));
        BoundStatement bs = ps.bind();
        bs.setString("k", "prepWithNull2");
        bs.setString("v", null);
        this.session().execute((Statement)bs);
        ResultSet rs = this.session().execute("SELECT * FROM test2 WHERE k IN ('prepWithNull1', 'prepWithNull2')");
        Row r1 = rs.one();
        Row r2 = rs.one();
        Assert.assertTrue((boolean)rs.isExhausted());
        Assert.assertEquals((String)r1.getString("k"), (String)"prepWithNull1");
        Assert.assertEquals((String)r1.getString("v"), null);
        Assert.assertEquals((String)r2.getString("k"), (String)"prepWithNull2");
        Assert.assertEquals((String)r2.getString("v"), null);
    }

    @Test(groups={"short"})
    public void prepareStatementInheritPropertiesTest() {
        SimpleStatement toPrepare = new SimpleStatement("SELECT * FROM test WHERE k=?");
        toPrepare.setConsistencyLevel(ConsistencyLevel.QUORUM);
        toPrepare.setSerialConsistencyLevel(ConsistencyLevel.LOCAL_SERIAL);
        toPrepare.setRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE);
        if (this.protocolVersion.compareTo((Enum)ProtocolVersion.V4) >= 0) {
            toPrepare.setOutgoingPayload((Map)ImmutableMap.of((Object)"foo", (Object)Bytes.fromHexString((String)"0xcafebabe")));
        }
        toPrepare.setIdempotent(true);
        toPrepare.enableTracing();
        PreparedStatement prepared = this.session().prepare((RegularStatement)toPrepare);
        Assertions.assertThat((Comparable)prepared.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.QUORUM);
        Assertions.assertThat((Comparable)prepared.getSerialConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_SERIAL);
        Assertions.assertThat((Object)prepared.getRetryPolicy()).isEqualTo((Object)FallthroughRetryPolicy.INSTANCE);
        if (this.protocolVersion.compareTo((Enum)ProtocolVersion.V4) >= 0) {
            Assertions.assertThat((Map)prepared.getOutgoingPayload()).isEqualTo((Object)ImmutableMap.of((Object)"foo", (Object)Bytes.fromHexString((String)"0xcafebabe")));
        }
        Assertions.assertThat((Boolean)prepared.isIdempotent()).isTrue();
        Assertions.assertThat((boolean)prepared.isTracing()).isTrue();
        BoundStatement bs = prepared.bind(new Object[]{"someValue"});
        Assertions.assertThat((Comparable)bs.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.QUORUM);
        Assertions.assertThat((Comparable)bs.getSerialConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_SERIAL);
        Assertions.assertThat((Object)bs.getRetryPolicy()).isEqualTo((Object)FallthroughRetryPolicy.INSTANCE);
        if (this.protocolVersion.compareTo((Enum)ProtocolVersion.V4) >= 0) {
            Assertions.assertThat((Map)bs.getOutgoingPayload()).isEqualTo((Object)ImmutableMap.of((Object)"foo", (Object)Bytes.fromHexString((String)"0xcafebabe")));
        }
        Assertions.assertThat((Boolean)bs.isIdempotent()).isTrue();
        Assertions.assertThat((boolean)bs.isTracing()).isTrue();
    }

    @Test(groups={"docs"})
    public void printTableDefinitions() {
        for (String definition : this.createTestFixtures()) {
            System.out.println(definition);
        }
    }

    @Test(groups={"short"})
    public void batchTest() throws Exception {
        block2: {
            try {
                PreparedStatement ps1 = this.session().prepare("INSERT INTO test2(k, v) VALUES (?, ?)");
                PreparedStatement ps2 = this.session().prepare("INSERT INTO test2(k, v) VALUES (?, 'bar')");
                BatchStatement bs = new BatchStatement();
                bs.add((Statement)ps1.bind(new Object[]{"one", "foo"}));
                bs.add((Statement)ps2.bind(new Object[]{"two"}));
                bs.add((Statement)new SimpleStatement("INSERT INTO test2 (k, v) VALUES ('three', 'foobar')"));
                this.session().execute((Statement)bs);
                List all = this.session().execute("SELECT * FROM test2").all();
                Assert.assertEquals((String)"three", (String)((Row)all.get(0)).getString("k"));
                Assert.assertEquals((String)"foobar", (String)((Row)all.get(0)).getString("v"));
                Assert.assertEquals((String)"one", (String)((Row)all.get(1)).getString("k"));
                Assert.assertEquals((String)"foo", (String)((Row)all.get(1)).getString("v"));
                Assert.assertEquals((String)"two", (String)((Row)all.get(2)).getString("k"));
                Assert.assertEquals((String)"bar", (String)((Row)all.get(2)).getString("v"));
            }
            catch (UnsupportedFeatureException e) {
                if (this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion() == ProtocolVersion.V1) break block2;
                throw e;
            }
        }
    }

    @Test(groups={"short"})
    public void should_set_routing_key_on_case_insensitive_keyspace_and_table() {
        this.session().execute(String.format("CREATE TABLE %s.foo (i int PRIMARY KEY)", this.keyspace));
        PreparedStatement ps = this.session().prepare(String.format("INSERT INTO %s.foo (i) VALUES (?)", this.keyspace));
        BoundStatement bs = ps.bind(new Object[]{1});
        Assertions.assertThat((Comparable)bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE)).isNotNull();
    }

    @Test(groups={"short"})
    public void should_set_routing_key_on_case_sensitive_keyspace_and_table() {
        this.session().execute("CREATE KEYSPACE \"Test\" WITH replication = {   'class': 'SimpleStrategy',  'replication_factor': '1'}");
        this.session().execute("CREATE TABLE \"Test\".\"Foo\" (i int PRIMARY KEY)");
        PreparedStatement ps = this.session().prepare("INSERT INTO \"Test\".\"Foo\" (i) VALUES (?)");
        BoundStatement bs = ps.bind(new Object[]{1});
        Assertions.assertThat((Comparable)bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE)).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class})
    public void should_fail_when_prepared_on_another_cluster() throws Exception {
        Cluster otherCluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).build();
        try {
            PreparedStatement pst = otherCluster.connect().prepare("select * from system.peers where inet = ?");
            BoundStatement bs = pst.bind().setInet(0, InetAddress.getByName("localhost"));
            this.session().executeAsync((Statement)bs);
        }
        finally {
            otherCluster.close();
        }
    }

    @Test(groups={"short"})
    public void should_not_allow_unbound_value_on_bound_statement_when_protocol_lesser_than_v4() {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(this.ccm().getProtocolVersion(ProtocolVersion.V3)).build());
        Session session = cluster.connect();
        try {
            PreparedStatement ps = session.prepare("INSERT INTO " + this.keyspace + "." + SIMPLE_TABLE + " (k, i) VALUES (?, ?)");
            BoundStatement bs = ps.bind(new Object[]{"foo"});
            Assert.assertFalse((boolean)bs.isSet("i"));
            session.execute((Statement)bs);
            Assert.fail((String)"Should not have executed statement with UNSET values in protocol V3");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Unset value at index 1"});
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_not_allow_unbound_value_on_batch_statement_when_protocol_lesser_than_v4() {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(this.ccm().getProtocolVersion(ProtocolVersion.V3)).build());
        Session session = cluster.connect();
        try {
            PreparedStatement ps = session.prepare("INSERT INTO " + this.keyspace + "." + SIMPLE_TABLE + " (k, i) VALUES (?, ?)");
            BatchStatement batch = new BatchStatement();
            batch.add((Statement)ps.bind(new Object[]{"foo"}));
            session.execute((Statement)batch);
            Assert.fail((String)"Should not have executed statement with UNSET values in protocol V3");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Unset value at index 1"});
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.2.0")
    public void should_not_create_tombstone_when_unbound_value_on_bound_statement_and_protocol_v4() {
        PreparedStatement prepared = this.session().prepare("INSERT INTO test (k, i) VALUES (?, ?)");
        BoundStatement st1 = prepared.bind();
        st1.setString(0, "foo");
        st1.setInt(1, 1234);
        this.session().execute((Statement)st1);
        BoundStatement st2 = prepared.bind();
        st2.setString(0, "foo");
        this.session().execute((Statement)st2);
        SimpleStatement st3 = new SimpleStatement("SELECT i from test where k = 'foo'");
        st3.enableTracing();
        ResultSet rows = this.session().execute((Statement)st3);
        Assertions.assertThat((int)rows.one().getInt("i")).isEqualTo(1234);
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        QueryTrace queryTrace = rows.getExecutionInfo().getQueryTrace();
        this.assertEventsContain(queryTrace, "0 tombstone");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.2.0")
    public void should_unset_value_by_index() {
        PreparedStatement prepared = this.session().prepare("INSERT INTO test (k, i) VALUES (?, ?)");
        BoundStatement bound = prepared.bind();
        bound.setString(0, "foo");
        bound.setInt(1, 1234);
        bound.unset(1);
        Assertions.assertThat((boolean)bound.isSet(1)).isFalse();
        this.session().execute((Statement)bound);
        ResultSet rows = this.session().execute(new SimpleStatement("SELECT i from test where k = 'foo'").enableTracing());
        Assertions.assertThat((boolean)rows.one().isNull("i"));
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        QueryTrace queryTrace = rows.getExecutionInfo().getQueryTrace();
        this.assertEventsContain(queryTrace, "0 tombstone");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.2.0")
    public void should_unset_value_by_name() {
        PreparedStatement prepared = this.session().prepare("INSERT INTO test (k, i) VALUES (:k, :i)");
        BoundStatement bound = prepared.bind();
        bound.setString("k", "foo");
        bound.setInt("i", 1234);
        bound.unset("i");
        Assertions.assertThat((boolean)bound.isSet("i")).isFalse();
        this.session().execute((Statement)bound);
        ResultSet rows = this.session().execute(new SimpleStatement("SELECT i from test where k = 'foo'").enableTracing());
        Assertions.assertThat((boolean)rows.one().isNull("i"));
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        QueryTrace queryTrace = rows.getExecutionInfo().getQueryTrace();
        this.assertEventsContain(queryTrace, "0 tombstone");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.2.0")
    public void should_not_create_tombstone_when_unbound_value_on_batch_statement_and_protocol_v4() {
        PreparedStatement prepared = this.session().prepare("INSERT INTO test (k, i) VALUES (?, ?)");
        BoundStatement st1 = prepared.bind();
        st1.setString(0, "foo");
        st1.setInt(1, 1234);
        this.session().execute((Statement)new BatchStatement().add((Statement)st1));
        BoundStatement st2 = prepared.bind();
        st2.setString(0, "foo");
        this.session().execute((Statement)new BatchStatement().add((Statement)st2));
        SimpleStatement st3 = new SimpleStatement("SELECT i from test where k = 'foo'");
        st3.enableTracing();
        ResultSet rows = this.session().execute((Statement)st3);
        Assertions.assertThat((int)rows.one().getInt("i")).isEqualTo(1234);
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        QueryTrace queryTrace = rows.getExecutionInfo().getQueryTrace();
        this.assertEventsContain(queryTrace, "0 tombstone");
    }

    @Test(groups={"long"})
    public void should_create_tombstone_when_null_value_on_bound_statement() {
        PreparedStatement prepared = this.session().prepare("INSERT INTO test (k, i) VALUES (?, ?)");
        BoundStatement st1 = prepared.bind();
        st1.setString(0, "foo");
        st1.setToNull(1);
        this.session().execute((Statement)st1);
        SimpleStatement st2 = new SimpleStatement("SELECT i from test where k = 'foo'");
        st2.enableTracing();
        ResultSet rows = this.session().execute((Statement)st2);
        Assertions.assertThat((boolean)rows.one().isNull(0)).isTrue();
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        QueryTrace queryTrace = rows.getExecutionInfo().getQueryTrace();
        this.assertEventsContain(queryTrace, "1 tombstone");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_create_tombstone_when_null_value_on_batch_statement() {
        PreparedStatement prepared = this.session().prepare("INSERT INTO test (k, i) VALUES (?, ?)");
        BoundStatement st1 = prepared.bind();
        st1.setString(0, "foo");
        st1.setToNull(1);
        this.session().execute((Statement)new BatchStatement().add((Statement)st1));
        SimpleStatement st2 = new SimpleStatement("SELECT i from test where k = 'foo'");
        st2.enableTracing();
        ResultSet rows = this.session().execute((Statement)st2);
        Assertions.assertThat((boolean)rows.one().isNull(0)).isTrue();
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        QueryTrace queryTrace = rows.getExecutionInfo().getQueryTrace();
        this.assertEventsContain(queryTrace, "1 tombstone");
    }

    private void assertEventsContain(QueryTrace queryTrace, String toFind) {
        for (QueryTrace.Event event : queryTrace.getEvents()) {
            if (!event.getDescription().contains(toFind)) continue;
            return;
        }
        Assert.fail((String)("Did not find '" + toFind + "' in trace"));
    }

    @Test(groups={"short"})
    public void should_propagate_idempotence_in_statements() {
        this.session().execute(String.format("CREATE TABLE %s.idempotencetest (i int PRIMARY KEY)", this.keyspace));
        SimpleStatement statement = new SimpleStatement(String.format("SELECT * FROM %s.idempotencetest WHERE i = ?", this.keyspace));
        PreparedStatement prepared = this.session().prepare((RegularStatement)statement);
        BoundStatement bound = prepared.bind(new Object[]{1});
        Assertions.assertThat((Boolean)prepared.isIdempotent()).isNull();
        Assertions.assertThat((Boolean)bound.isIdempotent()).isNull();
        statement.setIdempotent(true);
        prepared = this.session().prepare((RegularStatement)statement);
        bound = prepared.bind(new Object[]{1});
        Assertions.assertThat((Boolean)prepared.isIdempotent()).isTrue();
        Assertions.assertThat((Boolean)bound.isIdempotent()).isTrue();
        statement.setIdempotent(false);
        prepared = this.session().prepare((RegularStatement)statement);
        bound = prepared.bind(new Object[]{1});
        Assertions.assertThat((Boolean)prepared.isIdempotent()).isFalse();
        Assertions.assertThat((Boolean)bound.isIdempotent()).isFalse();
        prepared.setIdempotent(Boolean.valueOf(true));
        bound = prepared.bind(new Object[]{1});
        Assertions.assertThat((Boolean)bound.isIdempotent()).isTrue();
    }
}

