/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Duration;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;

public class PrimitiveTypeSamples {
    static Map<DataType, Object> samples(ProtocolVersion protocolVersion) {
        try {
            final Set<DataType> primitiveTypes = TestUtils.allPrimitiveTypes(protocolVersion);
            ImmutableMap data = ImmutableMap.builder().put((Object)DataType.ascii(), (Object)"ascii").put((Object)DataType.bigint(), (Object)Long.MAX_VALUE).put((Object)DataType.blob(), (Object)Bytes.fromHexString((String)"0xCAFE")).put((Object)DataType.cboolean(), (Object)Boolean.TRUE).put((Object)DataType.decimal(), (Object)new BigDecimal("12.3E+7")).put((Object)DataType.cdouble(), (Object)Double.MAX_VALUE).put((Object)DataType.cfloat(), (Object)Float.valueOf(Float.MAX_VALUE)).put((Object)DataType.inet(), (Object)InetAddress.getByName("123.123.123.123")).put((Object)DataType.tinyint(), (Object)127).put((Object)DataType.smallint(), (Object)Short.MAX_VALUE).put((Object)DataType.cint(), (Object)Integer.MAX_VALUE).put((Object)DataType.duration(), (Object)Duration.from((String)"PT30H20M")).put((Object)DataType.text(), (Object)"text").put((Object)DataType.timestamp(), (Object)new Date(872835240000L)).put((Object)DataType.date(), (Object)LocalDate.fromDaysSinceEpoch((int)16071)).put((Object)DataType.time(), (Object)54012123450000L).put((Object)DataType.timeuuid(), (Object)UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66")).put((Object)DataType.uuid(), (Object)UUID.fromString("067e6162-3b6f-4ae2-a171-2470b63dff00")).put((Object)DataType.varint(), (Object)new BigInteger(Integer.toString(Integer.MAX_VALUE) + "000")).build();
            Map result = Maps.filterKeys((Map)data, (Predicate)new Predicate<DataType>(){

                public boolean apply(DataType input) {
                    return primitiveTypes.contains(input);
                }
            });
            ArrayList tmp = Lists.newArrayList(primitiveTypes);
            tmp.removeAll(result.keySet());
            ArrayList expectedFilteredTypes = Lists.newArrayList((Object[])new DataType[]{DataType.counter()});
            ((AbstractListAssert)Assertions.assertThat((List)tmp).as("new datatype not covered in test", new Object[0])).containsOnlyElementsOf((Iterable)expectedFilteredTypes);
            return result;
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }
}

