/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.utils.CassandraVersion;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CassandraVersion(value="3.10")
public class ProtocolBetaVersionTest
extends CCMTestsSupport {
    @Test(groups={"short"}, enabled=false)
    public void should_not_initialize_when_version_explicitly_required_and_beta_flag_is_set() throws Exception {
        try {
            Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(ProtocolVersion.V4).allowBetaProtocolVersion().build();
            Assertions.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Can't use beta flag with initial protocol version of V4");
        }
    }

    @Test(groups={"short"}, enabled=false)
    public void should_not_initialize_when_beta_flag_is_set_and_version_explicitly_required() throws Exception {
        try {
            Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).allowBetaProtocolVersion().withProtocolVersion(ProtocolVersion.V4).build();
            Assertions.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Can not set the version explicitly if `allowBetaProtocolVersion` was used.");
        }
    }

    @Test(groups={"short"}, enabled=false)
    public void should_not_connect_when_beta_version_explicitly_required_and_flag_not_set() throws Exception {
        try {
            Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(ProtocolVersion.V5).build();
            Assertions.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).startsWith((CharSequence)"Can not use V5 protocol version. Newest supported protocol version is: V4");
        }
    }

    @Test(groups={"short"}, enabled=false)
    public void should_connect_with_beta_when_no_version_explicitly_required_and_flag_set() throws Exception {
        Cluster cluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).allowBetaProtocolVersion().build();
        cluster.connect();
        Assertions.assertThat((Comparable)cluster.getConfiguration().getProtocolOptions().getProtocolVersion()).isEqualTo((Object)ProtocolVersion.V5);
    }

    @Test(groups={"short"}, enabled=false)
    public void should_connect_after_renegotiation_when_no_version_explicitly_required_and_flag_not_set() throws Exception {
        Cluster cluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).build();
        cluster.connect();
        Assertions.assertThat((Comparable)cluster.getConfiguration().getProtocolOptions().getProtocolVersion()).isEqualTo((Object)ProtocolVersion.V4);
    }
}

