/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterWidePercentileTracker;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.PercentileTracker;
import com.datastax.driver.core.QueryLogger;
import com.datastax.driver.core.ScassandraTestBase;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ProtocolError;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.UnpreparedException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class QueryLoggerErrorsTest
extends ScassandraTestBase.PerClassCluster {
    private Logger slow = Logger.getLogger((String)QueryLogger.SLOW_LOGGER.getName());
    private Logger error = Logger.getLogger((String)QueryLogger.ERROR_LOGGER.getName());
    private MemoryAppender slowAppender;
    private MemoryAppender errorAppender;
    private Cluster cluster = null;
    private Session session = null;
    private QueryLogger queryLogger = null;
    private Level originalError;
    private Level originalSlow;

    @BeforeMethod(groups={"short", "unit"})
    public void setUp() {
        this.originalSlow = this.slow.getLevel();
        this.originalError = this.error.getLevel();
        this.slow.setLevel(Level.INFO);
        this.error.setLevel(Level.INFO);
        this.slowAppender = new MemoryAppender();
        this.slow.addAppender((Appender)this.slowAppender);
        this.errorAppender = new MemoryAppender();
        this.error.addAppender((Appender)this.errorAppender);
        this.queryLogger = null;
        this.cluster = this.createClusterBuilder().withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE).build();
        this.session = this.cluster.connect();
    }

    @AfterMethod(groups={"short", "unit"}, alwaysRun=true)
    public void tearDown() {
        this.slow.setLevel(this.originalSlow);
        this.error.setLevel(this.originalError);
        this.slow.removeAppender((Appender)this.slowAppender);
        this.error.removeAppender((Appender)this.errorAppender);
        this.queryLogger = null;
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    @Test(groups={"short"})
    public void should_log_queries_beyond_constant_threshold() throws Exception {
        this.slow.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(10L).build();
        this.cluster.register((LatencyTracker)this.queryLogger);
        String query = "SELECT foo FROM bar";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(query).withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(100L))).build());
        this.session.execute(query);
        String line = this.slowAppender.waitAndGet(5000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query too slow"}).contains(new CharSequence[]{ip}).contains(new CharSequence[]{query});
    }

    @Test(groups={"short"})
    public void should_log_queries_beyond_dynamic_threshold() throws Exception {
        this.slow.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withDynamicThreshold((PercentileTracker)((ClusterWidePercentileTracker.Builder)((ClusterWidePercentileTracker.Builder)ClusterWidePercentileTracker.builder((long)1000L).withMinRecordedValues(100)).withInterval(1L, TimeUnit.SECONDS)).build(), 99.0).build();
        this.cluster.register((LatencyTracker)this.queryLogger);
        String fastQuery = "SELECT foo FROM bar";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(fastQuery).build());
        String slowQuery = "SELECT bar from foo";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(slowQuery).withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(100L))).build());
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            this.session.execute(fastQuery);
        }
        long waitTime = 1000L - (System.currentTimeMillis() - startTime);
        Uninterruptibles.sleepUninterruptibly((long)waitTime, (TimeUnit)TimeUnit.MILLISECONDS);
        this.session.execute(slowQuery);
        String line = this.slowAppender.waitAndGet(5000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query too slow"}).contains(new CharSequence[]{ip}).contains(new CharSequence[]{slowQuery}).doesNotContain((CharSequence)fastQuery);
    }

    @Test(groups={"short"})
    public void should_log_timed_out_queries() throws Exception {
        this.error.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster.register((LatencyTracker)this.queryLogger);
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(1);
        String query = "SELECT foo FROM bar";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(query).withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(100L))).build());
        try {
            this.session.execute(query);
            Assertions.fail((String)"Should have thrown OperationTimedOutException");
        }
        catch (OperationTimedOutException operationTimedOutException) {
            // empty catch block
        }
        String line = this.errorAppender.waitAndGet(5000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query error"}).contains(new CharSequence[]{ip}).contains(new CharSequence[]{Integer.toString(this.scassandra.getBinaryPort())}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"Timed out waiting for server response"});
    }

    @DataProvider(name="errors")
    public static Object[][] createErrors() {
        return new Object[][]{{Result.unavailable, UnavailableException.class}, {Result.write_request_timeout, WriteTimeoutException.class}, {Result.read_request_timeout, ReadTimeoutException.class}, {Result.server_error, ServerError.class}, {Result.protocol_error, ProtocolError.class}, {Result.bad_credentials, AuthenticationException.class}, {Result.overloaded, OverloadedException.class}, {Result.is_bootstrapping, BootstrappingException.class}, {Result.truncate_error, TruncateException.class}, {Result.syntax_error, SyntaxError.class}, {Result.invalid, InvalidQueryException.class}, {Result.config_error, InvalidConfigurationInQueryException.class}, {Result.already_exists, AlreadyExistsException.class}, {Result.unprepared, UnpreparedException.class}};
    }

    @Test(groups={"short"}, dataProvider="errors")
    public void should_log_exception_from_the_given_result(Result result, Class<? extends Exception> expectedException) throws Exception {
        this.error.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster.register((LatencyTracker)this.queryLogger);
        String query = "SELECT foo FROM bar";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(query).withThen(PrimingRequest.then().withResult(result)).build());
        try {
            this.session.execute(query);
            Assertions.fail((String)"Should have thrown Exception");
        }
        catch (Exception e) {
            if (expectedException == UnpreparedException.class) {
                Assertions.assertThat((Throwable)e).isInstanceOf(DriverInternalError.class);
            }
            if (expectedException == BootstrappingException.class) {
                Assertions.assertThat((Throwable)e).isInstanceOf(NoHostAvailableException.class);
                Assertions.assertThat((Throwable)((Throwable)((NoHostAvailableException)e).getErrors().get(this.hostAddress))).isInstanceOf(expectedException);
            }
            Assertions.assertThat((Throwable)e).isInstanceOf(expectedException);
        }
        String line = this.errorAppender.waitAndGet(5000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query error"}).contains(new CharSequence[]{ip}).contains(new CharSequence[]{Integer.toString(this.scassandra.getBinaryPort())}).contains(new CharSequence[]{query}).contains(new CharSequence[]{expectedException.getName()});
    }
}

