/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryLogger;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapperTest;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class QueryLoggerTest
extends CCMTestsSupport {
    private List<DataType> dataTypes;
    private List<Object> values;
    private String assignments;
    private Logger normal = Logger.getLogger((String)QueryLogger.NORMAL_LOGGER.getName());
    private Logger slow = Logger.getLogger((String)QueryLogger.SLOW_LOGGER.getName());
    private Logger error = Logger.getLogger((String)QueryLogger.ERROR_LOGGER.getName());
    private MemoryAppender normalAppender;
    private MemoryAppender slowAppender;
    private MemoryAppender errorAppender;
    private QueryLogger queryLogger;
    private Level originalNormal;
    private Level originalSlow;
    private Level originalError;

    @Override
    public void onTestContextInitialized() {
        this.dataTypes = new ArrayList<DataType>(Sets.filter(TestUtils.allPrimitiveTypes(this.ccm().getProtocolVersion()), (Predicate)new Predicate<DataType>(){

            public boolean apply(DataType type) {
                return type != DataType.counter();
            }
        }));
        this.values = Lists.transform(this.dataTypes, (Function)new Function<DataType, Object>(){

            public Object apply(DataType type) {
                return TestUtils.getFixedValue(type);
            }
        });
        String definitions = Joiner.on((String)", ").join((Iterable)Lists.transform(this.dataTypes, (Function)new Function<DataType, String>(){

            public String apply(DataType type) {
                return "c_" + type + " " + type;
            }
        }));
        this.assignments = Joiner.on((String)", ").join((Iterable)Lists.transform(this.dataTypes, (Function)new Function<DataType, String>(){

            public String apply(DataType type) {
                return "c_" + type + " = ?";
            }
        }));
        this.execute("CREATE TABLE test (pk int PRIMARY KEY, " + definitions + ")");
    }

    @BeforeMethod(groups={"short", "unit"})
    public void startCapturingLogs() {
        this.originalNormal = this.normal.getLevel();
        this.originalSlow = this.slow.getLevel();
        this.originalError = this.error.getLevel();
        this.normal.setLevel(Level.INFO);
        this.slow.setLevel(Level.INFO);
        this.error.setLevel(Level.INFO);
        this.normalAppender = new MemoryAppender();
        this.normal.addAppender((Appender)this.normalAppender);
        this.slowAppender = new MemoryAppender();
        this.slow.addAppender((Appender)this.slowAppender);
        this.errorAppender = new MemoryAppender();
        this.error.addAppender((Appender)this.errorAppender);
    }

    @AfterMethod(groups={"short", "unit"}, alwaysRun=true)
    public void stopCapturingLogs() {
        this.normal.setLevel(this.originalNormal);
        this.slow.setLevel(this.originalSlow);
        this.error.setLevel(this.originalError);
        this.normal.removeAppender((Appender)this.normalAppender);
        this.slow.removeAppender((Appender)this.slowAppender);
        this.error.removeAppender((Appender)this.errorAppender);
    }

    @AfterMethod(groups={"short", "unit"}, alwaysRun=true)
    public void unregisterQueryLogger() {
        if (this.cluster() != null && this.queryLogger != null) {
            this.cluster().unregister((LatencyTracker)this.queryLogger);
        }
    }

    @Test(groups={"short"})
    public void should_log_regular_statements() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "SELECT c_text FROM test WHERE pk = 42";
        this.session().execute(query);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).doesNotContain((CharSequence)"parameters");
    }

    @Test(groups={"short"})
    public void should_log_bound_statements() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "SELECT * FROM test where pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind(new Object[]{42});
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).doesNotContain((CharSequence)"actual parameters");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_batch_statements() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).withMaxQueryStringLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "INSERT INTO test (pk) VALUES (?)";
        String query2 = "UPDATE test SET c_int = ? WHERE pk = 42";
        PreparedStatement ps1 = this.session().prepare(query1);
        PreparedStatement ps2 = this.session().prepare(query2);
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)ps1.bind(new Object[]{42}));
        batch.add((Statement)ps2.bind(new Object[]{1234}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"BEGIN BATCH"}).contains(new CharSequence[]{"APPLY BATCH"}).contains(new CharSequence[]{query1}).contains(new CharSequence[]{query2}).doesNotContain((CharSequence)"c_int:");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_unlogged_batch_statements() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).withMaxQueryStringLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "INSERT INTO test (pk) VALUES (?)";
        String query2 = "UPDATE test SET c_int = ? WHERE pk = 42";
        PreparedStatement ps1 = this.session().prepare(query1);
        PreparedStatement ps2 = this.session().prepare(query2);
        BatchStatement batch = new BatchStatement(BatchStatement.Type.UNLOGGED);
        batch.add((Statement)ps1.bind(new Object[]{42}));
        batch.add((Statement)ps2.bind(new Object[]{1234}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"BEGIN UNLOGGED BATCH"}).contains(new CharSequence[]{"APPLY BATCH"}).contains(new CharSequence[]{query1}).contains(new CharSequence[]{query2}).doesNotContain((CharSequence)"c_int:");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_counter_batch_statements() throws Exception {
        this.session().execute("CREATE TABLE IF NOT EXISTS counter_test (pk int PRIMARY KEY, c_count COUNTER, c_count2 COUNTER)");
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).withMaxQueryStringLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "UPDATE counter_test SET c_count = c_count + ? WHERE pk = 42";
        String query2 = "UPDATE counter_test SET c_count2 = c_count2 + ? WHERE pk = 42";
        PreparedStatement ps1 = this.session().prepare(query1);
        PreparedStatement ps2 = this.session().prepare(query2);
        BatchStatement batch = new BatchStatement(BatchStatement.Type.COUNTER);
        batch.add((Statement)ps1.bind(new Object[]{1234L}));
        batch.add((Statement)ps2.bind(new Object[]{5678L}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"BEGIN COUNTER BATCH"}).contains(new CharSequence[]{"APPLY BATCH"}).contains(new CharSequence[]{query1}).contains(new CharSequence[]{query2}).doesNotContain((CharSequence)"c_count:");
    }

    @Test(groups={"unit"})
    public void should_log_unknown_statements() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        Statement unknownStatement = new Statement(){

            public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
                return null;
            }

            public String getKeyspace() {
                return null;
            }

            public String toString() {
                return "weird statement";
            }
        };
        this.queryLogger = QueryLogger.builder().build();
        this.queryLogger.onRegister((Cluster)Mockito.mock(Cluster.class));
        this.queryLogger.update(null, unknownStatement, null, 0L);
        String line = this.normalAppender.get();
        Assertions.assertThat((String)line).contains(new CharSequence[]{"weird statement"});
    }

    @Test(groups={"unit"})
    public void should_not_log_normal_if_level_higher_than_DEBUG() throws Exception {
        this.normal.setLevel(Level.INFO);
        this.slow.setLevel(Level.INFO);
        this.error.setLevel(Level.INFO);
        this.queryLogger = QueryLogger.builder().build();
        this.queryLogger.onRegister((Cluster)Mockito.mock(Cluster.class));
        this.queryLogger.update(null, (Statement)Mockito.mock(BoundStatement.class), null, 0L);
        Assertions.assertThat((String)this.normalAppender.get()).isEmpty();
        Assertions.assertThat((String)this.slowAppender.get()).isEmpty();
        Assertions.assertThat((String)this.errorAppender.get()).isEmpty();
    }

    @Test(groups={"unit"})
    public void should_not_log_slow_if_level_higher_than_DEBUG() throws Exception {
        this.normal.setLevel(Level.INFO);
        this.slow.setLevel(Level.INFO);
        this.error.setLevel(Level.INFO);
        this.queryLogger = QueryLogger.builder().build();
        this.queryLogger.onRegister((Cluster)Mockito.mock(Cluster.class));
        this.queryLogger.update(null, (Statement)Mockito.mock(BoundStatement.class), null, 5001L);
        Assertions.assertThat((String)this.normalAppender.get()).isEmpty();
        Assertions.assertThat((String)this.slowAppender.get()).isEmpty();
        Assertions.assertThat((String)this.errorAppender.get()).isEmpty();
    }

    @Test(groups={"unit"})
    public void should_not_log_error_if_level_higher_than_DEBUG() throws Exception {
        this.normal.setLevel(Level.INFO);
        this.slow.setLevel(Level.INFO);
        this.error.setLevel(Level.INFO);
        this.queryLogger = QueryLogger.builder().build();
        this.queryLogger.onRegister((Cluster)Mockito.mock(Cluster.class));
        this.queryLogger.update(null, (Statement)Mockito.mock(BoundStatement.class), (Exception)((Object)new DriverException("booh")), 0L);
        Assertions.assertThat((String)this.normalAppender.get()).isEmpty();
        Assertions.assertThat((String)this.slowAppender.get()).isEmpty();
        Assertions.assertThat((String)this.errorAppender.get()).isEmpty();
    }

    @Test(groups={"short"})
    public void should_log_normal_queries() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).withMaxQueryStringLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "SELECT * FROM test where pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind(new Object[]{42});
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).doesNotContain((CharSequence)"pk:42");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_non_null_named_parameter_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).withMaxQueryStringLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_text = :param1 WHERE pk = :param2";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setString("param1", "foo");
        bs.setInt("param2", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"param2:42"}).contains(new CharSequence[]{"param1:'foo'"});
    }

    @Test(groups={"short"})
    public void should_log_non_null_positional_parameter_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_text = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setString("c_text", "foo");
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"pk:42"}).contains(new CharSequence[]{"c_text:'foo'"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_non_null_positional_parameter_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_text = ? WHERE pk = ?";
        SimpleStatement ss = new SimpleStatement(query, new Object[]{"foo", 42});
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"42"}).contains(new CharSequence[]{"'foo'"});
    }

    @Test(groups={"short"})
    public void should_log_null_parameter_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_text = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setString("c_text", null);
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"pk:42"}).contains(new CharSequence[]{"c_text:NULL"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_null_parameter_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_text = ? WHERE pk = ?";
        SimpleStatement ss = new SimpleStatement(query, new Object[]{null, 42});
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"42"}).contains(new CharSequence[]{"NULL"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.0")
    public void should_log_unset_parameter() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_text = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"pk:42"}).contains(new CharSequence[]{"c_text:<UNSET>"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_bound_statement_parameters_inside_batch_statement() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "UPDATE test SET c_text = ? WHERE pk = ?";
        String query2 = "UPDATE test SET c_int = ? WHERE pk = ?";
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)this.session().prepare(query1).bind(new Object[]{"foo", 42}));
        batch.add((Statement)this.session().prepare(query2).bind(new Object[]{12345, 43}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query1}).contains(new CharSequence[]{query2}).contains(new CharSequence[]{"pk:42"}).contains(new CharSequence[]{"pk:43"}).contains(new CharSequence[]{"c_text:'foo'"}).contains(new CharSequence[]{"c_int:12345"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_simple_statement_parameters_inside_batch_statement() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "UPDATE test SET c_text = ? WHERE pk = ?";
        String query2 = "UPDATE test SET c_int = ? WHERE pk = ?";
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement(query1, new Object[]{"foo", 42}));
        batch.add((Statement)new SimpleStatement(query2, new Object[]{12345, 43}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query1}).contains(new CharSequence[]{query2}).contains(new CharSequence[]{"42"}).contains(new CharSequence[]{"43"}).contains(new CharSequence[]{"'foo'"}).contains(new CharSequence[]{"12345"});
    }

    @Test(groups={"short"})
    public void should_log_all_parameter_types_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET " + this.assignments + " WHERE pk = 42";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind(this.values.toArray());
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query});
        CodecRegistry codecRegistry = this.cluster().getConfiguration().getCodecRegistry();
        for (DataType type : this.dataTypes) {
            TypeCodec codec = codecRegistry.codecFor(type);
            Assertions.assertThat((String)line).contains(new CharSequence[]{codec.format(TestUtils.getFixedValue(type))});
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_all_parameter_types_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET " + this.assignments + " WHERE pk = 42";
        SimpleStatement ss = new SimpleStatement(query, this.values.toArray());
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query});
        CodecRegistry codecRegistry = this.cluster().getConfiguration().getCodecRegistry();
        for (DataType type : this.dataTypes) {
            TypeCodec codec = type.equals(DataType.time()) ? codecRegistry.codecFor(DataType.bigint()) : codecRegistry.codecFor(type);
            Assertions.assertThat((String)line).contains(new CharSequence[]{codec.format(TestUtils.getFixedValue(type))});
        }
    }

    @Test(groups={"short"})
    public void should_truncate_query_when_max_length_exceeded() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withMaxQueryStringLength(5).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "SELECT * FROM test WHERE pk = 42";
        this.session().execute(query);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"SELEC... [truncated output]"}).doesNotContain((CharSequence)query);
    }

    @CassandraVersion(value="2.0.0")
    @Test(groups={"short"})
    public void should_show_total_statements_for_batches_even_if_query_truncated() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withMaxQueryStringLength(5).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "UPDATE test SET c_text = ? WHERE pk = ?";
        String query2 = "UPDATE test SET c_int = ? WHERE pk = ?";
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)this.session().prepare(query1).bind(new Object[]{"foo", 42}));
        batch.add((Statement)this.session().prepare(query2).bind(new Object[]{12345, 43}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"BEGIN... [truncated output]"}).doesNotContain((CharSequence)query1).doesNotContain((CharSequence)query2).contains(new CharSequence[]{" [2 statements"});
    }

    @Test(groups={"short"})
    public void should_not_truncate_query_when_max_length_unlimited() throws Exception {
        this.normal.setLevel(Level.DEBUG);
        this.queryLogger = QueryLogger.builder().withMaxQueryStringLength(-1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "SELECT * FROM test WHERE pk = 42";
        this.session().execute(query);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).doesNotContain((CharSequence)"... [truncated output]");
    }

    @CassandraVersion(value="2.0.0")
    @Test(groups={"short"})
    public void should_truncate_parameter_when_max_length_exceeded_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(5).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setInt("c_int", 123456);
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"c_int:12345... [truncated output]"}).doesNotContain((CharSequence)"123456");
    }

    @CassandraVersion(value="2.0.0")
    @Test(groups={"short"})
    public void should_truncate_parameter_when_max_length_exceeded_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(5).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        SimpleStatement ss = new SimpleStatement(query, new Object[]{123456, 42});
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"12345... [truncated output]"}).doesNotContain((CharSequence)"123456");
    }

    @Test(groups={"short"})
    public void should_truncate_blob_parameter_when_max_length_exceeded_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(6).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_blob = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setBytes("c_blob", ByteBuffer.wrap(Bytes.toArray((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}))));
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"c_blob:0x0102... [truncated output]"}).doesNotContain((CharSequence)"0x010203");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_truncate_blob_parameter_when_max_length_exceeded_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(6).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_blob = ? WHERE pk = ?";
        SimpleStatement ss = new SimpleStatement(query, new Object[]{ByteBuffer.wrap(Bytes.toArray((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}))), 42});
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"0x0102... [truncated output]"}).doesNotContain((CharSequence)"0x010203");
    }

    @Test(groups={"short"})
    public void should_not_truncate_parameter_when_max_length_unlimited_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(-1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setInt("c_int", 123456);
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"c_int:123456"}).doesNotContain((CharSequence)"... [truncated output]");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_not_truncate_parameter_when_max_length_unlimited_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxParameterValueLength(-1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        SimpleStatement ss = new SimpleStatement(query, new Object[]{123456, 42});
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"123456"}).doesNotContain((CharSequence)"... [truncated output]");
    }

    @Test(groups={"short"})
    public void should_not_log_exceeding_number_of_parameters_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setInt("c_int", 123456);
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"c_int:123456"}).doesNotContain((CharSequence)"pk:42").contains(new CharSequence[]{" [further parameters omitted]"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_not_log_exceeding_number_of_parameters_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        SimpleStatement ss = new SimpleStatement(query, new Object[]{123456, 42});
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"123456"}).doesNotContain((CharSequence)"123456, 42").contains(new CharSequence[]{" [further parameters omitted]"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_not_log_exceeding_number_of_parameters_simple_statements_with_named_values() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = :c_int WHERE pk = :pk";
        LinkedHashMap<String, Integer> namedValues = new LinkedHashMap<String, Integer>();
        namedValues.put("c_int", 123456);
        namedValues.put("pk", 42);
        SimpleStatement ss = new SimpleStatement(query, namedValues);
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"c_int:123456"}).doesNotContain((CharSequence)"pk:42").contains(new CharSequence[]{" [further parameters omitted]"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_not_log_exceeding_number_of_parameters_in_batch_statement_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "UPDATE test SET c_text = ? WHERE pk = ?";
        String query2 = "UPDATE test SET c_int = ? WHERE pk = ?";
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)this.session().prepare(query1).bind(new Object[]{"foo", 42}));
        batch.add((Statement)this.session().prepare(query2).bind(new Object[]{12345, 43}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query1}).contains(new CharSequence[]{query2}).contains(new CharSequence[]{"c_text:'foo'"}).doesNotContain((CharSequence)"pk:42").doesNotContain((CharSequence)"c_int:12345").doesNotContain((CharSequence)"pk:43").contains(new CharSequence[]{" [further parameters omitted]"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_not_log_exceeding_number_of_parameters_in_batch_statement_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query1 = "UPDATE test SET c_text = ? WHERE pk = ?";
        String query2 = "UPDATE test SET c_int = ? WHERE pk = ?";
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement(query1, new Object[]{"foo", 42}));
        batch.add((Statement)new SimpleStatement(query2, new Object[]{12345, 43}));
        this.session().execute((Statement)batch);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query1}).contains(new CharSequence[]{query2}).contains(new CharSequence[]{"'foo'"}).doesNotContain((CharSequence)"42, 12345, 43").contains(new CharSequence[]{" [further parameters omitted]"});
    }

    @Test(groups={"short"})
    public void should_log_all_parameters_when_max_unlimited_bound_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(-1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setInt("c_int", 123456);
        bs.setInt("pk", 42);
        this.session().execute((Statement)bs);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"c_int:123456"}).contains(new CharSequence[]{"pk:42"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_log_all_parameters_when_max_unlimited_simple_statements() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(-1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = ? WHERE pk = ?";
        SimpleStatement ss = new SimpleStatement(query, new Object[]{123456, 42});
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"123456"}).contains(new CharSequence[]{"42"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_log_all_parameters_when_max_unlimited_simple_statements_with_named_values() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withMaxLoggedParameters(-1).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_int = :c_int WHERE pk = :pk";
        HashMap<String, Integer> namedValues = new HashMap<String, Integer>();
        namedValues.put("c_int", 123456);
        namedValues.put("pk", 42);
        SimpleStatement ss = new SimpleStatement(query, namedValues);
        this.session().execute((Statement)ss);
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{"123456"}).contains(new CharSequence[]{"42"});
    }

    @CassandraVersion(value="2.0.0")
    @Test(groups={"short"})
    public void should_log_wrapped_bound_statement() throws Exception {
        this.normal.setLevel(Level.TRACE);
        this.queryLogger = QueryLogger.builder().withConstantThreshold(Long.MAX_VALUE).withMaxQueryStringLength(Integer.MAX_VALUE).build();
        this.cluster().register((LatencyTracker)this.queryLogger);
        String query = "UPDATE test SET c_text = :param1 WHERE pk = :param2";
        PreparedStatement ps = this.session().prepare(query);
        BoundStatement bs = ps.bind();
        bs.setString("param1", "foo");
        bs.setInt("param2", 42);
        this.session().execute((Statement)new StatementWrapperTest.CustomStatement((Statement)bs));
        String line = this.normalAppender.waitAndGet(10000L);
        Assertions.assertThat((String)line).contains(new CharSequence[]{"Query completed normally"}).contains(new CharSequence[]{TestUtils.ipOfNode(1)}).contains(new CharSequence[]{query}).contains(new CharSequence[]{"param2:42"}).contains(new CharSequence[]{"param1:'foo'"});
    }
}

