/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ColumnMetadataAssert;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TableMetadataAssert;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import org.assertj.core.data.MapEntry;
import org.testng.annotations.Test;

@CCMConfig(clusterProvider="createClusterBuilderNoDebouncing")
public class TableMetadataTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_parse_table_without_clustering_columns() {
        String cql = String.format("CREATE TABLE %s.static (\n    k text,\n    i int,\n    m map<text, timeuuid>,\n    v int,\n    PRIMARY KEY (k)\n);", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("static");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("static").hasNumberOfColumns(4).isNotCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.text());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("i").isRegularColumn().hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("m").isRegularColumn().hasType((DataType)DataType.map((DataType)DataType.text(), (DataType)DataType.timeuuid()));
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(3)).isNotNull()).hasName("v").isRegularColumn().hasType(DataType.cint());
    }

    @Test(groups={"short"})
    public void should_parse_table_with_clustering_columns() {
        String cql = String.format("CREATE TABLE %s.sparse (\n    k text,\n    c1 int,\n    c2 float,\n    l list<text>,\n    v int,\n    PRIMARY KEY (k, c1, c2)\n) WITH CLUSTERING ORDER BY (c1 ASC, c2 DESC);", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("sparse");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("sparse").hasNumberOfColumns(5).isNotCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.text());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("c1").isClusteringColumn().hasClusteringOrder(ClusteringOrder.ASC).hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("c2").isClusteringColumn().hasClusteringOrder(ClusteringOrder.DESC).hasType(DataType.cfloat());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(3)).isNotNull()).hasName("l").isRegularColumn().hasType((DataType)DataType.list((DataType)DataType.text()));
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(4)).isNotNull()).hasName("v").isRegularColumn().hasType(DataType.cint());
    }

    @Test(groups={"short"})
    public void should_parse_counter_table() {
        String cql = String.format("CREATE TABLE %s.counters (\n    k text,\n    c counter,\n    PRIMARY KEY (k)\n);", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("counters");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("counters").hasNumberOfColumns(2).isNotCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.text());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("c").isRegularColumn().hasType(DataType.counter());
    }

    @Test(groups={"short"})
    public void should_parse_compact_static_table() {
        String cql = String.format("CREATE TABLE %s.compact_static (\n    k text,\n    i int,\n    t timeuuid,\n    v int,\n    PRIMARY KEY (k)\n) WITH COMPACT STORAGE;", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("compact_static");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("compact_static").hasNumberOfColumns(4).isCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.text());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("i").isRegularColumn().hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("t").isRegularColumn().hasType(DataType.timeuuid());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(3)).isNotNull()).hasName("v").isRegularColumn().hasType(DataType.cint());
    }

    @Test(groups={"short"})
    public void should_parse_dense_table() {
        String cql = String.format("CREATE TABLE %s.dense (\n        k int,\n        c int,\n        PRIMARY KEY (k, c)\n    ) WITH COMPACT STORAGE;", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("dense");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("dense").hasNumberOfColumns(2).isCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("c").isClusteringColumn().hasType(DataType.cint());
    }

    @Test(groups={"short"})
    public void should_parse_compact_dynamic_table() {
        String cql = String.format("CREATE TABLE %s.compact_dynamic (\n    k text,\n    c int,\n    v timeuuid,\n    PRIMARY KEY (k, c)\n) WITH COMPACT STORAGE;", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("compact_dynamic");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("compact_dynamic").hasNumberOfColumns(3).isCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.text());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("c").isClusteringColumn().hasClusteringOrder(ClusteringOrder.ASC).hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("v").isRegularColumn().hasType(DataType.timeuuid());
    }

    @Test(groups={"short"})
    public void should_parse_compact_table_with_multiple_clustering_columns() {
        String cql = String.format("CREATE TABLE %s.compact_composite (\n    k text,\n    c1 int,\n    c2 float,\n    c3 double,\n    v timeuuid,\n    PRIMARY KEY (k, c1, c2, c3)\n) WITH COMPACT STORAGE;", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("compact_composite");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("compact_composite").hasNumberOfColumns(5).isCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.text());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("c1").isClusteringColumn().hasClusteringOrder(ClusteringOrder.ASC).hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("c2").isClusteringColumn().hasClusteringOrder(ClusteringOrder.ASC).hasType(DataType.cfloat());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(3)).isNotNull()).hasName("c3").isClusteringColumn().hasClusteringOrder(ClusteringOrder.ASC).hasType(DataType.cdouble());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(4)).isNotNull()).hasName("v").isRegularColumn().hasType(DataType.timeuuid());
    }

    @Test(groups={"short"})
    public void should_parse_table_options() {
        VersionNumber version = TestUtils.findHost(this.cluster(), 1).getCassandraVersion();
        String cql = version.getMajor() > 2 ? String.format("CREATE TABLE %s.with_options (\n    k text,\n    c1 int,\n    c2 int,\n    i int,\n    PRIMARY KEY (k, c1, c2)\n) WITH CLUSTERING ORDER BY (c1 DESC, c2 ASC)\n   AND read_repair_chance = 0.5\n   AND dclocal_read_repair_chance = 0.6\n   AND speculative_retry = '99.9PERCENTILE'\n   AND gc_grace_seconds = 42\n   AND bloom_filter_fp_chance = 0.01\n   AND caching =  { 'keys' : 'ALL', 'rows_per_partition' : 10 }\n   AND comment = 'My awesome table'\n   AND compaction = { 'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy', 'sstable_size_in_mb' : 15 }\n   AND compression = { 'sstable_compression' : 'org.apache.cassandra.io.compress.SnappyCompressor', 'chunk_length_kb' : 128 }\n   AND crc_check_chance = 0.5;", this.keyspace) : String.format("CREATE TABLE %s.with_options (\n    k text,\n    c1 int,\n    c2 int,\n    i int,\n    PRIMARY KEY (k, c1, c2)\n) WITH CLUSTERING ORDER BY (c1 DESC, c2 ASC)\n   AND read_repair_chance = 0.5\n   AND dclocal_read_repair_chance = 0.6\n   AND replicate_on_write = true\n   AND gc_grace_seconds = 42\n   AND bloom_filter_fp_chance = 0.01\n   AND caching = 'ALL'\n   AND comment = 'My awesome table'\n   AND compaction = { 'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy', 'sstable_size_in_mb' : 15 }\n   AND compression = { 'sstable_compression' : 'org.apache.cassandra.io.compress.SnappyCompressor', 'chunk_length_kb' : 128 };", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("with_options");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("with_options").hasNumberOfColumns(4).isNotCompactStorage();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("k").isPartitionKey().hasType(DataType.text());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("c1").isClusteringColumn().hasClusteringOrder(ClusteringOrder.DESC).hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("c2").isClusteringColumn().hasClusteringOrder(ClusteringOrder.ASC).hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(3)).isNotNull()).hasName("i").isRegularColumn().hasType(DataType.cint());
        Assertions.assertThat(table);
        if (version.getMajor() > 3 || version.getMajor() == 3 && version.getMinor() >= 8) {
            Assertions.assertThat((double)table.getOptions().getReadRepairChance()).isEqualTo(0.5);
            Assertions.assertThat((double)table.getOptions().getLocalReadRepairChance()).isEqualTo(0.6);
            Assertions.assertThat((int)table.getOptions().getGcGraceInSeconds()).isEqualTo(42);
            Assertions.assertThat((double)table.getOptions().getBloomFilterFalsePositiveChance()).isEqualTo(0.01);
            Assertions.assertThat((String)table.getOptions().getComment()).isEqualTo((Object)"My awesome table");
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"keys", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"rows_per_partition", (Object)"10")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.db.compaction.LeveledCompactionStrategy")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_size_in_mb", (Object)"15")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.io.compress.SnappyCompressor")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"chunk_length_in_kb", (Object)"128")});
            Assertions.assertThat((int)table.getOptions().getDefaultTimeToLive()).isEqualTo(0);
            Assertions.assertThat((String)table.getOptions().getSpeculativeRetry()).isEqualTo((Object)"99.9PERCENTILE");
            Assertions.assertThat((Integer)table.getOptions().getIndexInterval()).isNull();
            Assertions.assertThat((Integer)table.getOptions().getMinIndexInterval()).isEqualTo(128);
            Assertions.assertThat((Integer)table.getOptions().getMaxIndexInterval()).isEqualTo(2048);
            Assertions.assertThat((boolean)table.getOptions().getReplicateOnWrite()).isTrue();
            Assertions.assertThat((Double)table.getOptions().getCrcCheckChance()).isEqualTo(0.5);
            Assertions.assertThat((Map)table.getOptions().getExtensions()).isEmpty();
            Assertions.assertThat((String)table.asCQLQuery()).contains(new CharSequence[]{"read_repair_chance = 0.5"}).contains(new CharSequence[]{"dclocal_read_repair_chance = 0.6"}).contains(new CharSequence[]{"gc_grace_seconds = 42"}).contains(new CharSequence[]{"bloom_filter_fp_chance = 0.01"}).contains(new CharSequence[]{"comment = 'My awesome table'"}).contains(new CharSequence[]{"'keys' : 'ALL'"}).contains(new CharSequence[]{"'rows_per_partition' : 10"}).contains(new CharSequence[]{"'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'"}).contains(new CharSequence[]{"'sstable_size_in_mb' : 15"}).contains(new CharSequence[]{"'class' : 'org.apache.cassandra.io.compress.SnappyCompressor'"}).contains(new CharSequence[]{"'chunk_length_in_kb' : 128"}).contains(new CharSequence[]{"default_time_to_live = 0"}).contains(new CharSequence[]{"speculative_retry = '99.9PERCENTILE'"}).contains(new CharSequence[]{"min_index_interval = 128"}).contains(new CharSequence[]{"max_index_interval = 2048"}).contains(new CharSequence[]{"crc_check_chance = 0.5"}).contains(new CharSequence[]{"cdc = false"}).doesNotContain((CharSequence)" index_interval").doesNotContain((CharSequence)"replicate_on_write");
        } else if (version.getMajor() > 2) {
            Assertions.assertThat((double)table.getOptions().getReadRepairChance()).isEqualTo(0.5);
            Assertions.assertThat((double)table.getOptions().getLocalReadRepairChance()).isEqualTo(0.6);
            Assertions.assertThat((int)table.getOptions().getGcGraceInSeconds()).isEqualTo(42);
            Assertions.assertThat((double)table.getOptions().getBloomFilterFalsePositiveChance()).isEqualTo(0.01);
            Assertions.assertThat((String)table.getOptions().getComment()).isEqualTo((Object)"My awesome table");
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"keys", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"rows_per_partition", (Object)"10")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.db.compaction.LeveledCompactionStrategy")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_size_in_mb", (Object)"15")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.io.compress.SnappyCompressor")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"chunk_length_in_kb", (Object)"128")});
            Assertions.assertThat((int)table.getOptions().getDefaultTimeToLive()).isEqualTo(0);
            Assertions.assertThat((String)table.getOptions().getSpeculativeRetry()).isEqualTo((Object)"99.9PERCENTILE");
            Assertions.assertThat((Integer)table.getOptions().getIndexInterval()).isNull();
            Assertions.assertThat((Integer)table.getOptions().getMinIndexInterval()).isEqualTo(128);
            Assertions.assertThat((Integer)table.getOptions().getMaxIndexInterval()).isEqualTo(2048);
            Assertions.assertThat((boolean)table.getOptions().getReplicateOnWrite()).isTrue();
            Assertions.assertThat((Double)table.getOptions().getCrcCheckChance()).isEqualTo(0.5);
            Assertions.assertThat((Map)table.getOptions().getExtensions()).isEmpty();
            Assertions.assertThat((String)table.asCQLQuery()).contains(new CharSequence[]{"read_repair_chance = 0.5"}).contains(new CharSequence[]{"dclocal_read_repair_chance = 0.6"}).contains(new CharSequence[]{"gc_grace_seconds = 42"}).contains(new CharSequence[]{"bloom_filter_fp_chance = 0.01"}).contains(new CharSequence[]{"comment = 'My awesome table'"}).contains(new CharSequence[]{"'keys' : 'ALL'"}).contains(new CharSequence[]{"'rows_per_partition' : 10"}).contains(new CharSequence[]{"'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'"}).contains(new CharSequence[]{"'sstable_size_in_mb' : 15"}).contains(new CharSequence[]{"'class' : 'org.apache.cassandra.io.compress.SnappyCompressor'"}).contains(new CharSequence[]{"'chunk_length_in_kb' : 128"}).contains(new CharSequence[]{"default_time_to_live = 0"}).contains(new CharSequence[]{"speculative_retry = '99.9PERCENTILE'"}).contains(new CharSequence[]{"min_index_interval = 128"}).contains(new CharSequence[]{"max_index_interval = 2048"}).contains(new CharSequence[]{"crc_check_chance = 0.5"}).doesNotContain((CharSequence)" index_interval").doesNotContain((CharSequence)"replicate_on_write").doesNotContain((CharSequence)"cdc");
        } else if (version.getMajor() == 2 && version.getMinor() > 0) {
            Assertions.assertThat((double)table.getOptions().getReadRepairChance()).isEqualTo(0.5);
            Assertions.assertThat((double)table.getOptions().getLocalReadRepairChance()).isEqualTo(0.6);
            Assertions.assertThat((int)table.getOptions().getGcGraceInSeconds()).isEqualTo(42);
            Assertions.assertThat((double)table.getOptions().getBloomFilterFalsePositiveChance()).isEqualTo(0.01);
            Assertions.assertThat((String)table.getOptions().getComment()).isEqualTo((Object)"My awesome table");
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"keys", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"rows_per_partition", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.db.compaction.LeveledCompactionStrategy")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_size_in_mb", (Object)"15")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_compression", (Object)"org.apache.cassandra.io.compress.SnappyCompressor")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"chunk_length_kb", (Object)"128")});
            Assertions.assertThat((int)table.getOptions().getDefaultTimeToLive()).isEqualTo(0);
            Assertions.assertThat((String)table.getOptions().getSpeculativeRetry()).isEqualTo((Object)"99.0PERCENTILE");
            Assertions.assertThat((Integer)table.getOptions().getIndexInterval()).isNull();
            Assertions.assertThat((Integer)table.getOptions().getMinIndexInterval()).isEqualTo(128);
            Assertions.assertThat((Integer)table.getOptions().getMaxIndexInterval()).isEqualTo(2048);
            Assertions.assertThat((boolean)table.getOptions().getReplicateOnWrite()).isTrue();
            Assertions.assertThat((Map)table.getOptions().getExtensions()).isEmpty();
            Assertions.assertThat((String)table.asCQLQuery()).contains(new CharSequence[]{"read_repair_chance = 0.5"}).contains(new CharSequence[]{"dclocal_read_repair_chance = 0.6"}).contains(new CharSequence[]{"gc_grace_seconds = 42"}).contains(new CharSequence[]{"bloom_filter_fp_chance = 0.01"}).contains(new CharSequence[]{"comment = 'My awesome table'"}).contains(new CharSequence[]{"'keys' : 'ALL'"}).contains(new CharSequence[]{"'rows_per_partition' : 'ALL'"}).contains(new CharSequence[]{"'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'"}).contains(new CharSequence[]{"'sstable_size_in_mb' : 15"}).contains(new CharSequence[]{"'sstable_compression' : 'org.apache.cassandra.io.compress.SnappyCompressor'"}).contains(new CharSequence[]{"'chunk_length_kb' : 128"}).contains(new CharSequence[]{"default_time_to_live = 0"}).contains(new CharSequence[]{"speculative_retry = '99.0PERCENTILE'"}).contains(new CharSequence[]{"min_index_interval = 128"}).contains(new CharSequence[]{"max_index_interval = 2048"}).doesNotContain((CharSequence)" index_interval").doesNotContain((CharSequence)"replicate_on_write").doesNotContain((CharSequence)"cdc");
        } else if (version.getMajor() == 2 && version.getMinor() == 0) {
            Assertions.assertThat((double)table.getOptions().getReadRepairChance()).isEqualTo(0.5);
            Assertions.assertThat((double)table.getOptions().getLocalReadRepairChance()).isEqualTo(0.6);
            Assertions.assertThat((int)table.getOptions().getGcGraceInSeconds()).isEqualTo(42);
            Assertions.assertThat((double)table.getOptions().getBloomFilterFalsePositiveChance()).isEqualTo(0.01);
            Assertions.assertThat((String)table.getOptions().getComment()).isEqualTo((Object)"My awesome table");
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"keys", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCaching()).doesNotContain(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"rows_per_partition", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.db.compaction.LeveledCompactionStrategy")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_size_in_mb", (Object)"15")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_compression", (Object)"org.apache.cassandra.io.compress.SnappyCompressor")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"chunk_length_kb", (Object)"128")});
            Assertions.assertThat((int)table.getOptions().getDefaultTimeToLive()).isEqualTo(0);
            Assertions.assertThat((String)table.getOptions().getSpeculativeRetry()).isEqualTo((Object)"99.0PERCENTILE");
            Assertions.assertThat((Integer)table.getOptions().getIndexInterval()).isEqualTo(128);
            Assertions.assertThat((Integer)table.getOptions().getMinIndexInterval()).isNull();
            Assertions.assertThat((Integer)table.getOptions().getMaxIndexInterval()).isNull();
            Assertions.assertThat((boolean)table.getOptions().getReplicateOnWrite()).isTrue();
            Assertions.assertThat((Map)table.getOptions().getExtensions()).isEmpty();
            Assertions.assertThat((String)table.asCQLQuery()).contains(new CharSequence[]{"read_repair_chance = 0.5"}).contains(new CharSequence[]{"dclocal_read_repair_chance = 0.6"}).contains(new CharSequence[]{"gc_grace_seconds = 42"}).contains(new CharSequence[]{"bloom_filter_fp_chance = 0.01"}).contains(new CharSequence[]{"comment = 'My awesome table'"}).contains(new CharSequence[]{"caching = 'ALL'"}).contains(new CharSequence[]{"'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'"}).contains(new CharSequence[]{"'sstable_size_in_mb' : 15"}).contains(new CharSequence[]{"'sstable_compression' : 'org.apache.cassandra.io.compress.SnappyCompressor'"}).contains(new CharSequence[]{"'chunk_length_kb' : 128"}).contains(new CharSequence[]{"replicate_on_write = true"}).contains(new CharSequence[]{"index_interval = 128"}).contains(new CharSequence[]{"speculative_retry = '99.0PERCENTILE'"}).contains(new CharSequence[]{"default_time_to_live = 0"}).doesNotContain((CharSequence)"min_index_interval").doesNotContain((CharSequence)"max_index_interval").doesNotContain((CharSequence)"cdc");
        } else {
            Assertions.assertThat((double)table.getOptions().getReadRepairChance()).isEqualTo(0.5);
            Assertions.assertThat((double)table.getOptions().getLocalReadRepairChance()).isEqualTo(0.6);
            Assertions.assertThat((int)table.getOptions().getGcGraceInSeconds()).isEqualTo(42);
            Assertions.assertThat((double)table.getOptions().getBloomFilterFalsePositiveChance()).isEqualTo(0.01);
            Assertions.assertThat((String)table.getOptions().getComment()).isEqualTo((Object)"My awesome table");
            Assertions.assertThat((Map)table.getOptions().getCaching()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"keys", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCaching()).doesNotContain(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"rows_per_partition", (Object)"ALL")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.db.compaction.LeveledCompactionStrategy")});
            Assertions.assertThat((Map)table.getOptions().getCompaction()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_size_in_mb", (Object)"15")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"sstable_compression", (Object)"org.apache.cassandra.io.compress.SnappyCompressor")});
            Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"chunk_length_kb", (Object)"128")});
            Assertions.assertThat((int)table.getOptions().getDefaultTimeToLive()).isEqualTo(0);
            Assertions.assertThat((String)table.getOptions().getSpeculativeRetry()).isEqualTo((Object)"NONE");
            Assertions.assertThat((Integer)table.getOptions().getIndexInterval()).isNull();
            Assertions.assertThat((Integer)table.getOptions().getMinIndexInterval()).isNull();
            Assertions.assertThat((Integer)table.getOptions().getMaxIndexInterval()).isNull();
            Assertions.assertThat((boolean)table.getOptions().getReplicateOnWrite()).isTrue();
            Assertions.assertThat((Map)table.getOptions().getExtensions()).isEmpty();
            Assertions.assertThat((String)table.asCQLQuery()).contains(new CharSequence[]{"read_repair_chance = 0.5"}).contains(new CharSequence[]{"dclocal_read_repair_chance = 0.6"}).contains(new CharSequence[]{"gc_grace_seconds = 42"}).contains(new CharSequence[]{"bloom_filter_fp_chance = 0.01"}).contains(new CharSequence[]{"comment = 'My awesome table'"}).contains(new CharSequence[]{"caching = 'ALL'"}).contains(new CharSequence[]{"'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'"}).contains(new CharSequence[]{"'sstable_size_in_mb' : 15"}).contains(new CharSequence[]{"'sstable_compression' : 'org.apache.cassandra.io.compress.SnappyCompressor'"}).contains(new CharSequence[]{"'chunk_length_kb' : 128"}).contains(new CharSequence[]{"replicate_on_write = true"}).doesNotContain((CharSequence)"index_interval").doesNotContain((CharSequence)"min_index_interval").doesNotContain((CharSequence)"max_index_interval").doesNotContain((CharSequence)"speculative_retry").doesNotContain((CharSequence)"default_time_to_live").doesNotContain((CharSequence)"cdc");
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.0")
    public void should_parse_new_compression_options() {
        String cql = String.format("CREATE TABLE %s.new_compression_options (\n    k text,\n    c1 int,\n    c2 int,\n    i int,\n    PRIMARY KEY (k, c1, c2)\n) WITH CLUSTERING ORDER BY (c1 DESC, c2 ASC)\n   AND compression = { 'class' : 'DeflateCompressor', 'chunk_length_in_kb' : 128 };", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("new_compression_options");
        Assertions.assertThat((Map)table.getOptions().getCompression()).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"class", (Object)"org.apache.cassandra.io.compress.DeflateCompressor")}).contains(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"chunk_length_in_kb", (Object)"128")});
    }

    @Test(groups={"short"})
    public void should_escape_single_quote_table_comment() {
        String cql = String.format("CREATE TABLE %s.single_quote (\n    c1 int PRIMARY KEY\n) WITH  comment = 'comment with single quote '' should work'", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("single_quote");
        Assertions.assertThat((String)table.getOptions().getComment()).isEqualTo((Object)"comment with single quote ' should work");
        Assertions.assertThat((String)table.asCQLQuery()).contains(new CharSequence[]{"comment = 'comment with single quote '' should work'"});
    }

    @Test(groups={"short"})
    public void should_not_mix_indexes_from_different_tables() {
        String[] statements;
        for (String statement : statements = new String[]{"CREATE TABLE test_ab (a int PRIMARY KEY, b int);", "CREATE INDEX test_b on test_ab (b);", "CREATE TABLE test_cd (c int PRIMARY KEY, d int);", "CREATE INDEX test_d on test_cd (d);"}) {
            this.session().execute(statement);
        }
        TableMetadata table_ab = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("test_ab");
        TableMetadata table_cd = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("test_cd");
        Assertions.assertThat((int)table_ab.getIndexes().size()).isEqualTo(1);
        Assertions.assertThat((Iterable)table_ab.getIndexes()).extracting("name").containsOnly(new Object[]{"test_b"});
        Assertions.assertThat((int)table_cd.getIndexes().size()).isEqualTo(1);
        Assertions.assertThat((Iterable)table_cd.getIndexes()).extracting("name").containsOnly(new Object[]{"test_d"});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.0")
    public void should_parse_extensions_from_table_options() throws Exception {
        String cql = String.format("CREATE TABLE %s.table_with_extensions (\n    k text,\n    c int,\n    v timeuuid,\n    PRIMARY KEY (k, c)\n);", this.keyspace);
        this.session().execute(cql);
        ImmutableMap extensions = ImmutableMap.of((Object)"Hello", (Object)ByteBuffer.wrap("World".getBytes("UTF-8")));
        this.session().execute("update system_schema.tables set extensions=? where keyspace_name=? and table_name=?", new Object[]{extensions, this.keyspace, "table_with_extensions"});
        this.cluster().manager.controlConnection.refreshSchema(SchemaElement.TABLE, this.keyspace, "table_with_extensions", null);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("table_with_extensions");
        Assertions.assertThat((Map)table.getOptions().getExtensions()).isEqualTo((Object)extensions);
    }

    @Test(groups={"short"})
    public void should_parse_table_with_case_sensitive_column_names_and_reserved_keywords() throws Exception {
        String c1 = Metadata.quote((String)"quotes go \"\" here \"\" ");
        String c2 = Metadata.quote((String)"\\x00\\x25");
        String c3 = Metadata.quote((String)"columnfamily");
        String c4 = Metadata.quote((String)"select");
        String c5 = Metadata.quote((String)"who''s there'? ");
        String c6 = Metadata.quote((String)"faux )");
        String c7 = Metadata.quote((String)"COMPACT STORAGE");
        String cql1 = String.format("CREATE TABLE %s.\"MyTable1\" (%s text, %s text, %s text, %s text, %s text, %s text, %s text, PRIMARY KEY (%s, %s, %s, %s, %s, %s))", this.keyspace, c1, c2, c3, c4, c5, c6, c7, c1, c2, c3, c4, c5, c6);
        String cql2 = String.format("CREATE TABLE %s.\"MyTable2\" (%s text, %s text, %s text, %s text, %s text, %s text, %s text, PRIMARY KEY ((%s, %s), %s, %s, %s, %s))", this.keyspace, c1, c2, c3, c4, c5, c6, c7, c1, c2, c3, c4, c5, c6);
        this.execute(cql1, cql2);
        TableMetadata table1 = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("\"MyTable1\"");
        TableMetadata table2 = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("\"MyTable2\"");
        Assertions.assertThat(table1).hasColumn(c1).hasColumn(c2).hasColumn(c3).hasColumn(c4).hasColumn(c5).hasColumn(c6).hasColumn(c7);
        Assertions.assertThat((String)table1.asCQLQuery()).startsWith((CharSequence)cql1);
        Assertions.assertThat(table2).hasColumn(c1).hasColumn(c2).hasColumn(c3).hasColumn(c4).hasColumn(c5).hasColumn(c6).hasColumn(c7);
        Assertions.assertThat((String)table2.asCQLQuery()).startsWith((CharSequence)cql2);
        this.execute("DROP TABLE \"MyTable1\"", "DROP TABLE \"MyTable2\"", table1.asCQLQuery(), table2.asCQLQuery());
    }
}

