/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeCodecAssert;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TypeCodecTest {
    public static final DataType CUSTOM_FOO = DataType.custom((String)"com.example.FooBar");
    public static final TypeToken<List<A>> LIST_OF_A_TOKEN = new TypeToken<List<A>>(){};
    public static final TypeToken<List<B>> LIST_OF_B_TOKEN = new TypeToken<List<B>>(){};
    private CodecRegistry codecRegistry = new CodecRegistry();

    @Test(groups={"unit"})
    public void testCustomList() throws Exception {
        DataType.CollectionType cqlType = DataType.list((DataType)CUSTOM_FOO);
        TypeCodec codec = this.codecRegistry.codecFor((DataType)cqlType);
        ((TypeCodecAssert)Assertions.assertThat(codec).isNotNull()).accepts((DataType)cqlType);
    }

    @Test(groups={"unit"})
    public void testCustomSet() throws Exception {
        DataType.CollectionType cqlType = DataType.set((DataType)CUSTOM_FOO);
        TypeCodec codec = this.codecRegistry.codecFor((DataType)cqlType);
        ((TypeCodecAssert)Assertions.assertThat(codec).isNotNull()).accepts((DataType)cqlType);
    }

    @Test(groups={"unit"})
    public void testCustomKeyMap() throws Exception {
        DataType.CollectionType cqlType = DataType.map((DataType)CUSTOM_FOO, (DataType)DataType.text());
        TypeCodec codec = this.codecRegistry.codecFor((DataType)cqlType);
        ((TypeCodecAssert)Assertions.assertThat(codec).isNotNull()).accepts((DataType)cqlType);
    }

    @Test(groups={"unit"})
    public void testCustomValueMap() throws Exception {
        DataType.CollectionType cqlType = DataType.map((DataType)DataType.text(), (DataType)CUSTOM_FOO);
        TypeCodec codec = this.codecRegistry.codecFor((DataType)cqlType);
        ((TypeCodecAssert)Assertions.assertThat(codec).isNotNull()).accepts((DataType)cqlType);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void collectionTooLargeTest() throws Exception {
        DataType.CollectionType cqlType = DataType.list((DataType)DataType.cint());
        List<Integer> list = Collections.nCopies(65536, 1);
        TypeCodec codec = this.codecRegistry.codecFor((DataType)cqlType);
        codec.serialize(list, ProtocolVersion.V2);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void collectionElementTooLargeTest() throws Exception {
        DataType.CollectionType cqlType = DataType.list((DataType)DataType.text());
        ArrayList list = Lists.newArrayList((Object[])new String[]{Strings.repeat((String)"a", (int)65536)});
        TypeCodec codec = this.codecRegistry.codecFor((DataType)cqlType);
        codec.serialize((Object)list, ProtocolVersion.V2);
    }

    @Test(groups={"unit"})
    public void test_cql_list_varchar_to_list_list_integer() {
        ListVarcharToListListInteger codec = new ListVarcharToListListInteger();
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        list.add(Lists.newArrayList((Object[])new Integer[]{1, 2, 3}));
        list.add(Lists.newArrayList((Object[])new Integer[]{4, 5, 6}));
        Assertions.assertThat(codec).canSerialize(list);
    }

    @Test(groups={"unit"})
    public void test_ascii_vs_utf8() {
        TypeCodec asciiCodec = TypeCodec.ascii();
        TypeCodec utf8Codec = TypeCodec.varchar();
        String ascii = "The quick brown fox jumps over the lazy dog!";
        String utf8 = "D\u00e8s No\u00ebl, o\u00f9 un z\u00e9phyr ha\u00ef me v\u00eat de gla\u00e7ons w\u00fcrmiens, je d\u00eene d\u2019exquis r\u00f4tis de b\u0153uf au kir \u00e0 l\u2019a\u00ff d\u2019\u00e2ge m\u00fbr & c\u00e6tera!";
        Assertions.assertThat(asciiCodec).accepts(String.class).accepts(DataType.ascii()).doesNotAccept(DataType.varchar()).doesNotAccept(DataType.text()).accepts(ascii).canSerialize(ascii).cannotSerialize(utf8);
        Assertions.assertThat(utf8Codec).accepts(String.class).doesNotAccept(DataType.ascii()).accepts(DataType.varchar()).accepts(DataType.text()).accepts(ascii).accepts(utf8).canSerialize(ascii).canSerialize(utf8);
    }

    @Test(groups={"unit"})
    public void test_varchar_vs_text() {
        Assertions.assertThat(TypeCodec.varchar()).accepts(String.class).accepts(DataType.varchar()).accepts(DataType.text());
        Assertions.assertThat(TypeCodec.list((TypeCodec)TypeCodec.varchar())).accepts((DataType)DataType.list((DataType)DataType.varchar())).accepts((DataType)DataType.list((DataType)DataType.text()));
        Assertions.assertThat(TypeCodec.set((TypeCodec)TypeCodec.varchar())).accepts((DataType)DataType.set((DataType)DataType.varchar())).accepts((DataType)DataType.set((DataType)DataType.text()));
        Assertions.assertThat(TypeCodec.map((TypeCodec)TypeCodec.varchar(), (TypeCodec)TypeCodec.varchar())).accepts((DataType)DataType.map((DataType)DataType.varchar(), (DataType)DataType.varchar())).accepts((DataType)DataType.map((DataType)DataType.varchar(), (DataType)DataType.text())).accepts((DataType)DataType.map((DataType)DataType.text(), (DataType)DataType.varchar())).accepts((DataType)DataType.map((DataType)DataType.text(), (DataType)DataType.text()));
        TupleType t1 = new TupleType((List)Lists.newArrayList((Object[])new DataType[]{DataType.varchar(), DataType.varchar()}), ProtocolVersion.V3, new CodecRegistry());
        TupleType t2 = new TupleType((List)Lists.newArrayList((Object[])new DataType[]{DataType.text(), DataType.varchar()}), ProtocolVersion.V3, new CodecRegistry());
        TupleType t3 = new TupleType((List)Lists.newArrayList((Object[])new DataType[]{DataType.varchar(), DataType.text()}), ProtocolVersion.V3, new CodecRegistry());
        TupleType t4 = new TupleType((List)Lists.newArrayList((Object[])new DataType[]{DataType.text(), DataType.text()}), ProtocolVersion.V3, new CodecRegistry());
        Assertions.assertThat(TypeCodec.tuple((TupleType)t1)).accepts((DataType)t2).accepts((DataType)t3).accepts((DataType)t4);
        UserType u1 = new UserType("ks", "table", false, (Collection)Lists.newArrayList((Object[])new UserType.Field[]{new UserType.Field("f1", DataType.varchar()), new UserType.Field("f2", DataType.varchar())}), ProtocolVersion.V3, new CodecRegistry());
        UserType u2 = new UserType("ks", "table", false, (Collection)Lists.newArrayList((Object[])new UserType.Field[]{new UserType.Field("f1", DataType.text()), new UserType.Field("f2", DataType.varchar())}), ProtocolVersion.V3, new CodecRegistry());
        UserType u3 = new UserType("ks", "table", false, (Collection)Lists.newArrayList((Object[])new UserType.Field[]{new UserType.Field("f1", DataType.varchar()), new UserType.Field("f2", DataType.text())}), ProtocolVersion.V3, new CodecRegistry());
        UserType u4 = new UserType("ks", "table", false, (Collection)Lists.newArrayList((Object[])new UserType.Field[]{new UserType.Field("f1", DataType.text()), new UserType.Field("f2", DataType.text())}), ProtocolVersion.V3, new CodecRegistry());
        Assertions.assertThat(TypeCodec.userType((UserType)u1)).accepts((DataType)u2).accepts((DataType)u3).accepts((DataType)u4);
    }

    @Test(groups={"unit"})
    public void test_inheritance() {
        CodecRegistry codecRegistry = new CodecRegistry();
        ACodec aCodec = new ACodec();
        codecRegistry.register((TypeCodec)aCodec);
        ((TypeCodecAssert)Assertions.assertThat(codecRegistry.codecFor(DataType.cint(), A.class)).isNotNull()).isSameAs((Object)aCodec);
        try {
            codecRegistry.codecFor(DataType.cint(), B.class);
            Assert.fail();
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        TypeCodec expected = TypeCodec.list((TypeCodec)aCodec);
        TypeCodec actual = codecRegistry.codecFor((DataType)DataType.list((DataType)DataType.cint()), LIST_OF_A_TOKEN);
        Assertions.assertThat(actual.getCqlType()).isEqualTo(expected.getCqlType());
        Assertions.assertThat((Object)actual.getJavaType()).isEqualTo((Object)expected.getJavaType());
        try {
            codecRegistry.codecFor((DataType)DataType.list((DataType)DataType.cint()), LIST_OF_B_TOKEN);
            Assert.fail();
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        codecRegistry = new CodecRegistry();
        BCodec bCodec = new BCodec();
        codecRegistry.register((TypeCodec)bCodec);
        try {
            Assertions.assertThat(codecRegistry.codecFor(DataType.cint(), A.class));
            Assert.fail();
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        ((TypeCodecAssert)Assertions.assertThat(codecRegistry.codecFor(DataType.cint(), B.class)).isNotNull()).isSameAs((Object)bCodec);
        try {
            codecRegistry.codecFor((DataType)DataType.list((DataType)DataType.cint()), LIST_OF_A_TOKEN);
            Assert.fail();
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        TypeCodec expectedB = TypeCodec.list((TypeCodec)bCodec);
        TypeCodec actualB = codecRegistry.codecFor((DataType)DataType.list((DataType)DataType.cint()), LIST_OF_B_TOKEN);
        Assertions.assertThat(actualB.getCqlType()).isEqualTo(expectedB.getCqlType());
        Assertions.assertThat((Object)actualB.getJavaType()).isEqualTo((Object)expectedB.getJavaType());
    }

    @Test(groups={"unit"})
    public void should_deserialize_empty_buffer_as_tuple_with_null_values() {
        CodecRegistry codecRegistry = new CodecRegistry();
        TupleType tupleType = new TupleType((List)Lists.newArrayList((Object[])new DataType[]{DataType.cint(), DataType.varchar(), DataType.cfloat()}), ProtocolVersion.NEWEST_SUPPORTED, codecRegistry);
        TupleValue expected = tupleType.newValue(new Object[]{null, null, null});
        TupleValue actual = (TupleValue)codecRegistry.codecFor((DataType)tupleType, TupleValue.class).deserialize(ByteBuffer.allocate(0), ProtocolVersion.NEWEST_SUPPORTED);
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test(groups={"unit"})
    public void should_deserialize_empty_buffer_as_udt_with_null_values() {
        CodecRegistry codecRegistry = new CodecRegistry();
        UserType udt = new UserType("ks", "t", false, Arrays.asList(new UserType.Field("t", DataType.text()), new UserType.Field("i", DataType.cint()), new UserType.Field("l", (DataType)DataType.list((DataType)DataType.text()))), ProtocolVersion.NEWEST_SUPPORTED, codecRegistry);
        UDTValue expected = udt.newValue();
        expected.setString("t", null);
        expected.setToNull("i");
        expected.setList("l", null);
        UDTValue actual = (UDTValue)codecRegistry.codecFor((DataType)udt, UDTValue.class).deserialize(ByteBuffer.allocate(0), ProtocolVersion.NEWEST_SUPPORTED);
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test(groups={"unit"})
    public void should_resolve_timeuuid_codec_for_all_uuids_and_fail_to_serialize_non_type1_uuid() {
        UUID type4UUID = UUID.randomUUID();
        TypeCodec codec = this.codecRegistry.codecFor(DataType.timeuuid(), (Object)type4UUID);
        ((TypeCodecAssert)Assertions.assertThat(codec).isSameAs(TypeCodec.timeUUID())).accepts(UUID.class).cannotSerialize(type4UUID).cannotFormat(type4UUID);
    }

    @Test(groups={"unit"})
    public void should_wrap_primitive_types() {
        Assertions.assertThat(TypeCodec.cboolean()).accepts(Boolean.class).accepts(Boolean.TYPE).accepts(true);
        Assertions.assertThat(TypeCodec.cint()).accepts(Integer.class).accepts(Integer.TYPE).accepts(42);
        Assertions.assertThat(TypeCodec.bigint()).accepts(Long.class).accepts(Long.TYPE).accepts(42L);
        Assertions.assertThat(TypeCodec.cfloat()).accepts(Float.class).accepts(Float.TYPE).accepts(Float.valueOf(42.0f));
        Assertions.assertThat(TypeCodec.cdouble()).accepts(Double.class).accepts(Double.TYPE).accepts(42.0);
    }

    class BCodec
    extends TypeCodec<B> {
        protected BCodec() {
            super(DataType.cint(), B.class);
        }

        public ByteBuffer serialize(B value, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return null;
        }

        public B deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return null;
        }

        public B parse(String value) throws InvalidTypeException {
            return null;
        }

        public String format(B value) throws InvalidTypeException {
            return null;
        }
    }

    class ACodec
    extends TypeCodec<A> {
        protected ACodec() {
            super(DataType.cint(), A.class);
        }

        public ByteBuffer serialize(A value, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return null;
        }

        public A deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return null;
        }

        public A parse(String value) throws InvalidTypeException {
            return null;
        }

        public String format(A value) throws InvalidTypeException {
            return null;
        }
    }

    class B
    extends A {
        B() {
            this.i = 1;
        }
    }

    class A {
        int i = 0;

        A() {
        }
    }

    private class ListVarcharToListListInteger
    extends TypeCodec<List<List<Integer>>> {
        private final TypeCodec<List<String>> codec;

        protected ListVarcharToListListInteger() {
            super((DataType)DataType.list((DataType)DataType.varchar()), TypeTokens.listOf((TypeToken)TypeTokens.listOf(Integer.class)));
            this.codec = TypeCodec.list((TypeCodec)TypeCodec.varchar());
        }

        public ByteBuffer serialize(List<List<Integer>> value, ProtocolVersion protocolVersion) {
            return this.codec.serialize((Object)Lists.transform(value, (Function)new Function<List<Integer>, String>(){

                public String apply(List<Integer> input) {
                    return Joiner.on((String)",").join(input);
                }
            }), protocolVersion);
        }

        public List<List<Integer>> deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return Lists.transform((List)((List)this.codec.deserialize(bytes, protocolVersion)), (Function)new Function<String, List<Integer>>(){

                public List<Integer> apply(String input) {
                    return Lists.transform(Arrays.asList(input.split(",")), (Function)new Function<String, Integer>(){

                        public Integer apply(String input) {
                            return Integer.parseInt(input);
                        }
                    });
                }
            });
        }

        public List<List<Integer>> parse(String value) {
            throw new UnsupportedOperationException();
        }

        public String format(List<List<Integer>> value) {
            throw new UnsupportedOperationException();
        }
    }
}

