/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.scassandra.Scassandra;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExceptionsScassandraTest {
    protected ScassandraCluster scassandras;
    protected Cluster cluster;
    protected Metrics.Errors errors;
    protected Host host1;
    protected Session session;

    @BeforeClass(groups={"short"})
    public void beforeClass() {
        this.scassandras = ScassandraCluster.builder().withNodes(1).build();
        this.scassandras.init();
    }

    @BeforeMethod(groups={"short"})
    public void beforeMethod() {
        this.cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandras.address(1).getAddress()}).withPort(this.scassandras.getBinaryPort()).withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE).build();
        this.session = this.cluster.connect();
        this.host1 = TestUtils.findHost(this.cluster, 1);
        this.errors = this.cluster.getMetrics().getErrorMetrics();
        for (Scassandra node : this.scassandras.nodes()) {
            node.primingClient().clearAllPrimes();
            node.activityClient().clearAllRecordedActivity();
        }
    }

    @Test(groups={"short"})
    public void should_throw_proper_unavailable_exception() {
        this.simulateError(1, Result.unavailable);
        try {
            this.query();
            Assertions.fail((String)"expected an UnavailableException");
        }
        catch (UnavailableException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Not enough replicas available for query at consistency LOCAL_ONE (1 required but only 0 alive)");
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_ONE);
            Assertions.assertThat((int)e.getAliveReplicas()).isEqualTo(0);
            Assertions.assertThat((int)e.getRequiredReplicas()).isEqualTo(1);
            Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.host1.getSocketAddress());
            Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.host1.getAddress());
        }
    }

    @Test(groups={"short"})
    public void should_throw_proper_read_timeout_exception() {
        this.simulateError(1, Result.read_request_timeout);
        try {
            this.query();
            Assertions.fail((String)"expected a ReadTimeoutException");
        }
        catch (ReadTimeoutException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Cassandra timeout during read query at consistency LOCAL_ONE (1 responses were required but only 0 replica responded)");
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_ONE);
            Assertions.assertThat((int)e.getReceivedAcknowledgements()).isEqualTo(0);
            Assertions.assertThat((int)e.getRequiredAcknowledgements()).isEqualTo(1);
            Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.host1.getSocketAddress());
            Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.host1.getAddress());
        }
    }

    @Test(groups={"short"})
    public void should_throw_proper_write_timeout_exception() {
        this.simulateError(1, Result.write_request_timeout);
        try {
            this.query();
            Assertions.fail((String)"expected a WriteTimeoutException");
        }
        catch (WriteTimeoutException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Cassandra timeout during write query at consistency LOCAL_ONE (1 replica were required but only 0 acknowledged the write)");
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_ONE);
            Assertions.assertThat((int)e.getReceivedAcknowledgements()).isEqualTo(0);
            Assertions.assertThat((int)e.getRequiredAcknowledgements()).isEqualTo(1);
            Assertions.assertThat((Comparable)e.getWriteType()).isEqualTo((Object)WriteType.SIMPLE);
            Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.host1.getSocketAddress());
            Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.host1.getAddress());
        }
    }

    protected void simulateError(int hostNumber, Result result) {
        this.scassandras.node(hostNumber).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withResult(result)).build());
    }

    private static List<Map<String, ?>> row(String key, String value) {
        return ImmutableList.of((Object)ImmutableMap.of((Object)key, (Object)value));
    }

    protected ResultSet query() {
        return this.query(this.session);
    }

    protected ResultSet query(Session session) {
        return session.execute("mock query");
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void afterMethod() {
        for (Scassandra node : this.scassandras.nodes()) {
            node.primingClient().clearAllPrimes();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    @AfterClass(groups={"short"}, alwaysRun=true)
    public void afterClass() {
        if (this.scassandras != null) {
            this.scassandras.stop();
        }
    }
}

