/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.SortingLoadBalancingPolicy;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scassandra.Scassandra;
import org.scassandra.http.client.ClosedConnectionConfig;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;

public class AbstractRetryPolicyIntegrationTest {
    protected ScassandraCluster scassandras;
    protected Cluster cluster = null;
    protected Metrics.Errors errors;
    protected Host host1;
    protected Host host2;
    protected Host host3;
    protected Session session;
    protected RetryPolicy retryPolicy;

    protected AbstractRetryPolicyIntegrationTest() {
    }

    protected AbstractRetryPolicyIntegrationTest(RetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
    }

    protected final void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = (RetryPolicy)Mockito.spy((Object)retryPolicy);
    }

    @BeforeMethod(groups={"short"})
    public void beforeMethod() {
        this.scassandras = ScassandraCluster.builder().withNodes(3).build();
        this.scassandras.init();
        this.cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandras.address(1).getAddress()}).withPort(this.scassandras.getBinaryPort()).withRetryPolicy(this.retryPolicy).withLoadBalancingPolicy((LoadBalancingPolicy)new SortingLoadBalancingPolicy()).withPoolingOptions(new PoolingOptions().setCoreConnectionsPerHost(HostDistance.LOCAL, 1).setMaxConnectionsPerHost(HostDistance.LOCAL, 1).setHeartbeatIntervalSeconds(0)).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withQueryOptions(new QueryOptions().setDefaultIdempotence(true)).build();
        this.session = this.cluster.connect();
        this.host1 = TestUtils.findHost(this.cluster, 1);
        this.host2 = TestUtils.findHost(this.cluster, 2);
        this.host3 = TestUtils.findHost(this.cluster, 3);
        this.errors = this.cluster.getMetrics().getErrorMetrics();
        Mockito.reset((Object[])new RetryPolicy[]{this.retryPolicy});
        for (Scassandra node : this.scassandras.nodes()) {
            node.activityClient().clearAllRecordedActivity();
        }
    }

    protected void simulateError(int hostNumber, Result result) {
        this.simulateError(hostNumber, result, null);
    }

    protected void simulateError(int hostNumber, Result result, Config config) {
        PrimingRequest.Then.ThenBuilder then = PrimingRequest.then().withResult(result);
        PrimingRequest.PrimingRequestBuilder builder = PrimingRequest.queryBuilder().withQuery("mock query");
        if (config != null) {
            then = then.withConfig(config);
        }
        builder = builder.withThen(then);
        this.scassandras.node(hostNumber).primingClient().prime(builder.build());
    }

    protected void simulateNormalResponse(int hostNumber) {
        this.scassandras.node(hostNumber).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(AbstractRetryPolicyIntegrationTest.row("result", "result1"))).build());
    }

    protected static List<Map<String, ?>> row(String key, String value) {
        return ImmutableList.of((Object)ImmutableMap.of((Object)key, (Object)value));
    }

    protected ResultSet query() {
        return this.query(this.session);
    }

    protected ResultSet queryWithCL(ConsistencyLevel cl) {
        Statement statement = new SimpleStatement("mock query").setConsistencyLevel(cl);
        return this.session.execute(statement);
    }

    protected ResultSet query(Session session) {
        return session.execute("mock query");
    }

    protected void assertOnReadTimeoutWasCalled(int times) {
        ((RetryPolicy)Mockito.verify((Object)this.retryPolicy, (VerificationMode)Mockito.times((int)times))).onReadTimeout((Statement)Matchers.any(Statement.class), (ConsistencyLevel)Matchers.any(ConsistencyLevel.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyInt());
    }

    protected void assertOnWriteTimeoutWasCalled(int times) {
        ((RetryPolicy)Mockito.verify((Object)this.retryPolicy, (VerificationMode)Mockito.times((int)times))).onWriteTimeout((Statement)Matchers.any(Statement.class), (ConsistencyLevel)Matchers.any(ConsistencyLevel.class), (WriteType)Matchers.any(WriteType.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt());
    }

    protected void assertOnUnavailableWasCalled(int times) {
        ((RetryPolicy)Mockito.verify((Object)this.retryPolicy, (VerificationMode)Mockito.times((int)times))).onUnavailable((Statement)Matchers.any(Statement.class), (ConsistencyLevel)Matchers.any(ConsistencyLevel.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt());
    }

    protected void assertOnRequestErrorWasCalled(int times, Class<? extends DriverException> expected) {
        ((RetryPolicy)Mockito.verify((Object)this.retryPolicy, (VerificationMode)Mockito.times((int)times))).onRequestError((Statement)Matchers.any(Statement.class), (ConsistencyLevel)Matchers.any(ConsistencyLevel.class), (DriverException)Matchers.any(expected), Matchers.anyInt());
    }

    protected void assertQueried(int hostNumber, int times) {
        Assertions.assertThat((List)this.scassandras.node(hostNumber).activityClient().retrieveQueries()).hasSize(times);
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void afterMethod() {
        if (this.cluster != null) {
            this.cluster.close();
        }
        if (this.scassandras != null) {
            this.scassandras.stop();
        }
    }

    @DataProvider
    public static Object[][] serverSideErrors() {
        return new Object[][]{{Result.server_error, ServerError.class}, {Result.overloaded, OverloadedException.class}};
    }

    @DataProvider
    public static Object[][] connectionErrors() {
        return new Object[][]{{ClosedConnectionConfig.CloseType.CLOSE}, {ClosedConnectionConfig.CloseType.HALFCLOSE}, {ClosedConnectionConfig.CloseType.RESET}};
    }
}

