/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.TransportException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.AbstractRetryPolicyIntegrationTest;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.scassandra.Scassandra;
import org.scassandra.http.client.ClosedConnectionConfig;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.Consistency;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.scassandra.http.client.UnavailableConfig;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultRetryPolicyIntegrationTest
extends AbstractRetryPolicyIntegrationTest {
    public DefaultRetryPolicyIntegrationTest() {
        super((RetryPolicy)DefaultRetryPolicy.INSTANCE);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_read_timeout_with_0_receivedResponses() {
        this.simulateError(1, Result.read_request_timeout);
        try {
            this.query();
            Assertions.fail((String)"expected a ReadTimeoutException");
        }
        catch (ReadTimeoutException readTimeoutException) {
            // empty catch block
        }
        this.assertOnReadTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getReadTimeouts().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnReadTimeout().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_write_timeout_with_SIMPLE_write_type() {
        this.simulateError(1, Result.write_request_timeout);
        try {
            this.query();
            Assertions.fail((String)"expected a WriteTimeoutException");
        }
        catch (WriteTimeoutException writeTimeoutException) {
            // empty catch block
        }
        this.assertOnWriteTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getWriteTimeouts().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_try_next_host_on_first_unavailable() {
        this.simulateError(1, Result.unavailable);
        this.simulateNormalResponse(2);
        this.query();
        this.assertOnUnavailableWasCalled(1);
        Assertions.assertThat((long)this.errors.getUnavailables().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetriesOnUnavailable().getCount()).isEqualTo(1L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_second_unavailable() {
        this.simulateError(1, Result.unavailable);
        this.simulateError(2, Result.unavailable);
        try {
            this.query();
            Assertions.fail((String)"expected an UnavailableException");
        }
        catch (UnavailableException unavailableException) {
            // empty catch block
        }
        this.assertOnUnavailableWasCalled(2);
        Assertions.assertThat((long)this.errors.getUnavailables().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetriesOnUnavailable().getCount()).isEqualTo(1L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_rethrow_unavailable_in_no_host_available_exception() {
        WhiteListPolicy firstHostOnlyPolicy = new WhiteListPolicy(Policies.defaultLoadBalancingPolicy(), Collections.singletonList(this.host1.getSocketAddress()));
        Cluster whiteListedCluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandras.address(1).getAddress()}).withPort(this.scassandras.getBinaryPort()).withRetryPolicy(this.retryPolicy).withLoadBalancingPolicy((LoadBalancingPolicy)firstHostOnlyPolicy).build();
        try {
            Session whiteListedSession = whiteListedCluster.connect();
            for (Scassandra node : this.scassandras.nodes()) {
                node.activityClient().clearAllRecordedActivity();
            }
            this.simulateError(1, Result.unavailable);
            try {
                this.query(whiteListedSession);
                Assertions.fail((String)"expected an NoHostAvailableException");
            }
            catch (NoHostAvailableException e) {
                Throwable error = (Throwable)e.getErrors().get(this.host1.getSocketAddress());
                Assertions.assertThat((Throwable)error).isNotNull();
                Assertions.assertThat((Throwable)error).isInstanceOf(UnavailableException.class);
            }
            this.assertOnUnavailableWasCalled(1);
            Metrics.Errors whiteListErrors = whiteListedCluster.getMetrics().getErrorMetrics();
            Assertions.assertThat((long)whiteListErrors.getRetriesOnUnavailable().getCount()).isEqualTo(1L);
            this.assertQueried(1, 1);
            this.assertQueried(2, 0);
            this.assertQueried(3, 0);
        }
        finally {
            whiteListedCluster.close();
        }
    }

    @Test(groups={"short"})
    public void should_try_next_host_on_client_timeouts() {
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(1);
        try {
            this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(DefaultRetryPolicyIntegrationTest.row("result", "result1"))).build());
            this.scassandras.node(2).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(DefaultRetryPolicyIntegrationTest.row("result", "result2"))).build());
            this.scassandras.node(3).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(DefaultRetryPolicyIntegrationTest.row("result", "result3"))).build());
            try {
                this.query();
                Assertions.fail((String)"expected a NoHostAvailableException");
            }
            catch (NoHostAvailableException e) {
                Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
                Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(OperationTimedOutException.class).extractingResultOf("getMessage").containsOnlyOnce(new Object[]{String.format("[%s] Timed out waiting for server response", this.host1.getSocketAddress()), String.format("[%s] Timed out waiting for server response", this.host2.getSocketAddress()), String.format("[%s] Timed out waiting for server response", this.host3.getSocketAddress())});
            }
            this.assertOnRequestErrorWasCalled(3, OperationTimedOutException.class);
            Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
            Assertions.assertThat((long)this.errors.getClientTimeouts().getCount()).isEqualTo(3L);
            Assertions.assertThat((long)this.errors.getRetriesOnClientTimeout().getCount()).isEqualTo(3L);
            this.assertQueried(1, 1);
            this.assertQueried(2, 1);
            this.assertQueried(3, 1);
        }
        finally {
            this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(12000);
        }
    }

    @Test(groups={"short"}, dataProvider="serverSideErrors")
    public void should_try_next_host_on_server_side_error(Result error, Class<? extends DriverException> exception) {
        this.simulateError(1, error);
        this.simulateError(2, error);
        this.simulateError(3, error);
        try {
            this.query();
            Fail.fail((String)"expected a NoHostAvailableException");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
            Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(exception);
        }
        this.assertOnRequestErrorWasCalled(3, exception);
        Assertions.assertThat((long)this.errors.getOthers().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getRetriesOnOtherErrors().getCount()).isEqualTo(3L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 1);
    }

    @Test(groups={"short"}, dataProvider="connectionErrors")
    public void should_try_next_host_on_connection_error(ClosedConnectionConfig.CloseType closeType) {
        this.simulateError(1, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(2, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(3, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        try {
            this.query();
            Fail.fail((String)"expected a NoHostAvailableException");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
            Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(TransportException.class);
        }
        this.assertOnRequestErrorWasCalled(3, TransportException.class);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getConnectionErrors().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getIgnoresOnConnectionError().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnConnectionError().getCount()).isEqualTo(3L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 1);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_unavailable_if_CAS() {
        this.simulateError(1, Result.unavailable, (Config)new UnavailableConfig(1, 0, Consistency.LOCAL_SERIAL));
        this.simulateError(2, Result.unavailable, (Config)new UnavailableConfig(1, 0, Consistency.LOCAL_SERIAL));
        try {
            this.query();
            Assert.fail((String)"expected an UnavailableException");
        }
        catch (UnavailableException e) {
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_SERIAL);
        }
        this.assertOnUnavailableWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getUnavailables().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnUnavailable().getCount()).isEqualTo(1L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 0);
    }
}

