/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.policies.EC2MultiRegionAddressTranslator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

public class EC2MultiRegionAddressTranslatorTest {
    @Test(groups={"unit"})
    public void should_return_same_address_when_no_entry_found() throws Exception {
        InitialDirContext mock = (InitialDirContext)Mockito.mock(InitialDirContext.class);
        Mockito.when((Object)mock.getAttributes(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)new BasicAttributes());
        EC2MultiRegionAddressTranslator translator = new EC2MultiRegionAddressTranslator((DirContext)mock);
        InetSocketAddress address = new InetSocketAddress("192.0.2.5", 9042);
        Assertions.assertThat((Object)translator.translate(address)).isEqualTo((Object)address);
    }

    @Test(groups={"unit"})
    public void should_return_same_address_when_exception_encountered() throws Exception {
        InitialDirContext mock = (InitialDirContext)Mockito.mock(InitialDirContext.class);
        Mockito.when((Object)mock.getAttributes(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenThrow(new Throwable[]{new NamingException("Problem resolving address (not really).")});
        EC2MultiRegionAddressTranslator translator = new EC2MultiRegionAddressTranslator((DirContext)mock);
        InetSocketAddress address = new InetSocketAddress("192.0.2.5", 9042);
        Assertions.assertThat((Object)translator.translate(address)).isEqualTo((Object)address);
    }

    @Test(groups={"unit"})
    public void should_return_new_address_when_match_found() throws Exception {
        InetSocketAddress expectedAddress = new InetSocketAddress("54.32.55.66", 9042);
        InitialDirContext mock = (InitialDirContext)Mockito.mock(InitialDirContext.class);
        Mockito.when((Object)mock.getAttributes("5.2.0.192.in-addr.arpa", new String[]{"PTR"})).thenReturn((Object)new BasicAttributes("PTR", expectedAddress.getHostName()));
        EC2MultiRegionAddressTranslator translator = new EC2MultiRegionAddressTranslator((DirContext)mock);
        InetSocketAddress address = new InetSocketAddress("192.0.2.5", 9042);
        Assertions.assertThat((Object)translator.translate(address)).isEqualTo((Object)expectedAddress);
    }

    @Test(groups={"unit"})
    public void should_close_context_when_closed() throws Exception {
        InitialDirContext mock = (InitialDirContext)Mockito.mock(InitialDirContext.class);
        EC2MultiRegionAddressTranslator translator = new EC2MultiRegionAddressTranslator((DirContext)mock);
        ((InitialDirContext)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)0))).close();
        translator.close();
        ((InitialDirContext)Mockito.verify((Object)mock)).close();
    }

    @Test(groups={"unit"})
    public void should_build_reversed_domain_name_for_ip_v4() throws Exception {
        InetAddress address = InetAddress.getByName("192.0.2.5");
        Assertions.assertThat((String)EC2MultiRegionAddressTranslator.reverse((InetAddress)address)).isEqualTo((Object)"5.2.0.192.in-addr.arpa");
    }

    @Test(groups={"unit"})
    public void should_build_reversed_domain_name_for_ip_v6() throws Exception {
        InetAddress address = InetAddress.getByName("2001:db8::567:89ab");
        Assertions.assertThat((String)EC2MultiRegionAddressTranslator.reverse((InetAddress)address)).isEqualTo((Object)"b.a.9.8.7.6.5.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.8.b.d.0.1.0.0.2.ip6.arpa");
    }
}

