/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.DelegatingLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LimitingLoadBalancingPolicy
extends DelegatingLoadBalancingPolicy {
    private final int maxHosts;
    private final int threshold;
    private final Set<Host> liveHosts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Host> chosenHosts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Lock updateLock = new ReentrantLock();
    private volatile Cluster cluster;

    public LimitingLoadBalancingPolicy(LoadBalancingPolicy delegate, int maxHosts, int threshold) {
        super(delegate);
        this.maxHosts = maxHosts;
        this.threshold = threshold;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.cluster = cluster;
        Iterator<Host> hostIt = hosts.iterator();
        while (hostIt.hasNext() && this.chosenHosts.size() <= this.maxHosts - this.threshold) {
            this.chosenHosts.add(hostIt.next());
        }
        this.delegate.init(cluster, new ArrayList<Host>(this.chosenHosts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChosenHosts() {
        if (this.chosenHosts.size() > this.maxHosts - this.threshold || this.liveHosts.size() == 0) {
            return;
        }
        this.updateLock.lock();
        try {
            int missing = this.maxHosts - this.chosenHosts.size();
            if (missing < this.threshold || this.liveHosts.size() == 0) {
                return;
            }
            HashSet<Host> newlyChosen = new HashSet<Host>();
            for (Host host : this.liveHosts) {
                newlyChosen.add(host);
                if (--missing != 0) continue;
                break;
            }
            this.chosenHosts.addAll(newlyChosen);
            this.liveHosts.removeAll(newlyChosen);
            for (Host host : newlyChosen) {
                this.delegate.onAdd(host);
                this.cluster.getConfiguration().getPoolingOptions().refreshConnectedHost(host);
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    @Override
    public HostDistance distance(Host host) {
        if (this.chosenHosts.contains(host)) {
            return this.delegate.distance(host);
        }
        return HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        return this.delegate.newQueryPlan(loggedKeyspace, statement);
    }

    @Override
    public void onAdd(Host host) {
        this.liveHosts.add(host);
        this.updateChosenHosts();
    }

    @Override
    public void onUp(Host host) {
        this.onAdd(host);
    }

    @Override
    public void onDown(Host host) {
        this.delegate.onDown(host);
        this.liveHosts.remove(host);
        this.chosenHosts.remove(host);
        this.updateChosenHosts();
    }

    @Override
    public void onRemove(Host host) {
        this.delegate.onRemove(host);
        this.liveHosts.remove(host);
        this.chosenHosts.remove(host);
        this.updateChosenHosts();
    }
}

