/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetAssert;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.data.MapEntry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryBuilderExecutionTest
extends CCMTestsSupport {
    private static final String TABLE1 = TestUtils.generateIdentifier("test1");
    private static final String TABLE2 = TestUtils.generateIdentifier("test2");

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE1), String.format("CREATE TABLE %s (k text, t text, i int, f float, PRIMARY KEY (k, t))", TABLE2), "CREATE TABLE dateTest (t timestamp PRIMARY KEY)", "CREATE TABLE test_coll (k int PRIMARY KEY, a list<int>, b map<int,text>, c set<text>)", "CREATE TABLE test_ppl (a int, b int, c int, PRIMARY KEY (a, b))", QueryBuilder.insertInto((String)TABLE2).value("k", (Object)"cast_t").value("t", (Object)"a").value("i", (Object)1).value("f", (Object)1.1).toString(), QueryBuilder.insertInto((String)TABLE2).value("k", (Object)"cast_t").value("t", (Object)"b").value("i", (Object)2).value("f", (Object)2.5).toString(), QueryBuilder.insertInto((String)TABLE2).value("k", (Object)"cast_t").value("t", (Object)"c").value("i", (Object)3).value("f", (Object)3.7).toString(), QueryBuilder.insertInto((String)TABLE2).value("k", (Object)"cast_t").value("t", (Object)"d").value("i", (Object)4).value("f", (Object)5.0).toString());
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.session().execute(String.format("INSERT INTO test_ppl (a, b, c) VALUES (%d, %d, %d)", i, j, j));
            }
        }
    }

    @Test(groups={"short"})
    public void executeTest() throws Exception {
        this.session().execute((Statement)QueryBuilder.insertInto((String)TABLE1).value("k", (Object)"k1").value("t", (Object)"This is a test").value("i", (Object)3).value("f", (Object)0.42));
        this.session().execute((Statement)QueryBuilder.update((String)TABLE1).with(QueryBuilder.set((String)"t", (Object)"Another test")).where(QueryBuilder.eq((String)"k", (Object)"k2")));
        List rows = this.session().execute((Statement)QueryBuilder.select().from(TABLE1).where(QueryBuilder.in((String)"k", (Object[])new Object[]{"k1", "k2"}))).all();
        Assert.assertEquals((int)2, (int)rows.size());
        Row r1 = (Row)rows.get(0);
        Assert.assertEquals((String)"k1", (String)r1.getString("k"));
        Assert.assertEquals((String)"This is a test", (String)r1.getString("t"));
        Assert.assertEquals((int)3, (int)r1.getInt("i"));
        Assert.assertFalse((boolean)r1.isNull("f"));
        Row r2 = (Row)rows.get(1);
        Assert.assertEquals((String)"k2", (String)r2.getString("k"));
        Assert.assertEquals((String)"Another test", (String)r2.getString("t"));
        Assert.assertTrue((boolean)r2.isNull("i"));
        Assert.assertTrue((boolean)r2.isNull("f"));
    }

    @Test(groups={"short"})
    public void dateHandlingTest() throws Exception {
        Date d = new Date();
        this.session().execute((Statement)QueryBuilder.insertInto((String)"dateTest").value("t", (Object)d));
        String query = QueryBuilder.select().from("dateTest").where(QueryBuilder.eq((String)QueryBuilder.token((String)"t"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{d}))).toString();
        List rows = this.session().execute(query).all();
        Assert.assertEquals((int)1, (int)rows.size());
        Row r1 = (Row)rows.get(0);
        Assert.assertEquals((Object)d, (Object)r1.getTimestamp("t"));
    }

    @Test(groups={"short"})
    public void prepareTest() throws Exception {
        String query = "INSERT INTO foo (a,b,c,d) VALUES ('foo','bar',?,0);";
        Insert stmt = QueryBuilder.insertInto((String)"foo").value("a", (Object)"foo").value("b", (Object)"bar").value("c", (Object)QueryBuilder.bindMarker()).value("d", (Object)0);
        Assert.assertEquals((String)stmt.getQueryString(), (String)query);
        query = "INSERT INTO foo (a,b,c,d) VALUES ('foo','bar',:c,0);";
        stmt = QueryBuilder.insertInto((String)"foo").value("a", (Object)"foo").value("b", (Object)"bar").value("c", (Object)QueryBuilder.bindMarker((String)"c")).value("d", (Object)0);
        Assert.assertEquals((String)stmt.getQueryString(), (String)query);
    }

    @Test(groups={"short"})
    public void batchNonBuiltStatementTest() throws Exception {
        SimpleStatement simple = new SimpleStatement("INSERT INTO " + TABLE1 + " (k, t) VALUES ('batchTest1', 'val1')");
        Insert built = QueryBuilder.insertInto((String)TABLE1).value("k", (Object)"batchTest2").value("t", (Object)"val2");
        this.session().execute((Statement)QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)simple).add((RegularStatement)built));
        List rows = this.session().execute((Statement)QueryBuilder.select().from(TABLE1).where(QueryBuilder.in((String)"k", (Object[])new Object[]{"batchTest1", "batchTest2"}))).all();
        Assert.assertEquals((int)2, (int)rows.size());
        Row r1 = (Row)rows.get(0);
        Assert.assertEquals((String)"batchTest1", (String)r1.getString("k"));
        Assert.assertEquals((String)"val1", (String)r1.getString("t"));
        Row r2 = (Row)rows.get(1);
        Assert.assertEquals((String)"batchTest2", (String)r2.getString("k"));
        Assert.assertEquals((String)"val2", (String)r2.getString("t"));
    }

    @Test(groups={"short"})
    public void should_delete_list_element() throws Exception {
        this.session().execute("INSERT INTO test_coll (k, a, b) VALUES (1, [1,2,3], null)");
        Delete.Where statement = QueryBuilder.delete().listElt("a", 1).from("test_coll").where(QueryBuilder.eq((String)"k", (Object)1));
        this.session().execute((Statement)statement);
        List actual = this.session().execute("SELECT a FROM test_coll WHERE k = 1").one().getList("a", Integer.class);
        Assertions.assertThat((List)actual).containsExactly((Object[])new Integer[]{1, 3});
    }

    @Test(groups={"short"})
    public void should_delete_list_element_with_bind_marker() throws Exception {
        this.session().execute("INSERT INTO test_coll (k, a) VALUES (1, [1,2,3])");
        Delete.Where statement = QueryBuilder.delete().listElt("a", QueryBuilder.bindMarker()).from("test_coll").where(QueryBuilder.eq((String)"k", (Object)1));
        PreparedStatement ps = this.session().prepare((RegularStatement)statement);
        this.session().execute((Statement)ps.bind(new Object[]{1}));
        List actual = this.session().execute("SELECT a FROM test_coll WHERE k = 1").one().getList("a", Integer.class);
        Assertions.assertThat((List)actual).containsExactly((Object[])new Integer[]{1, 3});
    }

    @Test(groups={"short"})
    public void should_delete_set_element() throws Exception {
        this.session().execute("INSERT INTO test_coll (k, c) VALUES (1, {'foo','bar','qix'})");
        Delete.Where statement = QueryBuilder.delete().setElt("c", (Object)"foo").from("test_coll").where(QueryBuilder.eq((String)"k", (Object)1));
        this.session().execute((Statement)statement);
        Set actual = this.session().execute("SELECT c FROM test_coll WHERE k = 1").one().getSet("c", String.class);
        Assertions.assertThat((Iterable)actual).containsOnly((Object[])new String[]{"bar", "qix"});
    }

    @Test(groups={"short"})
    public void should_delete_set_element_with_bind_marker() throws Exception {
        this.session().execute("INSERT INTO test_coll (k, c) VALUES (1, {'foo','bar','qix'})");
        Delete.Where statement = QueryBuilder.delete().setElt("c", QueryBuilder.bindMarker()).from("test_coll").where(QueryBuilder.eq((String)"k", (Object)1));
        PreparedStatement ps = this.session().prepare((RegularStatement)statement);
        this.session().execute((Statement)ps.bind(new Object[]{"foo"}));
        Set actual = this.session().execute("SELECT c FROM test_coll WHERE k = 1").one().getSet("c", String.class);
        Assertions.assertThat((Iterable)actual).containsOnly((Object[])new String[]{"bar", "qix"});
    }

    @Test(groups={"short"})
    public void should_delete_map_entry() throws Exception {
        this.session().execute("INSERT INTO test_coll (k, b) VALUES (1, {1:'foo', 2:'bar'})");
        Delete.Where statement = QueryBuilder.delete().mapElt("b", (Object)1).from("test_coll").where(QueryBuilder.eq((String)"k", (Object)1));
        this.session().execute((Statement)statement);
        Map actual = this.session().execute("SELECT b FROM test_coll WHERE k = 1").one().getMap("b", Integer.class, String.class);
        Assertions.assertThat((Map)actual).containsExactly(new MapEntry[]{MapEntry.entry((Object)2, (Object)"bar")});
    }

    @Test(groups={"short"})
    public void should_delete_map_entry_with_bind_marker() throws Exception {
        this.session().execute("INSERT INTO test_coll (k, a, b) VALUES (1, null, {1:'foo', 2:'bar'})");
        Delete.Where statement = QueryBuilder.delete().mapElt("b", (Object)QueryBuilder.bindMarker()).from("test_coll").where(QueryBuilder.eq((String)"k", (Object)1));
        PreparedStatement ps = this.session().prepare((RegularStatement)statement);
        this.session().execute((Statement)ps.bind().setInt(0, 1));
        Map actual = this.session().execute("SELECT b FROM test_coll WHERE k = 1").one().getMap("b", Integer.class, String.class);
        Assertions.assertThat((Map)actual).containsExactly(new MapEntry[]{MapEntry.entry((Object)2, (Object)"bar")});
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.2")
    public void should_support_cast_function_on_column() {
        ResultSet r = this.session().execute((Statement)QueryBuilder.select().cast((Object)"f", DataType.cint()).as("fint").column("i").from(TABLE2).where(QueryBuilder.eq((String)"k", (Object)"cast_t")));
        Assertions.assertThat((int)r.getAvailableWithoutFetching()).isEqualTo(4);
        block6: for (Row row : r) {
            Integer i = row.getInt("i");
            Assertions.assertThat(row.getColumnDefinitions().getType("fint")).isEqualTo(DataType.cint());
            Integer f = row.getInt("fint");
            switch (i) {
                case 1: {
                    Assertions.assertThat((Integer)f).isEqualTo(1);
                    continue block6;
                }
                case 2: {
                    Assertions.assertThat((Integer)f).isEqualTo(2);
                    continue block6;
                }
                case 3: {
                    Assertions.assertThat((Integer)f).isEqualTo(3);
                    continue block6;
                }
                case 4: {
                    Assertions.assertThat((Integer)f).isEqualTo(5);
                    continue block6;
                }
            }
            Assert.fail((String)("Unexpected values: " + i + "," + f));
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.2")
    public void should_support_fcall_on_cast_column() {
        ResultSet ar = this.session().execute((Statement)QueryBuilder.select().fcall("avg", new Object[]{QueryBuilder.cast((Object)QueryBuilder.column((String)"i"), (DataType)DataType.cfloat())}).as("iavg").from(TABLE2).where(QueryBuilder.eq((String)"k", (Object)"cast_t")));
        Assertions.assertThat((int)ar.getAvailableWithoutFetching()).isEqualTo(1);
        Row row = ar.one();
        Assertions.assertThat(row.getColumnDefinitions().getType("iavg")).isEqualTo(DataType.cfloat());
        Float f = Float.valueOf(row.getFloat("iavg"));
        Assertions.assertThat((Float)f).isEqualTo(2.5f);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.6")
    public void should_retrieve_using_like_operator_on_table_with_sasi_index() {
        String table = "s_table";
        this.session().execute((Statement)SchemaBuilder.createTable((String)table).addPartitionKey("k", DataType.text()).addClusteringColumn("cc", DataType.cint()).addColumn("n", DataType.text()));
        this.session().execute(String.format("CREATE CUSTOM INDEX on %s (n) USING 'org.apache.cassandra.index.sasi.SASIIndex';", table));
        this.session().execute((Statement)QueryBuilder.insertInto((String)table).value("k", (Object)"a").value("cc", (Object)0).value("n", (Object)"Hello World"));
        this.session().execute((Statement)QueryBuilder.insertInto((String)table).value("k", (Object)"a").value("cc", (Object)1).value("n", (Object)"Goodbye World"));
        this.session().execute((Statement)QueryBuilder.insertInto((String)table).value("k", (Object)"b").value("cc", (Object)2).value("n", (Object)"Hello Moon"));
        Select.Where query = QueryBuilder.select((String[])new String[]{"n"}).from(table).where(QueryBuilder.like((String)"n", (Object)"Hello%"));
        ResultSet r = this.session().execute((Statement)query);
        Assertions.assertThat((int)r.getAvailableWithoutFetching()).isEqualTo(2);
        Assertions.assertThat((List)r.all()).extracting((Extractor)new Extractor<Row, String>(){

            public String extract(Row input) {
                return input.getString("n");
            }
        }).containsOnly((Object[])new String[]{"Hello World", "Hello Moon"});
    }

    @CassandraVersion(value="3.6", description="Support for PER PARTITION LIMIT was added to C* 3.6 (CASSANDRA-7017)")
    @Test(groups={"short"})
    public void should_support_per_partition_limit() throws Exception {
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().all().from("test_ppl").perPartitionLimit(2))).contains(ResultSetAssert.row(0, 0, 0), ResultSetAssert.row(0, 1, 1), ResultSetAssert.row(1, 0, 0), ResultSetAssert.row(1, 1, 1), ResultSetAssert.row(2, 0, 0), ResultSetAssert.row(2, 1, 1), ResultSetAssert.row(3, 0, 0), ResultSetAssert.row(3, 1, 1), ResultSetAssert.row(4, 0, 0), ResultSetAssert.row(4, 1, 1));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().all().from("test_ppl").perPartitionLimit(2).limit(6))).hasSize(6);
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().all().from("test_ppl").perPartitionLimit(2).limit(5))).contains(ResultSetAssert.row(0, 0, 0), ResultSetAssert.row(0, 1, 1), ResultSetAssert.row(1, 0, 0), ResultSetAssert.row(1, 1, 1), ResultSetAssert.row(2, 0, 0));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().all().from("test_ppl").where(QueryBuilder.in((String)"a", (Object[])new Object[]{2, 3})).perPartitionLimit(2))).contains(ResultSetAssert.row(2, 0, 0), ResultSetAssert.row(2, 1, 1), ResultSetAssert.row(3, 0, 0), ResultSetAssert.row(3, 1, 1));
        Assertions.assertThat(this.session().execute(QueryBuilder.select().all().from("test_ppl").where(QueryBuilder.in((String)"a", (Object[])new Object[]{2, 3})).perPartitionLimit(QueryBuilder.bindMarker()).limit(3).getQueryString(), new Object[]{2})).hasSize(3);
        Assertions.assertThat(this.session().execute(QueryBuilder.select().all().from("test_ppl").where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 3})).perPartitionLimit(QueryBuilder.bindMarker()).limit(3).getQueryString(), new Object[]{2})).hasSize(3);
        Assertions.assertThat(this.session().execute(QueryBuilder.select().all().from("test_ppl").where(QueryBuilder.eq((String)"a", (Object)QueryBuilder.bindMarker())).perPartitionLimit(QueryBuilder.bindMarker()).getQueryString(), new Object[]{2, 3})).containsExactly(ResultSetAssert.row(2, 0, 0), ResultSetAssert.row(2, 1, 1), ResultSetAssert.row(2, 2, 2));
        Assertions.assertThat(this.session().execute(QueryBuilder.select().all().from("test_ppl").where(QueryBuilder.eq((String)"a", (Object)QueryBuilder.bindMarker())).orderBy(new Ordering[]{QueryBuilder.desc((String)"b")}).perPartitionLimit(QueryBuilder.bindMarker()).getQueryString(), new Object[]{2, 3})).containsExactly(ResultSetAssert.row(2, 4, 4), ResultSetAssert.row(2, 3, 3), ResultSetAssert.row(2, 2, 2));
        Assertions.assertThat(this.session().execute(QueryBuilder.select().all().from("test_ppl").where(QueryBuilder.eq((String)"a", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.gt((String)"b", (Object)QueryBuilder.bindMarker())).perPartitionLimit(QueryBuilder.bindMarker()).allowFiltering().getQueryString(), new Object[]{2, 0, 2})).containsExactly(ResultSetAssert.row(2, 1, 1), ResultSetAssert.row(2, 2, 2));
        Assertions.assertThat(this.session().execute(QueryBuilder.select().all().from("test_ppl").where(QueryBuilder.eq((String)"a", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.gt((String)"b", (Object)QueryBuilder.bindMarker())).orderBy(new Ordering[]{QueryBuilder.desc((String)"b")}).perPartitionLimit(QueryBuilder.bindMarker()).allowFiltering().getQueryString(), new Object[]{2, 2, 2})).containsExactly(ResultSetAssert.row(2, 4, 4), ResultSetAssert.row(2, 3, 3));
    }

    @CassandraVersion(value="3.10", description="Support for DEFAULT UNSET/NULL was added to C* 3.10 (CASSANDRA-11424)")
    @Test(groups={"short"})
    public void should_support_insert_json_with_default_unset_and_default_null() throws Throwable {
        String table = TestUtils.generateIdentifier("table");
        this.execute(String.format("CREATE TABLE %s (k int primary key, v1 int, v2 int)", table), String.format("INSERT INTO %s JSON '{\"k\": 0, \"v1\": 0, \"v2\": 0}'", table));
        this.session().execute((Statement)this.session().prepare((RegularStatement)QueryBuilder.insertInto((String)table).json((Object)QueryBuilder.bindMarker()).defaultUnset()).bind(new Object[]{"{\"k\": 0, \"v2\": 2}"}));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().from(table))).containsExactly(ResultSetAssert.row(0, 0, 2));
        this.session().execute((Statement)this.session().prepare((RegularStatement)QueryBuilder.insertInto((String)table).json((Object)QueryBuilder.bindMarker()).defaultNull()).bind(new Object[]{"{\"k\": 0, \"v2\": 2}"}));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().from(table))).containsExactly(ResultSetAssert.row(0, null, 2));
        this.session().execute((Statement)this.session().prepare((RegularStatement)QueryBuilder.insertInto((String)table).json((Object)QueryBuilder.bindMarker()).defaultNull()).bind(new Object[]{"{\"k\": 0}"}));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().from(table))).containsExactly(ResultSetAssert.row(0, null, null));
        this.session().execute((Statement)this.session().prepare((RegularStatement)QueryBuilder.insertInto((String)table).json((Object)QueryBuilder.bindMarker())).bind(new Object[]{"{\"k\": 1, \"v1\": 1, \"v2\": 1}"}));
        this.session().execute((Statement)this.session().prepare((RegularStatement)QueryBuilder.insertInto((String)table).json((Object)QueryBuilder.bindMarker()).defaultUnset()).bind(new Object[]{"{\"k\": 1, \"v1\": null}"}));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)1)))).containsExactly(ResultSetAssert.row(1, null, 1));
        this.session().execute((Statement)QueryBuilder.insertInto((String)table).json((Object)"{\"k\": 2, \"v1\": 2, \"v2\": 2}"));
        this.session().execute((Statement)QueryBuilder.insertInto((String)table).json((Object)"{\"k\": 2, \"v1\": null}").defaultUnset());
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)2)))).containsExactly(ResultSetAssert.row(2, null, 2));
        this.session().execute((Statement)QueryBuilder.insertInto((String)table).json((Object)"{\"k\": 2}").defaultNull());
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)2)))).containsExactly(ResultSetAssert.row(2, null, null));
    }

    @CassandraVersion(value="3.10", description="Support for GROUP BY was added to C* 3.10 (CASSANDRA-10707)")
    @Test(groups={"short"})
    public void should_support_group_by() throws Exception {
        String table = TestUtils.generateIdentifier("table");
        this.execute(String.format("CREATE TABLE %s (a int, b int, c int, d int, e int, primary key (a, b, c, d))", table));
        this.execute(String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 2, 1, 3, 6)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 2, 2, 6, 12)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 3, 2, 12, 24)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 4, 2, 12, 24)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 4, 2, 6, 12)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (2, 2, 3, 3, 6)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (2, 4, 3, 6, 12)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (3, 3, 2, 12, 24)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (4, 8, 2, 12, 24)", table));
        this.execute(String.format("DELETE FROM %s WHERE a = 1 AND b = 3 AND c = 2 AND d = 12", table), String.format("DELETE FROM %s WHERE a = 3", table));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.eq((String)"b", (Object)2)).groupBy(new Object[]{"a", "b"}).allowFiltering())).containsExactly(ResultSetAssert.row(1, 2, 6, 2L, 12), ResultSetAssert.row(2, 2, 6, 1L, 6));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).groupBy(new Object[]{"a", "b"}).limit(2))).containsExactly(ResultSetAssert.row(1, 2, 6, 2L, 12), ResultSetAssert.row(1, 4, 12, 2L, 24));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).groupBy(new Object[]{"a", "b"}).perPartitionLimit(1))).containsExactly(ResultSetAssert.row(1, 2, 6, 2L, 12), ResultSetAssert.row(2, 2, 6, 1L, 6), ResultSetAssert.row(4, 8, 24, 1L, 24));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).groupBy(new Object[]{"a", "b"}).perPartitionLimit(1).limit(2))).containsExactly(ResultSetAssert.row(1, 2, 6, 2L, 12), ResultSetAssert.row(2, 2, 6, 1L, 6));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", QueryBuilder.count((Object)"a")}).distinct().from(table).groupBy(new Object[]{"a"}))).containsExactly(ResultSetAssert.row(1, 1L), ResultSetAssert.row(2, 1L), ResultSetAssert.row(4, 1L));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", QueryBuilder.count((Object)"a")}).distinct().from(table).groupBy(new Object[]{"a"}).limit(2))).containsExactly(ResultSetAssert.row(1, 1L), ResultSetAssert.row(2, 1L));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "b", "c"}))).containsExactly(ResultSetAssert.row(1, 2, 6, 1L, 6), ResultSetAssert.row(1, 2, 12, 1L, 12), ResultSetAssert.row(1, 4, 12, 2L, 24));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", QueryBuilder.count((Object)"a")}).distinct().from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a"}))).containsExactly(ResultSetAssert.row(1, 1L));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "b", "c"}).limit(2))).containsExactly(ResultSetAssert.row(1, 2, 6, 1L, 6), ResultSetAssert.row(1, 2, 12, 1L, 12));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "b", "c"}).perPartitionLimit(2))).containsExactly(ResultSetAssert.row(1, 2, 6, 1L, 6), ResultSetAssert.row(1, 2, 12, 1L, 12));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "b", "c"}).orderBy(new Ordering[]{QueryBuilder.desc((String)"b"), QueryBuilder.desc((String)"c")}))).containsExactly(ResultSetAssert.row(1, 4, 24, 2L, 24), ResultSetAssert.row(1, 2, 12, 1L, 12), ResultSetAssert.row(1, 2, 6, 1L, 6));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "b", "c"}).orderBy(new Ordering[]{QueryBuilder.desc((String)"b"), QueryBuilder.desc((String)"c")}).perPartitionLimit(1))).containsExactly(ResultSetAssert.row(1, 4, 24, 2L, 24));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "b", "c"}).orderBy(new Ordering[]{QueryBuilder.desc((String)"b"), QueryBuilder.desc((String)"c")}).limit(2))).containsExactly(ResultSetAssert.row(1, 4, 24, 2L, 24), ResultSetAssert.row(1, 2, 12, 1L, 12));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 4})).and(QueryBuilder.eq((String)"b", (Object)2)).groupBy(new Object[]{"a", "b", "c"}))).containsExactly(ResultSetAssert.row(1, 2, 6, 1L, 6), ResultSetAssert.row(1, 2, 12, 1L, 12), ResultSetAssert.row(2, 2, 6, 1L, 6));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", QueryBuilder.count((Object)"a")}).distinct().from(table).where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 4})).groupBy(new Object[]{"a"}))).containsExactly(ResultSetAssert.row(1, 1L), ResultSetAssert.row(2, 1L), ResultSetAssert.row(4, 1L));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", QueryBuilder.count((Object)"a")}).distinct().from(table).where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 4})).groupBy(new Object[]{"a"}).limit(2))).containsExactly(ResultSetAssert.row(1, 1L), ResultSetAssert.row(2, 1L));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 4})).groupBy(new Object[]{"a", "b", "c"}).perPartitionLimit(1))).containsExactly(ResultSetAssert.row(1, 2, 6, 1L, 6), ResultSetAssert.row(2, 2, 6, 1L, 6), ResultSetAssert.row(4, 8, 24, 1L, 24));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", "e", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 4})).groupBy(new Object[]{"a", "b", "c"}).perPartitionLimit(2))).containsExactly(ResultSetAssert.row(1, 2, 6, 1L, 6), ResultSetAssert.row(1, 2, 12, 1L, 12), ResultSetAssert.row(2, 2, 6, 1L, 6), ResultSetAssert.row(2, 4, 12, 1L, 12), ResultSetAssert.row(4, 8, 24, 1L, 24));
        Assertions.assertThat(this.session().execute(QueryBuilder.select((Object[])new Object[]{"a", "b", "c", QueryBuilder.count((Object)"b"), QueryBuilder.max((Object)"e")}).from(table).where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 4})).groupBy(new Object[]{"a", "b"}).orderBy(new Ordering[]{QueryBuilder.desc((String)"b"), QueryBuilder.desc((String)"c")}).setFetchSize(Integer.MAX_VALUE))).containsExactly(ResultSetAssert.row(4, 8, 2, 1L, 24), ResultSetAssert.row(2, 4, 3, 1L, 12), ResultSetAssert.row(1, 4, 2, 2L, 24), ResultSetAssert.row(2, 2, 3, 1L, 6), ResultSetAssert.row(1, 2, 2, 2L, 12));
        Assertions.assertThat(this.session().execute(QueryBuilder.select((String[])new String[]{"a", "b", "c", "d"}).from(table).where(QueryBuilder.in((String)"a", (Object[])new Object[]{1, 2, 4})).groupBy(new Object[]{"a", "b"}).orderBy(new Ordering[]{QueryBuilder.desc((String)"b"), QueryBuilder.desc((String)"c")}).limit(3).setFetchSize(Integer.MAX_VALUE))).containsExactly(ResultSetAssert.row(4, 8, 2, 12), ResultSetAssert.row(2, 4, 3, 6), ResultSetAssert.row(1, 4, 2, 12));
        try {
            this.session().execute((Statement)QueryBuilder.select().column("a").column("b").as("clustering1").max((Object)"c").from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "clustering1"}));
            Assert.fail((String)"Expecting IQE");
        }
        catch (InvalidQueryException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Undefined column name clustering1");
        }
        try {
            this.session().execute((Statement)QueryBuilder.select().column("a").column("b").max((Object)"c").from(table).where(QueryBuilder.eq((String)"a", (Object)1)).groupBy(new Object[]{"a", "b", "z"}));
            Assert.fail((String)"Expecting IQE");
        }
        catch (InvalidQueryException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Undefined column name z");
        }
        table = TestUtils.generateIdentifier("table");
        this.execute(String.format("CREATE TABLE %s (a int, b int, c int, d int, e int, primary key ((a, b), c, d))", table));
        this.execute(String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 1, 1, 3, 6)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 1, 2, 6, 12)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 1, 3, 12, 24)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 2, 1, 12, 24)", table), String.format("INSERT INTO %s (a, b, c, d, e) VALUES (1, 2, 2, 6, 12)", table));
        try {
            this.session().execute((Statement)QueryBuilder.select().column("a").column("b").max((Object)"d").from(table).groupBy(new Object[]{"a"}));
            Assert.fail((String)"Expecting IQE");
        }
        catch (InvalidQueryException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Group by is not supported on only a part of the partition key");
        }
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", QueryBuilder.max((Object)"d")}).from(table).groupBy(new Object[]{"a", "b"}))).containsExactly(ResultSetAssert.row(1, 2, 12), ResultSetAssert.row(1, 1, 12));
        Assertions.assertThat(this.session().execute((Statement)QueryBuilder.select((Object[])new Object[]{"a", "b", QueryBuilder.max((Object)"d")}).from(table).where(QueryBuilder.eq((String)"a", (Object)1)).and(QueryBuilder.eq((String)"b", (Object)1)).groupBy(new Object[]{"b"}))).containsExactly(ResultSetAssert.row(1, 1, 12));
    }
}

