/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.utils.CassandraVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@CCMConfig(clusterProvider="createClusterBuilderNoDebouncing")
public class QueryBuilderITest
extends CCMTestsSupport {
    private static final String TABLE_TEXT = "test_text";
    private static final String TABLE_INT = "test_int";

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, a int, b int)", TABLE_TEXT), String.format("CREATE TABLE %s (k int PRIMARY KEY, a int, b int)", TABLE_INT));
    }

    @Test(groups={"short"})
    public void remainingDeleteTests() throws Exception {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable(TABLE_TEXT);
        Assert.assertNotNull((Object)table);
        String expected = String.format("DELETE k FROM %s.test_text;", this.keyspace);
        Delete query = QueryBuilder.delete((String[])new String[]{"k"}).from(table);
        Assert.assertEquals((String)query.toString(), (String)expected);
        try {
            this.session().execute((Statement)query);
            Assert.fail();
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
    }

    @Test(groups={"short"})
    public void selectInjectionTests() throws Exception {
        this.session().execute("CREATE TABLE foo ( k ascii PRIMARY KEY , i int, s ascii )");
        String query = "SELECT * FROM foo WHERE k=?;";
        Select.Where select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)QueryBuilder.bindMarker()));
        PreparedStatement ps = this.session().prepare(select.toString());
        BoundStatement bs = ps.bind();
        Assert.assertEquals((String)select.toString(), (String)query);
        this.session().execute((Statement)bs.setString("k", "4 AND c=5"));
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.7", description="DELETE..IF EXISTS only supported in 2.0.7+ (CASSANDRA-5708)")
    public void conditionalDeletesTest() throws Exception {
        this.session().execute(String.format("INSERT INTO %s.test_int (k, a, b) VALUES (1, 1, 1)", this.keyspace));
        Delete delete = QueryBuilder.delete().from(this.keyspace, TABLE_INT).where(QueryBuilder.eq((String)"k", (Object)2)).ifExists();
        Row row = this.session().execute((Statement)delete).one();
        Assert.assertFalse((boolean)row.getBool("[applied]"));
        delete = QueryBuilder.delete().from(this.keyspace, TABLE_INT).where(QueryBuilder.eq((String)"k", (Object)1)).ifExists();
        row = this.session().execute((Statement)delete).one();
        Assert.assertTrue((boolean)row.getBool("[applied]"));
        this.session().execute(String.format("INSERT INTO %s.test_int (k, a, b) VALUES (1, 1, 1)", this.keyspace));
        delete = QueryBuilder.delete().from(this.keyspace, TABLE_INT).where(QueryBuilder.eq((String)"k", (Object)1)).onlyIf(QueryBuilder.eq((String)"a", (Object)1)).and(QueryBuilder.eq((String)"b", (Object)2));
        row = this.session().execute((Statement)delete).one();
        Assert.assertFalse((boolean)row.getBool("[applied]"));
        delete = QueryBuilder.delete().from(this.keyspace, TABLE_INT).where(QueryBuilder.eq((String)"k", (Object)1)).onlyIf(QueryBuilder.eq((String)"a", (Object)1)).and(QueryBuilder.eq((String)"b", (Object)1));
        row = this.session().execute((Statement)delete).one();
        Assert.assertTrue((boolean)row.getBool("[applied]"));
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.13", description="Allow IF EXISTS for UPDATE statements (CASSANDRA-8610)")
    public void conditionalUpdatesTest() throws Exception {
        this.session().execute(String.format("INSERT INTO %s.test_int (k, a, b) VALUES (1, 1, 1)", this.keyspace));
        Update.IfExists update = QueryBuilder.update((String)TABLE_INT).with(QueryBuilder.set((String)"a", (Object)2)).and(QueryBuilder.set((String)"b", (Object)2)).where(QueryBuilder.eq((String)"k", (Object)2)).ifExists();
        Row row = this.session().execute((Statement)update).one();
        Assert.assertFalse((boolean)row.getBool("[applied]"));
        update = QueryBuilder.update((String)TABLE_INT).with(QueryBuilder.set((String)"a", (Object)2)).and(QueryBuilder.set((String)"b", (Object)2)).where(QueryBuilder.eq((String)"k", (Object)1)).ifExists();
        row = this.session().execute((Statement)update).one();
        Assert.assertTrue((boolean)row.getBool("[applied]"));
        update = QueryBuilder.update((String)TABLE_INT).with(QueryBuilder.set((String)"a", (Object)2)).and(QueryBuilder.set((String)"b", (Object)2)).where(QueryBuilder.eq((String)"k", (Object)2)).onlyIf(QueryBuilder.eq((String)"a", (Object)1)).and(QueryBuilder.eq((String)"b", (Object)2));
        row = this.session().execute((Statement)update).one();
        Assert.assertFalse((boolean)row.getBool("[applied]"));
        update = QueryBuilder.update((String)TABLE_INT).with(QueryBuilder.set((String)"a", (Object)3)).and(QueryBuilder.set((String)"b", (Object)3)).where(QueryBuilder.eq((String)"k", (Object)1)).onlyIf(QueryBuilder.eq((String)"a", (Object)2)).and(QueryBuilder.eq((String)"b", (Object)2));
        row = this.session().execute((Statement)update).one();
        Assert.assertTrue((boolean)row.getBool("[applied]"));
        update = QueryBuilder.update((String)TABLE_INT).with(QueryBuilder.set((String)"a", (Object)4)).and(QueryBuilder.set((String)"b", (Object)4)).onlyIf(QueryBuilder.eq((String)"a", (Object)2)).and(QueryBuilder.eq((String)"b", (Object)2)).where(QueryBuilder.eq((String)"k", (Object)1));
        row = this.session().execute((Statement)update).one();
        Assert.assertFalse((boolean)row.getBool("[applied]"));
        update = QueryBuilder.update((String)TABLE_INT).with(QueryBuilder.set((String)"a", (Object)4)).and(QueryBuilder.set((String)"b", (Object)4)).onlyIf(QueryBuilder.eq((String)"a", (Object)3)).and(QueryBuilder.eq((String)"b", (Object)3)).where(QueryBuilder.eq((String)"k", (Object)1));
        row = this.session().execute((Statement)update).one();
        Assert.assertTrue((boolean)row.getBool("[applied]"));
    }
}

