/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.3")
public class QueryBuilderTupleExecutionTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_handle_tuple() throws Exception {
        String query = "INSERT INTO foo (k,x) VALUES (0,(1));";
        TupleType tupleType = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint()});
        Insert insert = QueryBuilder.insertInto((String)"foo").value("k", (Object)0).value("x", (Object)tupleType.newValue(new Object[]{1}));
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"short"})
    public void should_handle_collections_of_tuples() {
        String query = "UPDATE foo SET l=[(1,2)] WHERE k=1;";
        TupleType tupleType = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint(), DataType.cint()});
        ImmutableList list = ImmutableList.of((Object)tupleType.newValue(new Object[]{1, 2}));
        Update.Where statement = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"l", (Object)list)).where(QueryBuilder.eq((String)"k", (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
    }
}

