/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class CompactionOptionsTest {
    @Test(groups={"unit"})
    public void should_create_sized_tiered_compaction_options() throws Exception {
        String built = ((TableOptions.CompactionOptions.SizeTieredCompactionStrategyOptions)((TableOptions.CompactionOptions.SizeTieredCompactionStrategyOptions)((TableOptions.CompactionOptions.SizeTieredCompactionStrategyOptions)((TableOptions.CompactionOptions.SizeTieredCompactionStrategyOptions)SchemaBuilder.sizedTieredStategy().bucketLow(Double.valueOf(0.5)).bucketHigh(Double.valueOf(1.2)).coldReadsRatioToOmit(Double.valueOf(0.89)).enabled(Boolean.valueOf(true))).minThreshold(Integer.valueOf(2)).maxThreshold(Integer.valueOf(4)).minSSTableSizeInBytes(Long.valueOf(5000000L)).tombstoneCompactionIntervalInDay(Integer.valueOf(3))).tombstoneThreshold(Double.valueOf(0.7))).uncheckedTombstoneCompaction(Boolean.valueOf(true))).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'class' : 'SizeTieredCompactionStrategy', 'enabled' : true, 'tombstone_compaction_interval' : 3, 'tombstone_threshold' : 0.7, 'unchecked_tombstone_compaction' : true, 'bucket_high' : 1.2, 'bucket_low' : 0.5, 'cold_reads_to_omit' : 0.89, 'min_threshold' : 2, 'max_threshold' : 4, 'min_sstable_size' : 5000000}");
    }

    @Test(groups={"unit"})
    public void should_create_leveled_compaction_option() throws Exception {
        String built = ((TableOptions.CompactionOptions.LeveledCompactionStrategyOptions)((TableOptions.CompactionOptions.LeveledCompactionStrategyOptions)((TableOptions.CompactionOptions.LeveledCompactionStrategyOptions)((TableOptions.CompactionOptions.LeveledCompactionStrategyOptions)SchemaBuilder.leveledStrategy().enabled(Boolean.valueOf(true))).ssTableSizeInMB(Integer.valueOf(160)).tombstoneCompactionIntervalInDay(Integer.valueOf(3))).tombstoneThreshold(Double.valueOf(0.7))).uncheckedTombstoneCompaction(Boolean.valueOf(true))).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'class' : 'LeveledCompactionStrategy', 'enabled' : true, 'tombstone_compaction_interval' : 3, 'tombstone_threshold' : 0.7, 'unchecked_tombstone_compaction' : true, 'sstable_size_in_mb' : 160}");
    }

    @Test(groups={"unit"})
    public void should_create_date_tiered_compaction_option() throws Exception {
        String built = ((TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions)((TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions)((TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions)((TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions)SchemaBuilder.dateTieredStrategy().baseTimeSeconds(Integer.valueOf(7200)).enabled(Boolean.valueOf(true))).maxSSTableAgeDays(Integer.valueOf(400)).minThreshold(Integer.valueOf(2)).maxThreshold(Integer.valueOf(4)).timestampResolution(TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions.TimeStampResolution.MICROSECONDS).tombstoneCompactionIntervalInDay(Integer.valueOf(3))).tombstoneThreshold(Double.valueOf(0.7))).uncheckedTombstoneCompaction(Boolean.valueOf(true))).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'class' : 'DateTieredCompactionStrategy', 'enabled' : true, 'tombstone_compaction_interval' : 3, 'tombstone_threshold' : 0.7, 'unchecked_tombstone_compaction' : true, 'base_time_seconds' : 7200, 'max_sstable_age_days' : 400, 'min_threshold' : 2, 'max_threshold' : 4, 'timestamp_resolution' : 'MICROSECONDS'}");
    }

    @Test(groups={"unit"})
    public void should_create_time_window_compaction_option() throws Exception {
        String built = ((TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions)((TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions)((TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions)((TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions)SchemaBuilder.timeWindowCompactionStrategy().bucketLow(Double.valueOf(0.5)).bucketHigh(Double.valueOf(1.2)).compactionWindowUnit(TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions.CompactionWindowUnit.HOURS).compactionWindowSize(Integer.valueOf(5)).enabled(Boolean.valueOf(true))).minThreshold(Integer.valueOf(2)).maxThreshold(Integer.valueOf(4)).minSSTableSizeInBytes(Long.valueOf(5000000L)).timestampResolution(TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions.TimeStampResolution.MICROSECONDS).tombstoneCompactionIntervalInDay(Integer.valueOf(3))).tombstoneThreshold(Double.valueOf(0.7))).uncheckedTombstoneCompaction(Boolean.valueOf(true))).unsafeAggressiveSSTableExpiration(Boolean.valueOf(true)).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'class' : 'TimeWindowCompactionStrategy', 'enabled' : true, 'tombstone_compaction_interval' : 3, 'tombstone_threshold' : 0.7, 'unchecked_tombstone_compaction' : true, 'bucket_high' : 1.2, 'bucket_low' : 0.5, 'compaction_window_unit' : 'HOURS', 'compaction_window_size' : 5, 'min_threshold' : 2, 'max_threshold' : 4, 'min_sstable_size' : 5000000, 'timestamp_resolution' : 'MICROSECONDS', 'unsafe_aggressive_sstable_expiration' : 'true'}");
    }

    @Test(groups={"unit"})
    public void should_handle_freeform_options() {
        String built = ((TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions)((TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions)SchemaBuilder.dateTieredStrategy().freeformOption("foo", (Object)"bar")).freeformOption("baz", (Object)1)).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'class' : 'DateTieredCompactionStrategy', 'foo' : 'bar', 'baz' : 1}");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_throw_exception_if_cold_read_ratio_out_of_range() throws Exception {
        SchemaBuilder.sizedTieredStategy().bucketLow(Double.valueOf(0.5)).bucketHigh(Double.valueOf(1.2)).coldReadsRatioToOmit(Double.valueOf(1.89)).build();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_throw_exception_if_cold_read_ratio_negative() throws Exception {
        SchemaBuilder.sizedTieredStategy().bucketLow(Double.valueOf(0.5)).bucketHigh(Double.valueOf(1.2)).coldReadsRatioToOmit(Double.valueOf(-1.0)).build();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_throw_exception_if_tombstone_threshold_out_of_range() throws Exception {
        ((TableOptions.CompactionOptions.SizeTieredCompactionStrategyOptions)SchemaBuilder.sizedTieredStategy().bucketLow(Double.valueOf(0.5)).bucketHigh(Double.valueOf(1.2)).tombstoneThreshold(Double.valueOf(1.89))).build();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_throw_exception_if_tombstone_threshold_negative() throws Exception {
        SchemaBuilder.sizedTieredStategy().bucketLow(Double.valueOf(0.5)).bucketHigh(Double.valueOf(1.2)).coldReadsRatioToOmit(Double.valueOf(-1.0)).build();
    }
}

