/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.AbstractCreateStatement;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class CreateTypeTest {
    @Test(groups={"unit"})
    public void should_create_UDT() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addColumn("col2", DataType.bigint());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tcol2 bigint)");
    }

    @Test(groups={"unit"})
    public void should_create_UDT_if_not_exists() throws Exception {
        AbstractCreateStatement statement = ((CreateType)((CreateType)SchemaBuilder.createType((String)"myType").ifNotExists()).addColumn("col1", DataType.text())).addColumn("col2", DataType.bigint());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE IF NOT EXISTS myType(\n\t\tcol1 text,\n\t\tcol2 bigint)");
    }

    @Test(groups={"unit"})
    public void should_create_simple_UDT_column() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addUDTColumn("my_udt", SchemaBuilder.frozen((String)"address"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tmy_udt frozen<address>)");
    }

    @Test(groups={"unit"})
    public void should_create_list_UDT_column() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addUDTListColumn("my_udt", SchemaBuilder.frozen((String)"address"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tmy_udt list<frozen<address>>)");
    }

    @Test(groups={"unit"})
    public void should_create_set_UDT_column() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addUDTSetColumn("my_udt", SchemaBuilder.frozen((String)"address"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tmy_udt set<frozen<address>>)");
    }

    @Test(groups={"unit"})
    public void should_create_key_UDT_map_column() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addUDTMapColumn("my_udt", SchemaBuilder.frozen((String)"address"), DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tmy_udt map<frozen<address>, text>)");
    }

    @Test(groups={"unit"})
    public void should_create_value_UDT_map_column() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addUDTMapColumn("my_udt", DataType.cint(), SchemaBuilder.frozen((String)"address"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tmy_udt map<int, frozen<address>>)");
    }

    @Test(groups={"unit"})
    public void should_create_key_value_UDT_map_column() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addUDTMapColumn("my_udt", SchemaBuilder.frozen((String)"coords"), SchemaBuilder.frozen((String)"address"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tmy_udt map<frozen<coords>, frozen<address>>)");
    }

    @Test(groups={"unit"})
    public void should_create_column_with_manual_type() throws Exception {
        AbstractCreateStatement statement = ((CreateType)SchemaBuilder.createType((String)"ks", (String)"myType").addColumn("col1", DataType.text())).addUDTColumn("my_udt", SchemaBuilder.udtLiteral((String)"frozen<address>"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TYPE ks.myType(\n\t\tcol1 text,\n\t\tmy_udt frozen<address>)");
    }
}

