/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.utils;

import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.utils.UUIDs;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class UUIDsPIDPropertyInvalidTest {
    private static final Logger logger = Logger.getLogger(UUIDs.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"isolated"})
    public void should_fallback_on_native_call_if_system_property_invalid() {
        MemoryAppender appender = new MemoryAppender();
        Level originalLevel = logger.getLevel();
        try {
            logger.setLevel(Level.INFO);
            logger.addAppender((Appender)appender);
            String pid = "NOT_A_PID";
            System.setProperty("com.datastax.driver.PID", pid);
            UUIDs.timeBased();
            Assertions.assertThat((String)appender.get()).containsOnlyOnce((CharSequence)String.format("Incorrect integer specified for PID in System property %s: %s", "com.datastax.driver.PID", pid)).containsOnlyOnce((CharSequence)"PID obtained through native call to getpid()");
        }
        finally {
            logger.removeAppender((Appender)appender);
            logger.setLevel(originalLevel);
        }
    }
}

