/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.geometry.codecs.LineStringCodec;
import com.datastax.driver.dse.geometry.codecs.PointCodec;
import com.datastax.driver.dse.geometry.codecs.PolygonCodec;
import com.datastax.driver.dse.search.DateRangeCodec;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class CodecRegistrationTest {
    @Test(groups={"unit"})
    public void should_not_register_geospatial_codecs_when_explicitly_disabled() throws Exception {
        DseCluster cluster = DseCluster.builder().addContactPoint("localhost").withCodecRegistry(new CodecRegistry()).withoutGeospatialCodecs().build();
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        try {
            codecRegistry.codecFor(PointCodec.INSTANCE.getCqlType(), PointCodec.INSTANCE.getJavaType());
            Assertions.fail((String)"Expecting CodecNotFoundException");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            codecRegistry.codecFor(LineStringCodec.INSTANCE.getCqlType(), LineStringCodec.INSTANCE.getJavaType());
            Assertions.fail((String)"Expecting CodecNotFoundException");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            codecRegistry.codecFor(PolygonCodec.INSTANCE.getCqlType(), PolygonCodec.INSTANCE.getJavaType());
            Assertions.fail((String)"Expecting CodecNotFoundException");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
    }

    @Test(groups={"unit"})
    public void should_not_register_search_codecs_when_explicitly_disabled() throws Exception {
        DseCluster cluster = DseCluster.builder().addContactPoint("localhost").withCodecRegistry(new CodecRegistry()).withoutSearchCodecs().build();
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        try {
            codecRegistry.codecFor(DateRangeCodec.INSTANCE.getCqlType(), DateRangeCodec.INSTANCE.getJavaType());
            Assertions.fail((String)"Expecting CodecNotFoundException");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"unit"})
    public void should_not_log_warning_about_previously_registered_codec() {
        Logger codecRegistryLogger = Logger.getLogger(CodecRegistry.class);
        MemoryAppender logs = new MemoryAppender();
        Level originalLevel = codecRegistryLogger.getLevel();
        codecRegistryLogger.setLevel(Level.WARN);
        codecRegistryLogger.addAppender((Appender)logs);
        try {
            for (int i = 0; i < 10; ++i) {
                DseCluster.builder().addContactPoint("localhost").build();
            }
        }
        finally {
            codecRegistryLogger.setLevel(originalLevel);
            codecRegistryLogger.removeAppender((Appender)logs);
        }
        Assertions.assertThat((String)logs.get()).doesNotContain((CharSequence)"because it collides with previously registered codec");
    }
}

