/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.auth.DseGSSAPIAuthProvider;
import com.datastax.driver.dse.auth.EmbeddedADS;
import com.datastax.driver.dse.auth.KerberosUtils;
import java.io.File;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(createCluster={false}, dirtiesContext={true}, ccmProvider="configureCCM")
@DseVersion(value="4.8")
public class DseGSSAPIAuthProviderTest
extends CCMDseTestsSupport {
    private static final String realm = "DATASTAX.COM";
    private static final String address = TestUtils.IP_PREFIX + "1";
    private final EmbeddedADS adsServer = EmbeddedADS.builder().withKerberos().withRealm("DATASTAX.COM").withAddress(address).build();
    private final String servicePrincipal = "dse/" + this.adsServer.getHostname() + "@" + "DATASTAX.COM";
    private final String alternateServicePrincipal = "alternate/" + this.adsServer.getHostname() + "@" + "DATASTAX.COM";
    private final String userPrincipal = "cassandra@DATASTAX.COM";
    private final String unknownPrincipal = "unknown@DATASTAX.COM";
    private File userKeytab;
    private File unknownKeytab;
    private File dseKeytab;
    private File alternateKeytab;

    @BeforeClass(groups={"long"})
    public void setupKDC() throws Exception {
        if (this.adsServer.isStarted()) {
            return;
        }
        this.adsServer.start();
        this.dseKeytab = this.adsServer.addUserAndCreateKeytab("dse", "dse", this.servicePrincipal);
        this.alternateKeytab = this.adsServer.addUserAndCreateKeytab("alternate", "alternate", this.alternateServicePrincipal);
        this.userKeytab = this.adsServer.addUserAndCreateKeytab("cassandra", "cassandra", "cassandra@DATASTAX.COM");
        this.unknownKeytab = this.adsServer.createKeytab("unknown", "unknown", "unknown@DATASTAX.COM");
    }

    @AfterClass(groups={"long"}, alwaysRun=true)
    public void teardownKDC() throws Exception {
        this.adsServer.stop();
    }

    CCMBridge.Builder baseAuthenticationConfiguration() {
        boolean is5OrGreater = CCMBridge.getGlobalDSEVersion().getMajor() >= 5;
        String authenticator = is5OrGreater ? "com.datastax.bdp.cassandra.auth.DseAuthenticator" : "com.datastax.bdp.cassandra.auth.KerberosAuthenticator";
        CCMBridge.Builder builder = CCMBridge.builder().withCassandraConfiguration("authenticator", authenticator).withDSEConfiguration("kerberos_options.qop", "auth").withJvmArgs("-Dcassandra.superuser_setup_delay_ms=0", "-Djava.security.krb5.conf=" + this.adsServer.getKrb5Conf().getAbsolutePath());
        if (is5OrGreater) {
            builder = builder.withDSEConfiguration("authentication_options.enabled", "true").withDSEConfiguration("authentication_options.default_scheme", "kerberos");
        }
        return builder;
    }

    public CCMBridge.Builder configureCCM() {
        return this.baseAuthenticationConfiguration().withDSEConfiguration("kerberos_options.keytab", this.dseKeytab.getAbsolutePath()).withDSEConfiguration("kerberos_options.service_principal", "dse/_HOST@DATASTAX.COM");
    }

    public CCMBridge.Builder configureAlternateCCM() {
        return this.baseAuthenticationConfiguration().withDSEConfiguration("kerberos_options.keytab", this.alternateKeytab.getAbsolutePath()).withDSEConfiguration("kerberos_options.service_principal", "alternate/_HOST@DATASTAX.COM");
    }

    @Test(groups={"long"})
    public void should_authenticate_using_subject() throws Exception {
        String protocol = "dse";
        Configuration configuration = KerberosUtils.keytabClient(this.userKeytab, "cassandra@DATASTAX.COM");
        LoginContext login = new LoginContext("DseClient", null, null, configuration);
        login.login();
        DseGSSAPIAuthProvider auth = DseGSSAPIAuthProvider.builder().withSubject(login.getSubject()).build();
        this.connectAndQuery((AuthProvider)auth);
    }

    @Test(groups={"long"})
    public void should_authenticate_using_kerberos_with_keytab() throws Exception {
        this.connectAndQuery(KerberosUtils.keytabClient(this.userKeytab, "cassandra@DATASTAX.COM"));
    }

    @CCMConfig(ccmProvider="configureAlternateCCM")
    @Test(groups={"long"})
    public void should_authenticate_using_kerberos_with_keytab_and_alternate_service_principal_using_system_property() throws Exception {
        try {
            System.setProperty("dse.sasl.protocol", "alternate");
            this.connectAndQuery(KerberosUtils.keytabClient(this.userKeytab, "cassandra@DATASTAX.COM"));
        }
        finally {
            System.clearProperty("dse.sasl.protocol");
        }
    }

    @CCMConfig(ccmProvider="configureAlternateCCM")
    @Test(groups={"long"})
    public void should_authenticate_using_kerberos_with_keytab_and_alternate_service_principal() throws Exception {
        DseGSSAPIAuthProvider auth = DseGSSAPIAuthProvider.builder().withLoginConfiguration(KerberosUtils.keytabClient(this.userKeytab, "cassandra@DATASTAX.COM")).withSaslProtocol("alternate").build();
        this.connectAndQuery((AuthProvider)auth);
    }

    @Test(groups={"long"})
    public void should_authenticate_using_kerberos_with_ticket() throws Exception {
        boolean isUnix;
        String osName = System.getProperty("os.name", "").toLowerCase();
        boolean bl = isUnix = osName.contains("mac") || osName.contains("darwin") || osName.contains("nux");
        if (!isUnix) {
            throw new SkipException("This test requires a unix-based platform with kinit & kdestroy installed.");
        }
        KerberosUtils.acquireTicket("cassandra@DATASTAX.COM", this.userKeytab, this.adsServer);
        try {
            this.connectAndQuery(KerberosUtils.ticketClient("cassandra@DATASTAX.COM"));
        }
        finally {
            KerberosUtils.destroyTicket(this.adsServer);
        }
    }

    @Test(groups={"long"}, expectedExceptions={NoHostAvailableException.class})
    public void should_not_authenticate_if_no_ticket_in_cache() throws Exception {
        this.connectAndQuery(KerberosUtils.ticketClient("cassandra@DATASTAX.COM"));
    }

    @Test(groups={"long"}, expectedExceptions={NoHostAvailableException.class})
    public void should_not_authenticate_if_keytab_does_not_map_to_valid_principal() throws Exception {
        this.connectAndQuery(KerberosUtils.keytabClient(this.unknownKeytab, "unknown@DATASTAX.COM"));
    }

    private void connectAndQuery(Configuration configuration) {
        this.connectAndQuery((AuthProvider)DseGSSAPIAuthProvider.builder().withLoginConfiguration(configuration).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndQuery(AuthProvider authProvider) {
        DseCluster cluster = this.createClusterBuilder().addContactPointsWithPorts(this.getContactPointsWithPorts()).withAuthProvider(authProvider).build();
        try {
            DseSession session = cluster.connect();
            Row row = session.execute("select * from system.local").one();
            Assertions.assertThat((Object)row).isNotNull();
        }
        finally {
            cluster.close();
        }
    }
}

