/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.dse.geometry.Distance;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.geometry.Utils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.testng.annotations.Test;

public class DistanceTest {
    private Point point = new Point(1.1, 2.2);
    private Distance distance = new Distance(this.point, 7.0);
    private final String wkt = "DISTANCE((1.1 2.2) 7.0)";

    @Test(groups={"unit"})
    public void should_parse_valid_well_known_text() {
        Distance fromWkt = Distance.fromWellKnownText((String)"DISTANCE((1.1 2.2) 7.0)");
        Assertions.assertThat((double)fromWkt.getRadius()).isEqualTo(7.0);
        Assertions.assertThat((Object)fromWkt.getCenter()).isEqualTo((Object)this.point);
        Assertions.assertThat((Object)Distance.fromWellKnownText((String)"DISTANCE((1.1 2.2) 7.0)")).isEqualTo((Object)this.distance);
        Assertions.assertThat((Object)Distance.fromWellKnownText((String)"DISTANCE ((1.1 2.2) 7.0)")).isEqualTo((Object)this.distance);
        Assertions.assertThat((Object)Distance.fromWellKnownText((String)"distance((1.1 2.2) 7.0)")).isEqualTo((Object)this.distance);
    }

    @Test(groups={"unit"})
    public void should_fail_to_parse_invalid_well_known_text() {
        this.assertInvalidWkt("dist((1.1 2.2) 3.3)");
    }

    @Test(groups={"unit"})
    public void should_convert_to_well_known_text() {
        Assertions.assertThat((String)this.distance.toString()).isEqualTo((Object)"DISTANCE((1.1 2.2) 7.0)");
    }

    @Test(groups={"unit"})
    public void should_contain_point() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)new Point(2.0, 3.0))).isTrue();
    }

    @Test(groups={"unit"})
    public void should_not_contain_point() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)new Point(2.0, 9.3))).isFalse();
    }

    @Test(groups={"unit"})
    public void should_contain_linestring() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)new LineString(new Point(2.0, 3.0), new Point(3.1, 6.2), new Point[]{new Point(-1.0, -2.0)}))).isTrue();
    }

    @Test(groups={"unit"})
    public void should_not_contain_linestring() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)new LineString(new Point(2.0, 3.0), new Point(3.1, 9.2), new Point[]{new Point(-1.0, -2.0)}))).isFalse();
    }

    @Test(groups={"unit"})
    public void should_contain_polygon() {
        Polygon polygon = new Polygon(Utils.p(3.0, 1.0), Utils.p(1.0, 2.0), Utils.p(2.0, 4.0), new Point[]{Utils.p(4.0, 4.0)});
        Assertions.assertThat((boolean)this.distance.contains((Geometry)polygon)).isTrue();
    }

    @Test(groups={"unit"})
    public void should_not_contain_polygon() {
        Polygon polygon = new Polygon(Utils.p(3.0, 1.0), Utils.p(1.0, 2.0), Utils.p(2.0, 4.0), new Point[]{Utils.p(10.0, 4.0)});
        Assertions.assertThat((boolean)this.distance.contains((Geometry)polygon)).isFalse();
    }

    @Test(groups={"unit"}, expectedExceptions={UnsupportedOperationException.class})
    public void getOgcGeometry_throws_UOE() {
        this.distance.getOgcGeometry();
    }

    @Test(groups={"unit"}, expectedExceptions={UnsupportedOperationException.class})
    public void asWellKnownBinary_throws_UOE() {
        this.distance.asWellKnownBinary();
    }

    @Test(groups={"unit"}, expectedExceptions={UnsupportedOperationException.class})
    public void asGeoJson_throws_UOE() {
        this.distance.asGeoJson();
    }

    private void assertInvalidWkt(String s) {
        try {
            Distance.fromWellKnownText((String)s);
            Fail.fail((String)"Should have thrown InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }
}

