/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.GraphOLAPQueryTest;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DseVersion(value="5.0.0")
@CCMConfig(dirtiesContext={true}, numberOfNodes={3})
public class CCMGraphTestsOLAPSupport
extends CCMGraphTestsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphOLAPQueryTest.class);

    @Override
    protected void initTestContext(Object testInstance, Method testMethod) throws Exception {
        super.initTestContext(testInstance, testMethod);
        InetSocketAddress masterHttpPort = new InetSocketAddress(TestUtils.ipOfNode(1), 7080);
        LOGGER.debug("Waiting for spark master HTTP interface: {}.", (Object)masterHttpPort);
        TestUtils.waitUntilPortIsUp(masterHttpPort);
        for (int i = 1; i <= 3; ++i) {
            InetSocketAddress binaryIntf = new InetSocketAddress(TestUtils.ipOfNode(i), this.ccm().getBinaryPort());
            LOGGER.debug("Waiting for binary interface: {}.", (Object)binaryIntf);
            TestUtils.waitUntilPortIsUp(binaryIntf);
        }
        this.waitForWorkers(3);
    }

    private void waitForWorkers(final int workerCount) {
        LOGGER.debug("Waiting for {} workers to be alive.", (Object)workerCount);
        ConditionChecker.check().that(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                URL masterHome = new URL(String.format("http://%s:7080", TestUtils.ipOfNode(1)));
                HttpURLConnection connection = (HttpURLConnection)masterHome.openConnection();
                connection.setRequestMethod("GET");
                BufferedReader rd = null;
                try {
                    String line;
                    rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    Pattern aliveWorkersPattern = Pattern.compile("Alive Workers:.*(\\d+)</li>");
                    while ((line = rd.readLine()) != null) {
                        Matcher matcher = aliveWorkersPattern.matcher(line);
                        if (!matcher.find()) continue;
                        Integer numWorkers = Integer.parseInt(matcher.group(1));
                        if (numWorkers != workerCount) {
                            LOGGER.debug("Only {}/{} workers are alive.", (Object)numWorkers, (Object)workerCount);
                            Boolean bl = false;
                            return bl;
                        }
                        LOGGER.debug("{}/{} workers now alive.", (Object)workerCount, (Object)workerCount);
                        Boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error encountered while checking master URL for worker count.", (Throwable)e);
                }
                finally {
                    if (rd != null) {
                        rd.close();
                    }
                }
                LOGGER.debug("Could not find alive workers text.");
                return false;
            }
        }).every(1L, TimeUnit.SECONDS).before(5L, TimeUnit.MINUTES).becomesTrue();
    }

    @Override
    public void onTestContextInitialized() {
        this.createAndSetGraphConfig(3);
        this.executeGraph(GraphFixtures.modern);
    }

    @Override
    public CCMBridge.Builder configureCCM() {
        return super.configureCCM().withNodes(3).withWorkload(1, "graph", "spark").withWorkload(2, "graph", "spark").withWorkload(3, "graph", "spark");
    }

    public Host findSparkMaster() {
        for (Host host : this.cluster().getMetadata().getAllHosts()) {
            if (!TestUtils.pingPort(host.getAddress(), 7077)) continue;
            return host;
        }
        return null;
    }
}

