/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.GraphExtractors;
import com.datastax.driver.dse.graph.GraphNode;
import java.util.Iterator;
import org.assertj.core.api.AbstractAssert;

public abstract class ElementAssert<S extends AbstractAssert<S, A>, A extends Element>
extends AbstractAssert<S, A> {
    protected ElementAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S hasId(GraphNode id) {
        Assertions.assertThat((Object)((Element)this.actual).getId()).isEqualTo((Object)id);
        return (S)this.myself;
    }

    public S hasLabel(String label) {
        Assertions.assertThat((String)((Element)this.actual).getLabel()).isEqualTo((Object)label);
        return (S)this.myself;
    }

    public S hasProperty(String propertyName) {
        Assertions.assertThat((Iterable)((Element)this.actual).getPropertyNames()).contains((Object[])new String[]{propertyName});
        return (S)this.myself;
    }

    public S hasProperty(String propertyName, String value) {
        return this.hasProperty(propertyName, value, String.class);
    }

    public S hasProperty(String propertyName, int value) {
        return this.hasProperty(propertyName, value, Integer.class);
    }

    public S hasProperty(String propertyName, Boolean value) {
        return this.hasProperty(propertyName, value, Boolean.class);
    }

    public S hasProperty(String propertyName, Long value) {
        return this.hasProperty(propertyName, value, Long.class);
    }

    public S hasProperty(String propertyName, Double value) {
        return this.hasProperty(propertyName, value, Double.class);
    }

    public S hasProperty(String propertyName, Float value) {
        return this.hasProperty(propertyName, value, Float.class);
    }

    public <T> S hasProperty(String propertyName, T value, Class<T> clazz) {
        this.hasProperty(propertyName);
        Assertions.assertThat((Iterator)((Element)this.actual).getProperties(propertyName)).extracting(GraphExtractors.propertyValueAs(clazz)).contains(new Object[]{value});
        return (S)this.myself;
    }
}

