/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.EdgeAssert;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphNodeAssert;
import com.datastax.driver.dse.graph.Path;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;

public class PathAssert
extends AbstractAssert<PathAssert, Path> {
    public PathAssert(Path actual) {
        super((Object)actual, PathAssert.class);
    }

    public GraphNodeAssert object(int i) {
        Assertions.assertThat((int)((Path)this.actual).getObjects().size()).isGreaterThanOrEqualTo(i);
        return new GraphNodeAssert(((Path)this.actual).getObject(i));
    }

    public PathAssert hasLabel(String label) {
        Assertions.assertThat((boolean)((Path)this.actual).hasLabel(label)).isTrue();
        return (PathAssert)this.myself;
    }

    public PathAssert doesNotHaveLabel(String label) {
        Assertions.assertThat((boolean)((Path)this.actual).hasLabel(label)).isFalse();
        return (PathAssert)this.myself;
    }

    public PathAssert hasLabel(int i, String ... labels) {
        Assertions.assertThat((int)((Path)this.actual).getLabels().size()).isGreaterThanOrEqualTo(i);
        Assertions.assertThat((Iterable)((Iterable)((Path)this.actual).getLabels().get(i))).containsOnly((Object[])labels);
        return (PathAssert)this.myself;
    }

    public PathAssert hasNoLabel(int i) {
        return this.hasLabel(i, new String[0]);
    }

    public GraphNodeAssert object(String label) {
        return new GraphNodeAssert(((Path)this.actual).getObject(label));
    }

    public AbstractListAssert<?, ? extends List<GraphNode>, GraphNode> objects(String label) {
        return Assertions.assertThat((List)((Path)this.actual).getObjects(label));
    }

    public static void validatePathObjects(Path path) {
        GraphAssertions.assertThat(path).object(0).asVertex().hasLabel("person");
        ((EdgeAssert)((Object)GraphAssertions.assertThat(path).object(1).asEdge().hasLabel("knows"))).hasOutVLabel("person").hasOutV((GraphNode)path.getObjects().get(0)).hasInVLabel("person").hasInV((GraphNode)path.getObjects().get(2));
        GraphAssertions.assertThat(path).object(2).asVertex().hasLabel("person");
        ((EdgeAssert)((Object)GraphAssertions.assertThat(path).object(3).asEdge().hasLabel("created"))).hasOutVLabel("person").hasOutV((GraphNode)path.getObjects().get(2)).hasInVLabel("software").hasInV((GraphNode)path.getObjects().get(4));
        GraphAssertions.assertThat(path).object(4).asVertex().hasLabel("software");
    }
}

