/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ArrayBackedRow;
import com.datastax.driver.core.AsyncContinuousPagingResult;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ContinuousPagingQueue;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Token;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.List;

class DefaultAsyncContinuousPagingResult
implements AsyncContinuousPagingResult {
    private final Iterable<Row> currentPage;
    private final ColumnDefinitions columnDefinitions;
    private final int pageNumber;
    private final boolean isLast;
    private final ExecutionInfo executionInfo;
    private final ContinuousPagingQueue queue;
    private volatile ListenableFuture<AsyncContinuousPagingResult> nextPage;

    DefaultAsyncContinuousPagingResult(Iterable<List<ByteBuffer>> data, final ColumnDefinitions columnDefinitions, int pageNumber, boolean isLast, ExecutionInfo executionInfo, final Token.Factory tokenFactory, final ProtocolVersion protocolVersion, ContinuousPagingQueue queue) {
        this.currentPage = Iterables.transform(data, (Function)new Function<List<ByteBuffer>, Row>(){

            public Row apply(List<ByteBuffer> input) {
                return ArrayBackedRow.fromData(columnDefinitions, tokenFactory, protocolVersion, input);
            }
        });
        this.columnDefinitions = columnDefinitions;
        this.pageNumber = pageNumber;
        this.isLast = isLast;
        this.executionInfo = executionInfo;
        this.queue = queue;
    }

    @Override
    public Iterable<Row> currentPage() {
        return this.currentPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<AsyncContinuousPagingResult> nextPage() {
        ListenableFuture<AsyncContinuousPagingResult> result = this.nextPage;
        if (result == null) {
            DefaultAsyncContinuousPagingResult defaultAsyncContinuousPagingResult = this;
            synchronized (defaultAsyncContinuousPagingResult) {
                result = this.nextPage;
                if (result == null) {
                    this.nextPage = result = this.computeNextPage();
                }
            }
        }
        return result;
    }

    private ListenableFuture<AsyncContinuousPagingResult> computeNextPage() {
        if (this.isLast) {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Can't call nextPage() on the last page (use isLast() to check)"));
        }
        return this.queue.dequeueOrCreatePending();
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Override
    public int pageNumber() {
        return this.pageNumber;
    }

    @Override
    public boolean isLast() {
        return this.isLast;
    }

    @Override
    public void cancel() {
        this.queue.cancel();
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }
}

