/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ParseUtils;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.JsonProcessingException;
import com.datastax.shaded.jackson.core.Version;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonDeserializer;
import com.datastax.shaded.jackson.databind.JsonSerializer;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.module.SimpleModule;
import com.datastax.shaded.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

class GraphSON1DriverTimeModule
extends SimpleModule {
    GraphSON1DriverTimeModule(String name, Version version) {
        super(name, version, GraphSON1DriverTimeModule.createDeserializers(), GraphSON1DriverTimeModule.createSerializers());
    }

    private static Map<Class<?>, JsonDeserializer<?>> createDeserializers() {
        return ImmutableMap.builder().put(LocalDate.class, (Object)new LocalDateJacksonDeserializer()).build();
    }

    private static List<JsonSerializer<?>> createSerializers() {
        return ImmutableList.builder().add((Object)new LocalDateJacksonSerializer()).build();
    }

    static final class LocalDateJacksonDeserializer
    extends StdDeserializer<LocalDate> {
        LocalDateJacksonDeserializer() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String dateString = p.getText();
            try {
                Date date = ParseUtils.parseDate(dateString);
                return LocalDate.fromMillisSinceEpoch(date.getTime());
            }
            catch (ParseException e) {
                throw new IOException("Could not deserialize data as a LocalDate.", e);
            }
        }
    }

    static final class LocalDateJacksonSerializer
    extends StdSerializer<LocalDate> {
        LocalDateJacksonSerializer() {
            super(LocalDate.class);
        }

        @Override
        public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

