/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.AttributeKey;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger(Message.class);
    static AttributeKey<CodecRegistry> CODEC_REGISTRY_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"com.datastax.driver.core.CodecRegistry");
    private volatile int streamId = -1;
    private volatile Map<String, ByteBuffer> customPayload;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    protected Message() {
    }

    Message setStreamId(int streamId) {
        this.streamId = streamId;
        return this;
    }

    int getStreamId() {
        return this.streamId;
    }

    Map<String, ByteBuffer> getCustomPayload() {
        return this.customPayload;
    }

    Message setCustomPayload(Map<String, ByteBuffer> customPayload) {
        this.customPayload = customPayload;
        return this;
    }

    static String printPayload(Map<String, ByteBuffer> customPayload) {
        if (customPayload == null) {
            return "null";
        }
        if (customPayload.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<String, ByteBuffer>> iterator = customPayload.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ByteBuffer> entry = iterator.next();
            sb.append(entry.getKey());
            sb.append(":");
            if (entry.getValue() == null) {
                sb.append("null");
            } else {
                Message.bytesToHex(entry.getValue(), sb);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    static void bytesToHex(ByteBuffer bytes, StringBuilder sb) {
        int length = Math.min(bytes.remaining(), 50);
        sb.append("0x");
        for (int i = 0; i < length; ++i) {
            int v = bytes.get(i) & 0xFF;
            sb.append(hexArray[v >>> 4]);
            sb.append(hexArray[v & 0xF]);
        }
        if (bytes.remaining() > 50) {
            sb.append("... [TRUNCATED]");
        }
    }

    @ChannelHandler.Sharable
    static class ProtocolEncoder
    extends MessageToMessageEncoder<Request> {
        private final ProtocolVersion protocolVersion;

        ProtocolEncoder(ProtocolVersion version) {
            this.protocolVersion = version;
        }

        protected void encode(ChannelHandlerContext ctx, Request request, List<Object> out) throws Exception {
            Map<String, ByteBuffer> customPayload;
            EnumSet<Frame.Header.Flag> flags = EnumSet.noneOf(Frame.Header.Flag.class);
            if (request.isTracingRequested()) {
                flags.add(Frame.Header.Flag.TRACING);
            }
            if (this.protocolVersion == ProtocolVersion.NEWEST_BETA) {
                flags.add(Frame.Header.Flag.USE_BETA);
            }
            if ((customPayload = request.getCustomPayload()) != null) {
                if (this.protocolVersion.compareTo(ProtocolVersion.V4) < 0) {
                    throw new UnsupportedFeatureException(this.protocolVersion, "Custom payloads are only supported since native protocol V4");
                }
                flags.add(Frame.Header.Flag.CUSTOM_PAYLOAD);
            }
            Coder<?> coder = request.type.coder;
            int messageSize = coder.encodedSize(request, this.protocolVersion);
            int payloadLength = -1;
            if (customPayload != null) {
                payloadLength = CBUtil.sizeOfBytesMap(customPayload);
                messageSize += payloadLength;
            }
            ByteBuf body = ctx.alloc().buffer(messageSize);
            if (customPayload != null) {
                CBUtil.writeBytesMap(customPayload, body);
                if (logger.isTraceEnabled()) {
                    logger.trace("Sending payload: {} ({} bytes total)", (Object)Message.printPayload(customPayload), (Object)payloadLength);
                }
            }
            coder.encode(request, body, this.protocolVersion);
            if (body.capacity() != messageSize) {
                logger.debug("Detected buffer resizing while encoding {} message ({} => {}), this is a driver bug (ultimately it does not affect the query, but leads to a small inefficiency)", new Object[]{request.type, messageSize, body.capacity()});
            }
            out.add(Frame.create(this.protocolVersion, request.type.opcode, request.getStreamId(), flags, body));
        }
    }

    @ChannelHandler.Sharable
    static class ProtocolDecoder
    extends MessageToMessageDecoder<Frame> {
        ProtocolDecoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            boolean hasWarnings;
            Map<String, ByteBuffer> customPayload;
            boolean isTracing = frame.header.flags.contains((Object)Frame.Header.Flag.TRACING);
            boolean isCustomPayload = frame.header.flags.contains((Object)Frame.Header.Flag.CUSTOM_PAYLOAD);
            UUID tracingId = isTracing ? CBUtil.readUUID(frame.body) : null;
            Map<String, ByteBuffer> map = customPayload = isCustomPayload ? CBUtil.readBytesMap(frame.body) : null;
            if (customPayload != null && logger.isTraceEnabled()) {
                logger.trace("Received payload: {} ({} bytes total)", (Object)Message.printPayload(customPayload), (Object)CBUtil.sizeOfBytesMap(customPayload));
            }
            List<String> warnings = (hasWarnings = frame.header.flags.contains((Object)Frame.Header.Flag.WARNING)) ? CBUtil.readStringList(frame.body) : Collections.emptyList();
            try {
                CodecRegistry codecRegistry = (CodecRegistry)ctx.channel().attr(CODEC_REGISTRY_ATTRIBUTE_KEY).get();
                assert (codecRegistry != null);
                Object response = Response.Type.fromOpcode((int)frame.header.opcode).decoder.decode(frame.body, frame.header.version, codecRegistry);
                ((Response)response).setTracingId(tracingId).setWarnings(warnings).setCustomPayload(customPayload).setStreamId(frame.header.streamId);
                out.add(response);
            }
            finally {
                frame.body.release();
            }
        }
    }

    static abstract class Response
    extends Message {
        final Type type;
        protected volatile UUID tracingId;
        protected volatile List<String> warnings;

        protected Response(Type type) {
            this.type = type;
        }

        Response setTracingId(UUID tracingId) {
            this.tracingId = tracingId;
            return this;
        }

        UUID getTracingId() {
            return this.tracingId;
        }

        Response setWarnings(List<String> warnings) {
            this.warnings = warnings;
            return this;
        }

        static enum Type {
            ERROR(0, Responses.Error.decoder),
            READY(2, Responses.Ready.decoder),
            AUTHENTICATE(3, Responses.Authenticate.decoder),
            SUPPORTED(6, Responses.Supported.decoder),
            RESULT(8, Responses.Result.decoder),
            EVENT(12, Responses.Event.decoder),
            AUTH_CHALLENGE(14, Responses.AuthChallenge.decoder),
            AUTH_SUCCESS(16, Responses.AuthSuccess.decoder);

            final int opcode;
            final Decoder<?> decoder;
            private static final Type[] opcodeIdx;

            private Type(int opcode, Decoder<?> decoder) {
                this.opcode = opcode;
                this.decoder = decoder;
            }

            static Type fromOpcode(int opcode) {
                if (opcode < 0 || opcode >= opcodeIdx.length) {
                    throw new DriverInternalError(String.format("Unknown response opcode %d", opcode));
                }
                Type t = opcodeIdx[opcode];
                if (t == null) {
                    throw new DriverInternalError(String.format("Unknown response opcode %d", opcode));
                }
                return t;
            }

            static {
                int maxOpcode = -1;
                for (Type type : Type.values()) {
                    maxOpcode = Math.max(maxOpcode, type.opcode);
                }
                opcodeIdx = new Type[maxOpcode + 1];
                for (Type type : Type.values()) {
                    if (opcodeIdx[type.opcode] != null) {
                        throw new IllegalStateException("Duplicate opcode");
                    }
                    Type.opcodeIdx[type.opcode] = type;
                }
            }
        }
    }

    static abstract class Request
    extends Message {
        final Type type;
        private final boolean tracingRequested;

        protected Request(Type type) {
            this(type, false);
        }

        protected Request(Type type, boolean tracingRequested) {
            this.type = type;
            this.tracingRequested = tracingRequested;
        }

        @Override
        Request setStreamId(int streamId) {
            if (this.getStreamId() < 0) {
                return (Request)super.setStreamId(streamId);
            }
            Request copy = this.copy();
            copy.setStreamId(streamId);
            return copy;
        }

        boolean isTracingRequested() {
            return this.tracingRequested;
        }

        ConsistencyLevel consistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.consistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.consistency;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.consistency;
                }
            }
            return null;
        }

        ConsistencyLevel serialConsistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.serialConsistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.serialConsistency;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.serialConsistency;
                }
            }
            return null;
        }

        long defaultTimestamp() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.defaultTimestamp;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.defaultTimestamp;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.defaultTimestamp;
                }
            }
            return 0L;
        }

        ByteBuffer pagingState() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.pagingState;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.pagingState;
                }
            }
            return null;
        }

        Requests.QueryProtocolOptions options() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options;
                }
            }
            return null;
        }

        Request copy() {
            Request request = this.copyInternal();
            request.setCustomPayload(this.getCustomPayload());
            return request;
        }

        protected abstract Request copyInternal();

        Request copy(ConsistencyLevel newConsistencyLevel) {
            Request request = this.copyInternal(newConsistencyLevel);
            request.setCustomPayload(this.getCustomPayload());
            return request;
        }

        protected Request copyInternal(ConsistencyLevel newConsistencyLevel) {
            throw new UnsupportedOperationException();
        }

        static enum Type {
            STARTUP(1, Requests.Startup.coder),
            CREDENTIALS(4, Requests.Credentials.coder),
            OPTIONS(5, Requests.Options.coder),
            QUERY(7, Requests.Query.coder),
            PREPARE(9, Requests.Prepare.coder),
            EXECUTE(10, Requests.Execute.coder),
            REGISTER(11, Requests.Register.coder),
            BATCH(13, Requests.Batch.coder),
            AUTH_RESPONSE(15, Requests.AuthResponse.coder),
            REVISE_REQUEST(255, Requests.ReviseRequest.coder);

            final int opcode;
            final Coder<?> coder;

            private Type(int opcode, Coder<?> coder) {
                this.opcode = opcode;
                this.coder = coder;
            }
        }
    }

    static interface Decoder<R extends Response> {
        public R decode(ByteBuf var1, ProtocolVersion var2, CodecRegistry var3);
    }

    static interface Coder<R extends Request> {
        public void encode(R var1, ByteBuf var2, ProtocolVersion var3);

        public int encodedSize(R var1, ProtocolVersion var2);
    }
}

