/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.codahale.metrics.Timer;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.BusyConnectionException;
import com.datastax.driver.core.exceptions.BusyPoolException;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiResponseRequestHandler
implements Connection.ResponseCallback {
    private static final Logger logger = LoggerFactory.getLogger(MultiResponseRequestHandler.class);
    private final String id = Long.toString(System.identityHashCode(this));
    final SessionManager manager;
    private final Callback callback;
    private final Message.Request initialRequest;
    final Statement statement;
    private final RequestHandler.QueryPlan queryPlan;
    final int timeoutMillis;
    private final Timer.Context timerContext;
    private final AtomicReference<RequestHandler.QueryState> queryStateRef;
    private volatile List<Host> triedHosts;
    private volatile ConcurrentMap<InetSocketAddress, Throwable> errors;
    private volatile Host current;
    private volatile Connection connection;
    private volatile Connection.ResponseHandler connectionHandler;
    private volatile ConsistencyLevel retryConsistencyLevel;
    private volatile int retriesByPolicy;
    private volatile ExecutionInfo info;
    private volatile boolean gotFirstResult;
    private volatile boolean wasReleased;

    MultiResponseRequestHandler(SessionManager manager, Callback callback, Statement statement) {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] {}", (Object)this.id, (Object)statement);
        }
        this.manager = manager;
        this.callback = callback;
        this.initialRequest = callback.getRequest();
        this.statement = statement;
        this.queryPlan = new RequestHandler.QueryPlan(manager.loadBalancingPolicy().newQueryPlan(manager.poolsState.keyspace, statement));
        this.timeoutMillis = statement.getReadTimeoutMillis() >= 0 ? statement.getReadTimeoutMillis() : manager.configuration().getSocketOptions().getReadTimeoutMillis();
        this.timerContext = this.metricsEnabled() ? this.metrics().getRequestsTimer().time() : null;
        this.queryStateRef = new AtomicReference<RequestHandler.QueryState>(RequestHandler.QueryState.INITIAL);
        callback.register(this);
    }

    private boolean metricsEnabled() {
        return this.manager.configuration().getMetricsOptions().isEnabled();
    }

    private Metrics metrics() {
        return this.manager.cluster.manager.metrics;
    }

    void sendRequest() {
        try {
            Host host;
            while ((host = this.queryPlan.next()) != null && !this.queryStateRef.get().isCancelled()) {
                if (!this.query(host)) continue;
                return;
            }
            this.reportNoMoreHosts();
        }
        catch (Exception e) {
            this.setException(null, new DriverInternalError("An unexpected error happened while sending requests", e), false);
        }
    }

    void release() {
        this.release(this.connection);
        if (this.timerContext != null) {
            this.timerContext.stop();
        }
    }

    private boolean query(final Host host) {
        HostConnectionPool pool = (HostConnectionPool)this.manager.pools.get(host);
        if (pool == null || pool.isClosed()) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Querying node {}", (Object)this.id, (Object)host);
        }
        PoolingOptions poolingOptions = this.manager.configuration().getPoolingOptions();
        ListenableFuture<Connection> connectionFuture = pool.borrowConnection(poolingOptions.getPoolTimeoutMillis(), TimeUnit.MILLISECONDS, poolingOptions.getMaxQueueSize());
        Futures.addCallback(connectionFuture, (FutureCallback)new FutureCallback<Connection>(){

            public void onSuccess(Connection connection) {
                MultiResponseRequestHandler.this.connection = connection;
                if (MultiResponseRequestHandler.this.current != null) {
                    if (MultiResponseRequestHandler.this.triedHosts == null) {
                        MultiResponseRequestHandler.this.triedHosts = new CopyOnWriteArrayList();
                    }
                    MultiResponseRequestHandler.this.triedHosts.add(MultiResponseRequestHandler.this.current);
                }
                MultiResponseRequestHandler.this.current = host;
                try {
                    MultiResponseRequestHandler.this.write(connection, MultiResponseRequestHandler.this);
                }
                catch (ConnectionException e) {
                    if (MultiResponseRequestHandler.this.metricsEnabled()) {
                        MultiResponseRequestHandler.this.metrics().getErrorMetrics().getConnectionErrors().inc();
                    }
                    if (connection != null) {
                        MultiResponseRequestHandler.this.release(connection);
                    }
                    MultiResponseRequestHandler.this.logError(host.getSocketAddress(), e);
                    MultiResponseRequestHandler.this.sendRequest();
                }
                catch (BusyConnectionException e) {
                    MultiResponseRequestHandler.this.release(connection);
                    MultiResponseRequestHandler.this.logError(host.getSocketAddress(), e);
                    MultiResponseRequestHandler.this.sendRequest();
                }
                catch (RuntimeException e) {
                    if (connection != null) {
                        MultiResponseRequestHandler.this.release(connection);
                    }
                    logger.error("Unexpected error while querying " + host.getAddress(), (Throwable)e);
                    MultiResponseRequestHandler.this.logError(host.getSocketAddress(), e);
                    MultiResponseRequestHandler.this.sendRequest();
                }
            }

            public void onFailure(Throwable t) {
                if (t instanceof BusyPoolException) {
                    MultiResponseRequestHandler.this.logError(host.getSocketAddress(), t);
                } else {
                    logger.error("Unexpected error while querying " + host.getAddress(), t);
                    MultiResponseRequestHandler.this.logError(host.getSocketAddress(), t);
                }
                MultiResponseRequestHandler.this.sendRequest();
            }
        });
        return true;
    }

    private void write(Connection connection, Connection.ResponseCallback responseCallback) throws ConnectionException, BusyConnectionException {
        RequestHandler.QueryState previous;
        if (this.connectionHandler != null) {
            this.connectionHandler.cancelHandler();
            this.connectionHandler = null;
            this.wasReleased = false;
        }
        do {
            if (!(previous = this.queryStateRef.get()).isCancelled()) continue;
            this.release(connection);
            return;
        } while (!previous.inProgress && !this.queryStateRef.compareAndSet(previous, previous.startNext()));
        this.connectionHandler = connection.write(responseCallback, this.statement.getReadTimeoutMillis(), false, true);
        if (this.wasReleased) {
            this.connectionHandler.cancelHandler();
        }
        this.connectionHandler.startTimeout();
    }

    void cancel() {
        RequestHandler.QueryState previous;
        do {
            if ((previous = this.queryStateRef.get()).isCancelled()) {
                return;
            }
            if (previous == RequestHandler.QueryState.INITIAL && this.queryStateRef.compareAndSet(previous, RequestHandler.QueryState.CANCELLED_WHILE_COMPLETE)) {
                logger.trace("[{}] Cancelled before the first request was sent", (Object)this.id);
                return;
            }
            if (!previous.inProgress || !this.queryStateRef.compareAndSet(previous, RequestHandler.QueryState.CANCELLED_WHILE_IN_PROGRESS)) continue;
            logger.trace("[{}] Cancelled during the initial request", (Object)this.id);
            this.sendCancelRequest();
            return;
        } while (previous.inProgress || !this.queryStateRef.compareAndSet(previous, RequestHandler.QueryState.CANCELLED_WHILE_COMPLETE));
        logger.trace("[{}] Cancelled after initial request complete", (Object)this.id);
        this.sendCancelRequest();
    }

    private void sendCancelRequest() {
        Connection.ResponseCallback cancelResponseCallback = new Connection.ResponseCallback(){

            @Override
            public Message.Request request() {
                return MultiResponseRequestHandler.this.callback.getCancelRequest(((MultiResponseRequestHandler)MultiResponseRequestHandler.this).connectionHandler.streamId);
            }

            @Override
            public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
                logger.trace("[{}] Cancelled successfully");
                MultiResponseRequestHandler.this.release();
            }

            @Override
            public void onException(Connection connection, Exception exception, long latency, int retryCount) {
                logger.warn("[" + MultiResponseRequestHandler.this.id + "] Cancel request failed. This is not critical (the request will eventually time out server-side).", (Throwable)exception);
            }

            @Override
            public boolean onTimeout(Connection connection, long latency, int retryCount) {
                logger.warn("[{}] Cancel request timed out This is not critical (the request will eventually time out server-side).", (Object)MultiResponseRequestHandler.this.id);
                return false;
            }

            @Override
            public int retryCount() {
                return 0;
            }
        };
        try {
            logger.trace("[{}] Sending cancel request", (Object)this.id);
            this.connection.write(cancelResponseCallback, this.timeoutMillis, true, false);
        }
        catch (Throwable t) {
            logger.warn("[" + this.id + "] Error writing cancel request. This is not critical (the request will eventually time out server-side).", t);
        }
    }

    void requestMore(int nextPages) {
        RequestHandler.QueryState previous = this.queryStateRef.get();
        if (previous.isCancelled()) {
            logger.debug("[{}] - cannot send more pages, session was cancelled", (Object)this.id);
        } else {
            this.sendMorePagesRequest(nextPages);
        }
    }

    private void sendMorePagesRequest(final int nextPages) {
        assert (this.connection != null) : "expected valid connection in order to request more pages";
        Connection.ResponseCallback backpressureCallback = new Connection.ResponseCallback(){

            @Override
            public Message.Request request() {
                return MultiResponseRequestHandler.this.callback.getBackpressureRequest(((MultiResponseRequestHandler)MultiResponseRequestHandler.this).connectionHandler.streamId, nextPages);
            }

            @Override
            public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
            }

            @Override
            public void onException(Connection connection, Exception exception, long latency, int retryCount) {
                MultiResponseRequestHandler.this.reportBackpressureError(exception);
            }

            @Override
            public boolean onTimeout(Connection connection, long latency, int retryCount) {
                return false;
            }

            @Override
            public int retryCount() {
                return 0;
            }
        };
        try {
            logger.trace("[{}] Sending backpressure request", (Object)this.id);
            this.connection.write(backpressureCallback, -1L, false, false);
        }
        catch (Throwable t) {
            this.reportBackpressureError(t);
        }
    }

    private void reportBackpressureError(Throwable t) {
        logger.warn("[" + this.id + "] Error requesting more pages. This is not critical (the request will eventually time out server-side).", t);
        this.callback.onException(this.connection, new DriverInternalError(String.format("Error requesting more pages: %s/%s", t.getClass().getName(), t.getMessage())), false);
    }

    private void release(Connection connection) {
        this.wasReleased = true;
        if (this.connectionHandler != null) {
            this.connectionHandler.cancelHandler();
        }
        connection.release();
    }

    @Override
    public Message.Request request() {
        if (this.retryConsistencyLevel != null && this.retryConsistencyLevel != this.initialRequest.consistency()) {
            return this.initialRequest.copy(this.retryConsistencyLevel);
        }
        return this.initialRequest;
    }

    @Override
    public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
        RequestHandler.QueryState queryState = this.queryStateRef.get();
        if (!(this.gotFirstResult || queryState.isInProgressAt(retryCount) && this.queryStateRef.compareAndSet(queryState, queryState.complete()))) {
            logger.debug("onSet triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, this.queryStateRef.get()});
            return;
        }
        try {
            switch (response.type) {
                case RESULT: {
                    this.setResult(connection, response);
                    break;
                }
                case ERROR: {
                    Responses.Error err = (Responses.Error)response;
                    DriverException exceptionToReport = err.asException(connection.address);
                    RetryPolicy.RetryDecision retry = null;
                    if (!this.gotFirstResult) {
                        RetryPolicy retryPolicy = this.retryPolicy();
                        switch (err.code) {
                            case READ_TIMEOUT: {
                                this.release(connection);
                                assert (err.infos instanceof ReadTimeoutException);
                                ReadTimeoutException rte = (ReadTimeoutException)err.infos;
                                retry = retryPolicy.onReadTimeout(this.statement, rte.getConsistencyLevel(), rte.getRequiredAcknowledgements(), rte.getReceivedAcknowledgements(), rte.wasDataRetrieved(), this.retriesByPolicy);
                                if (!this.metricsEnabled()) break;
                                this.metrics().getErrorMetrics().getReadTimeouts().inc();
                                if (retry.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                                    this.metrics().getErrorMetrics().getRetriesOnReadTimeout().inc();
                                }
                                if (retry.getType() != RetryPolicy.RetryDecision.Type.IGNORE) break;
                                this.metrics().getErrorMetrics().getIgnoresOnReadTimeout().inc();
                                break;
                            }
                            case WRITE_TIMEOUT: {
                                this.release(connection);
                                assert (err.infos instanceof WriteTimeoutException);
                                WriteTimeoutException wte = (WriteTimeoutException)err.infos;
                                String msg = String.format("Unexpected error for %s, multi-response query are expected to be read-only", this.id);
                                logger.error(msg, (Throwable)wte);
                                this.setException(connection, new DriverInternalError(msg, wte), true);
                                break;
                            }
                            case UNAVAILABLE: {
                                this.release(connection);
                                assert (err.infos instanceof UnavailableException);
                                UnavailableException ue = (UnavailableException)err.infos;
                                retry = retryPolicy.onUnavailable(this.statement, ue.getConsistencyLevel(), ue.getRequiredReplicas(), ue.getAliveReplicas(), this.retriesByPolicy);
                                if (!this.metricsEnabled()) break;
                                this.metrics().getErrorMetrics().getUnavailables().inc();
                                if (retry.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                                    this.metrics().getErrorMetrics().getRetriesOnUnavailable().inc();
                                }
                                if (retry.getType() != RetryPolicy.RetryDecision.Type.IGNORE) break;
                                this.metrics().getErrorMetrics().getIgnoresOnUnavailable().inc();
                                break;
                            }
                            case OVERLOADED: {
                                this.release(connection);
                                assert (exceptionToReport instanceof OverloadedException);
                                logger.warn("Host {} is overloaded.", (Object)connection.address);
                                retry = this.computeRetryDecisionOnRequestError((OverloadedException)exceptionToReport);
                                break;
                            }
                            case SERVER_ERROR: {
                                this.release(connection);
                                assert (exceptionToReport instanceof ServerError);
                                logger.warn("{} replied with server error ({}), defuncting connection.", (Object)connection.address, (Object)err.message);
                                connection.defunct(exceptionToReport);
                                retry = this.computeRetryDecisionOnRequestError((ServerError)exceptionToReport);
                                break;
                            }
                            case IS_BOOTSTRAPPING: {
                                this.release(connection);
                                assert (exceptionToReport instanceof BootstrappingException);
                                logger.error("Query sent to {} but it is bootstrapping. This shouldn't happen but trying next host.", (Object)connection.address);
                                if (this.metricsEnabled()) {
                                    this.metrics().getErrorMetrics().getOthers().inc();
                                }
                                this.logError(connection.address, exceptionToReport);
                                this.retry(false, null);
                                return;
                            }
                            case UNPREPARED: {
                                assert (err.infos instanceof MD5Digest);
                                MD5Digest id = (MD5Digest)err.infos;
                                PreparedStatement toPrepare = (PreparedStatement)this.manager.cluster.manager.preparedQueries.get(id);
                                if (toPrepare == null) {
                                    this.release(connection);
                                    String msg = String.format("Tried to execute unknown prepared query %s", id);
                                    logger.error(msg);
                                    this.setException(connection, new DriverInternalError(msg), true);
                                    return;
                                }
                                String currentKeyspace = connection.keyspace();
                                String prepareKeyspace = toPrepare.getQueryKeyspace();
                                if (!(prepareKeyspace == null || currentKeyspace != null && currentKeyspace.equals(prepareKeyspace))) {
                                    this.release(connection);
                                    throw new IllegalStateException(String.format("Statement was prepared on keyspace %s, can't execute it on %s (%s)", toPrepare.getQueryKeyspace(), connection.keyspace(), toPrepare.getQueryString()));
                                }
                                logger.info("Query {} is not prepared on {}, preparing before retrying executing. Seeing this message a few times is fine, but seeing it a lot may be source of performance problems", (Object)toPrepare.getQueryString(), (Object)connection.address);
                                this.write(connection, this.prepareAndRetry(toPrepare.getQueryString(), toPrepare.getQueryKeyspace()));
                                return;
                            }
                            default: {
                                this.release(connection);
                                if (!this.metricsEnabled()) break;
                                this.metrics().getErrorMetrics().getOthers().inc();
                            }
                        }
                    }
                    if (retry == null) {
                        this.setResult(connection, response);
                        break;
                    }
                    this.processRetryDecision(retry, connection, exceptionToReport, true);
                    break;
                }
                default: {
                    this.release(connection);
                    this.setResult(connection, response);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.setException(connection, e, false);
        }
    }

    private RetryPolicy retryPolicy() {
        return this.statement.getRetryPolicy() == null ? this.manager.configuration().getPolicies().getRetryPolicy() : this.statement.getRetryPolicy();
    }

    private RetryPolicy.RetryDecision computeRetryDecisionOnRequestError(DriverException exception) {
        RetryPolicy.RetryDecision decision = this.statement.isIdempotentWithDefault(this.manager.cluster.getConfiguration().getQueryOptions()) ? this.retryPolicy().onRequestError(this.statement, this.request().consistency(), exception, this.retriesByPolicy) : RetryPolicy.RetryDecision.rethrow();
        if (this.metricsEnabled()) {
            if (exception instanceof OperationTimedOutException) {
                this.metrics().getErrorMetrics().getClientTimeouts().inc();
                if (decision.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                    this.metrics().getErrorMetrics().getRetriesOnClientTimeout().inc();
                }
                if (decision.getType() == RetryPolicy.RetryDecision.Type.IGNORE) {
                    this.metrics().getErrorMetrics().getIgnoresOnClientTimeout().inc();
                }
            } else if (exception instanceof ConnectionException) {
                this.metrics().getErrorMetrics().getConnectionErrors().inc();
                if (decision.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                    this.metrics().getErrorMetrics().getRetriesOnConnectionError().inc();
                }
                if (decision.getType() == RetryPolicy.RetryDecision.Type.IGNORE) {
                    this.metrics().getErrorMetrics().getIgnoresOnConnectionError().inc();
                }
            } else {
                this.metrics().getErrorMetrics().getOthers().inc();
                if (decision.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                    this.metrics().getErrorMetrics().getRetriesOnOtherErrors().inc();
                }
                if (decision.getType() == RetryPolicy.RetryDecision.Type.IGNORE) {
                    this.metrics().getErrorMetrics().getIgnoresOnOtherErrors().inc();
                }
            }
        }
        return decision;
    }

    private void processRetryDecision(RetryPolicy.RetryDecision retryDecision, Connection connection, Exception exceptionToReport, boolean fromServer) {
        switch (retryDecision.getType()) {
            case RETRY: {
                ++this.retriesByPolicy;
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] Doing retry {} for query {} at consistency {}", new Object[]{this.id, this.retriesByPolicy, this.statement, retryDecision.getRetryConsistencyLevel()});
                }
                if (this.metricsEnabled()) {
                    this.metrics().getErrorMetrics().getRetries().inc();
                }
                if (!retryDecision.isRetryCurrent()) {
                    this.logError(connection.address, exceptionToReport);
                }
                this.retry(retryDecision.isRetryCurrent(), retryDecision.getRetryConsistencyLevel());
                break;
            }
            case RETHROW: {
                this.setException(connection, exceptionToReport, fromServer);
                break;
            }
            case IGNORE: {
                if (this.metricsEnabled()) {
                    this.metrics().getErrorMetrics().getIgnores().inc();
                }
                this.setResult(connection, new Responses.Result.Void());
            }
        }
    }

    private void retry(boolean retryCurrent, ConsistencyLevel newConsistencyLevel) {
        Host h = this.current;
        if (newConsistencyLevel != null) {
            this.retryConsistencyLevel = newConsistencyLevel;
        }
        if (this.queryStateRef.get().isCancelled()) {
            return;
        }
        if (!retryCurrent || !this.query(h)) {
            this.sendRequest();
        }
    }

    private Connection.ResponseCallback prepareAndRetry(final String toPrepare, final String keyspace) {
        return new Connection.ResponseCallback(){

            @Override
            public Message.Request request() {
                Requests.Prepare request = new Requests.Prepare(toPrepare, keyspace);
                request.setCustomPayload(MultiResponseRequestHandler.this.statement.getOutgoingPayload());
                return request;
            }

            @Override
            public int retryCount() {
                return MultiResponseRequestHandler.this.retryCount();
            }

            @Override
            public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
                RequestHandler.QueryState queryState = (RequestHandler.QueryState)MultiResponseRequestHandler.this.queryStateRef.get();
                if (!queryState.isInProgressAt(retryCount) || !MultiResponseRequestHandler.this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
                    logger.debug("onSet triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, MultiResponseRequestHandler.this.queryStateRef.get()});
                    return;
                }
                MultiResponseRequestHandler.this.release(connection);
                switch (response.type) {
                    case RESULT: {
                        if (((Responses.Result)response).kind == Responses.Result.Kind.PREPARED) {
                            logger.debug("Scheduling retry now that query is prepared");
                            MultiResponseRequestHandler.this.retry(true, null);
                            break;
                        }
                        MultiResponseRequestHandler.this.logError(connection.address, new DriverException("Got unexpected response to prepare message: " + response));
                        MultiResponseRequestHandler.this.retry(false, null);
                        break;
                    }
                    case ERROR: {
                        MultiResponseRequestHandler.this.logError(connection.address, new DriverException("Error preparing query, got " + response));
                        if (MultiResponseRequestHandler.this.metricsEnabled()) {
                            MultiResponseRequestHandler.this.metrics().getErrorMetrics().getOthers().inc();
                        }
                        MultiResponseRequestHandler.this.retry(false, null);
                        break;
                    }
                    default: {
                        MultiResponseRequestHandler.this.setResult(connection, response);
                    }
                }
            }

            @Override
            public void onException(Connection connection, Exception exception, long latency, int retryCount) {
                MultiResponseRequestHandler.this.onException(connection, exception, latency, retryCount);
            }

            @Override
            public boolean onTimeout(Connection connection, long latency, int retryCount) {
                RequestHandler.QueryState queryState = (RequestHandler.QueryState)MultiResponseRequestHandler.this.queryStateRef.get();
                if (!queryState.isInProgressAt(retryCount) || !MultiResponseRequestHandler.this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
                    logger.debug("onTimeout triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, MultiResponseRequestHandler.this.queryStateRef.get()});
                    return false;
                }
                MultiResponseRequestHandler.this.release(connection);
                MultiResponseRequestHandler.this.logError(connection.address, new OperationTimedOutException(connection.address, "Timed out waiting for response to PREPARE message"));
                MultiResponseRequestHandler.this.retry(false, null);
                return true;
            }
        };
    }

    @Override
    public void onException(Connection connection, Exception exception, long latency, int retryCount) {
        RequestHandler.QueryState queryState = this.queryStateRef.get();
        if (!(this.gotFirstResult || queryState.isInProgressAt(retryCount) && this.queryStateRef.compareAndSet(queryState, queryState.complete()))) {
            logger.debug("onException triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, this.queryStateRef.get()});
            return;
        }
        try {
            this.release(connection);
            if (!this.gotFirstResult && exception instanceof ConnectionException) {
                RetryPolicy.RetryDecision decision = this.computeRetryDecisionOnRequestError((ConnectionException)exception);
                this.processRetryDecision(decision, connection, exception, false);
            } else {
                this.setException(connection, exception, false);
            }
        }
        catch (Exception e) {
            this.setException(connection, new DriverInternalError("An unexpected error happened while handling exception " + exception, e), false);
        }
    }

    @Override
    public boolean onTimeout(Connection connection, long latency, int retryCount) {
        RequestHandler.QueryState queryState = this.queryStateRef.get();
        if (!queryState.isInProgressAt(retryCount) || !this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
            logger.debug("onTimeout triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, this.queryStateRef.get()});
            return false;
        }
        try {
            OperationTimedOutException timeoutException = new OperationTimedOutException(connection.address, "Timed out waiting for server response");
            RetryPolicy.RetryDecision decision = this.computeRetryDecisionOnRequestError(timeoutException);
            this.processRetryDecision(decision, connection, timeoutException, false);
        }
        catch (Exception e) {
            this.setException(connection, new DriverInternalError("An unexpected error happened while handling timeout", e), false);
        }
        return true;
    }

    @Override
    public int retryCount() {
        return this.queryStateRef.get().retryCount;
    }

    private void setResult(Connection connection, Message.Response response) {
        this.gotFirstResult = true;
        logger.trace("[{}] Setting result", (Object)this.id);
        try {
            if (this.info == null) {
                if (this.triedHosts == null && this.retryConsistencyLevel == null && response.getCustomPayload() == null) {
                    this.info = this.current.defaultExecutionInfo;
                } else {
                    ImmutableList hosts;
                    if (this.triedHosts == null) {
                        hosts = ImmutableList.of((Object)this.current);
                    } else {
                        hosts = this.triedHosts;
                        hosts.add(this.current);
                    }
                    this.info = new ExecutionInfo(0, 0, (List<Host>)hosts, this.retryConsistencyLevel, response.getCustomPayload());
                }
            }
            this.callback.onResponse(connection, response, this.info, this.statement);
        }
        catch (Exception e) {
            this.callback.onException(connection, new DriverInternalError("Unexpected exception while setting final result from " + response, e), false);
        }
    }

    private void setException(Connection connection, Exception exception, boolean fromServer) {
        logger.trace("[{}] Setting exception", (Object)this.id);
        this.callback.onException(connection, exception, fromServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logError(InetSocketAddress address, Throwable exception) {
        logger.debug("[{}] Error querying {} : {}", new Object[]{this.id, address, exception.toString()});
        if (this.errors == null) {
            MultiResponseRequestHandler multiResponseRequestHandler = this;
            synchronized (multiResponseRequestHandler) {
                if (this.errors == null) {
                    this.errors = new ConcurrentHashMap<InetSocketAddress, Throwable>();
                }
            }
        }
        this.errors.put(address, exception);
    }

    private void reportNoMoreHosts() {
        this.setException(null, new NoHostAvailableException(this.errors == null ? Collections.emptyMap() : this.errors), false);
    }

    static interface Callback {
        public void register(MultiResponseRequestHandler var1);

        public Message.Request getRequest();

        public Message.Request getCancelRequest(int var1);

        public Message.Request getBackpressureRequest(int var1, int var2);

        public void onResponse(Connection var1, Message.Response var2, ExecutionInfo var3, Statement var4);

        public void onException(Connection var1, Exception var2, boolean var3);
    }
}

