/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum ProtocolVersion {
    V1("1.2.0", 1, null),
    V2("2.0.0", 2, V1),
    V3("2.1.0", 3, V2),
    V4("2.2.0", 4, V3),
    V5("3.10.0", 5, V4),
    DSE_V1("3.10.0", 65, V4),
    DSE_V2("4.0", 66, DSE_V1);

    public static final ProtocolVersion NEWEST_SUPPORTED;
    public static final ProtocolVersion NEWEST_BETA;
    private final VersionNumber minCassandraVersion;
    private final int asInt;
    private final ProtocolVersion lowerSupported;
    private static final Map<Integer, ProtocolVersion> INT_TO_VERSION;

    private ProtocolVersion(String minCassandraVersion, int asInt, ProtocolVersion lowerSupported) {
        this.minCassandraVersion = VersionNumber.parse(minCassandraVersion);
        this.asInt = asInt;
        this.lowerSupported = lowerSupported;
    }

    VersionNumber minCassandraVersion() {
        return this.minCassandraVersion;
    }

    DriverInternalError unsupported() {
        return new DriverInternalError("Unsupported protocol version " + (Object)((Object)this));
    }

    public int toInt() {
        return this.asInt;
    }

    public ProtocolVersion getLowerSupported() {
        return this.lowerSupported;
    }

    public static ProtocolVersion fromInt(int i) {
        ProtocolVersion version = INT_TO_VERSION.get(i);
        if (version == null) {
            throw new IllegalArgumentException("No protocol version matching integer version " + i);
        }
        return version;
    }

    static {
        NEWEST_SUPPORTED = DSE_V2;
        NEWEST_BETA = V5;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ProtocolVersion version : ProtocolVersion.values()) {
            builder.put((Object)version.asInt, (Object)version);
        }
        INT_TO_VERSION = builder.build();
    }
}

