/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.ProtocolFeature;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public abstract class RegularStatement
extends Statement {
    private volatile Token routingToken;

    protected RegularStatement() {
    }

    public abstract String getQueryString(CodecRegistry var1);

    public String getQueryString() {
        return this.getQueryString(CodecRegistry.DEFAULT_INSTANCE);
    }

    public abstract ByteBuffer[] getValues(ProtocolVersion var1, CodecRegistry var2);

    public abstract Map<String, ByteBuffer> getNamedValues(ProtocolVersion var1, CodecRegistry var2);

    public abstract boolean hasValues(CodecRegistry var1);

    public abstract boolean usesNamedValues();

    public boolean hasValues() {
        return this.hasValues(CodecRegistry.DEFAULT_INSTANCE);
    }

    @Override
    public Token getRoutingToken() {
        return this.routingToken;
    }

    public RegularStatement setRoutingToken(Token routingToken) {
        this.routingToken = routingToken;
        return this;
    }

    @Override
    public String getKeyspace() {
        return null;
    }

    @Override
    public int requestSizeInBytes(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int size = Frame.Header.lengthFor(protocolVersion);
        try {
            size += CBUtil.sizeOfLongString(this.getQueryString(codecRegistry));
            switch (protocolVersion) {
                case V1: {
                    size += CBUtil.sizeOfConsistencyLevel(this.getConsistencyLevel());
                    break;
                }
                case V2: 
                case V3: 
                case V4: 
                case V5: {
                    size += CBUtil.sizeOfConsistencyLevel(this.getConsistencyLevel());
                    size += Requests.QueryFlag.serializedSize(protocolVersion);
                    if (this.hasValues()) {
                        size = this.usesNamedValues() ? (size += CBUtil.sizeOfNamedValueList(this.getNamedValues(protocolVersion, codecRegistry))) : (size += CBUtil.sizeOfValueList(Arrays.asList(this.getValues(protocolVersion, codecRegistry))));
                    }
                    size += 4;
                    if (this.getPagingState() != null) {
                        size += CBUtil.sizeOfValue(this.getPagingState());
                    }
                    size += CBUtil.sizeOfConsistencyLevel(this.getSerialConsistencyLevel());
                    if (ProtocolFeature.CLIENT_TIMESTAMPS.isSupportedBy(protocolVersion)) {
                        size += 8;
                    }
                    if (ProtocolFeature.CUSTOM_PAYLOADS.isSupportedBy(protocolVersion) && this.getOutgoingPayload() != null) {
                        size += CBUtil.sizeOfBytesMap(this.getOutgoingPayload());
                    }
                    break;
                }
                default: {
                    throw protocolVersion.unsupported();
                }
            }
        }
        catch (Exception e) {
            size = -1;
        }
        return size;
    }

    public String toString() {
        return this.getQueryString();
    }
}

